/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.FunctionDefinition;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.IFilterElementToString;
import Xm.JavaUtils.Database.IFilterElementVisitor;
import Xm.JavaUtils.Database.ParameterDefinition;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
implements IFilterElement {
    private static final long serialVersionUID = -1760327450034454022L;
    private FunctionDefinition function;
    private Map<String, Object> args;

    public FunctionCall(FunctionDefinition function) {
        this.function = function;
        this.args = new TreeMap<String, Object>();
    }

    public FunctionCall(FunctionDefinition function, Map<String, Object> args) {
        this.function = function;
        this.args = new TreeMap<String, Object>(args);
    }

    @Override
    public void accept(IFilterElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString(IFilterElementToString visitor) {
        return visitor.toString(this);
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    public Object getParam(String name) {
        return this.args.get(name);
    }

    public Object[] compileArgumentList() {
        ParameterDefinition[] params = this.function.getParameters();
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = this.args.get(params[i].getName());
            if (result[i] != null) continue;
            throw new IllegalArgumentException("Missing argument for parameter " + params[i].getName());
        }
        return result;
    }

    Map<String, Object> getArguments() {
        return this.args;
    }
}

