/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.ForeignKeyDefinition;
import Xm.JavaUtils.Database.TableDefinition;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ForeignKeys {
    private Map<String, Map<String, Map<String, String>>> m_foreignKeys = new TreeMap<String, Map<String, Map<String, String>>>();

    public void add(String table, String fkTable, String foreignKey, String primaryKey) {
        Map<String, Map<String, String>> fkTables = this.m_foreignKeys.get(table);
        if (fkTables == null) {
            fkTables = new TreeMap<String, Map<String, String>>();
            TreeMap<String, String> foreignKeys = new TreeMap<String, String>();
            foreignKeys.put(foreignKey, primaryKey);
            fkTables.put(fkTable, foreignKeys);
            this.m_foreignKeys.put(table, fkTables);
        } else {
            Map<String, String> foreignKeys = fkTables.get(fkTable);
            if (foreignKeys == null) {
                foreignKeys = new TreeMap<String, String>();
                foreignKeys.put(foreignKey, primaryKey);
                fkTables.put(fkTable, foreignKeys);
                this.m_foreignKeys.put(table, fkTables);
            } else {
                foreignKeys.put(foreignKey, primaryKey);
            }
        }
    }

    public Set getFkTables(String table) {
        Map<String, Map<String, String>> fkTables = this.m_foreignKeys.get(table);
        if (fkTables == null) {
            return new TreeSet();
        }
        return new TreeSet<String>(fkTables.keySet());
    }

    public Map getForeignKeys(String table, String fkTable) {
        Map<String, Map<String, String>> fkTables = this.m_foreignKeys.get(table);
        if (fkTables == null) {
            return new TreeMap();
        }
        Map<String, String> foreignKeys = fkTables.get(fkTable);
        if (foreignKeys == null) {
            return new TreeMap();
        }
        return new TreeMap<String, String>(foreignKeys);
    }

    public static ForeignKeys createCascadeDeleteForeignKeys(DatabaseMetaData metaData) throws SQLException {
        ForeignKeys sortedForeignKeys = new ForeignKeys();
        ResultSet tables = metaData.getTables("", "%", "%", new String[]{"TABLE"});
        while (tables.next()) {
            String table = tables.getString("TABLE_NAME");
            ResultSet foreignKeys = metaData.getExportedKeys("", "", table);
            while (foreignKeys.next()) {
                short deleteRule = foreignKeys.getShort("DELETE_RULE");
                if (deleteRule != 0) continue;
                String fkTable = foreignKeys.getString("FKTABLE_NAME");
                String foreignKey = foreignKeys.getString("FKCOLUMN_NAME");
                String primaryKey = foreignKeys.getString("PKCOLUMN_NAME");
                sortedForeignKeys.add(table, fkTable, foreignKey, primaryKey);
            }
        }
        return sortedForeignKeys;
    }

    public static ForeignKeys createCascadeDeleteForeignKeys(TableDefinition[] tables) {
        ForeignKeys sortedForeignKeys = new ForeignKeys();
        for (int i = 0; i < tables.length; ++i) {
            List<ForeignKeyDefinition> foreignKeys = tables[i].getForeignKeys();
            for (ForeignKeyDefinition foreignKey : foreignKeys) {
                if (foreignKey.getOnDeleteOption() != ForeignKeyDefinition.OnDelete.CASCADE) continue;
                String[] columns = foreignKey.getColumns();
                String[] referencedColumns = foreignKey.getReferencedColumns();
                assert (columns.length == referencedColumns.length);
                for (int j = 0; j < columns.length; ++j) {
                    sortedForeignKeys.add(foreignKey.getReferencedTable(), tables[i].getName(), columns[j], referencedColumns[j]);
                }
            }
        }
        return sortedForeignKeys;
    }
}

