/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteStatementBuilder {
    private List<String> m_tables;
    private List<ISource> m_using;
    private IFilterElement m_whereClauses;
    private int m_beginLimit;
    private int m_maxLimit;
    private Map<String, Object> m_properties;

    public DeleteStatementBuilder() {
        this.m_tables = new ArrayList<String>();
        this.m_using = new ArrayList<ISource>();
        this.m_beginLimit = -1;
        this.m_maxLimit = -1;
        this.m_properties = new HashMap<String, Object>();
    }

    public DeleteStatementBuilder(DeleteStatement statement) {
        this.m_tables = statement.tables();
        this.m_using = statement.using();
        this.m_whereClauses = statement.getFilter();
        this.m_beginLimit = statement.beginLimit();
        this.m_maxLimit = statement.maxLimit();
        this.m_properties = statement.cloneProperties();
    }

    public void applyProperties(Map<String, Object> properties) {
        this.m_properties.putAll(properties);
    }

    public void addTable(String table) {
        this.m_tables.add(table);
    }

    public void addUsingTable(ISource table) {
        this.m_using.add(table);
    }

    public void setFilter(IFilterElement filter) {
        this.m_whereClauses = filter;
    }

    public void limit(int maxLimit) {
        this.m_beginLimit = -1;
        this.m_maxLimit = maxLimit;
    }

    public void limit(int beginLimit, int maxLimit) {
        this.m_beginLimit = beginLimit;
        this.m_maxLimit = maxLimit;
    }

    public DeleteStatement build() {
        return new DeleteStatement(this.m_tables, this.m_using, this.m_whereClauses, this.m_beginLimit, this.m_maxLimit, this.m_properties);
    }
}

