/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.SqlStatementToString;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SqlWriteStatementVisitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteStatement
extends SqlWriteStatement {
    private static final long serialVersionUID = 7170011051976422313L;
    private List<String> m_tables;
    private List<ISource> m_using;
    private final IFilterElement m_filter;
    private final int m_beginLimit;
    private final int m_maxLimit;
    public static final int NO_LIMIT = -1;

    public DeleteStatement(List<String> tables, List<ISource> using, IFilterElement filter) {
        this(tables, using, filter, -1, -1, null);
    }

    public DeleteStatement(List<String> tables, List<ISource> using, IFilterElement filter, int beginLimit, int maxLimit) {
        this(tables, using, filter, beginLimit, maxLimit, null);
    }

    public DeleteStatement(List<String> tables, List<ISource> using, IFilterElement filter, int beginLimit, int maxLimit, Map<String, Object> properties) {
        super(properties);
        this.m_tables = new ArrayList<String>(tables);
        this.m_using = new ArrayList<ISource>(using);
        this.m_filter = filter;
        this.m_beginLimit = beginLimit;
        this.m_maxLimit = maxLimit;
    }

    public List<String> tables() {
        return Collections.unmodifiableList(this.m_tables);
    }

    public List<ISource> using() {
        return Collections.unmodifiableList(this.m_using);
    }

    public IFilterElement getFilter() {
        return this.m_filter;
    }

    public int beginLimit() {
        return this.m_beginLimit;
    }

    public int maxLimit() {
        return this.m_maxLimit;
    }

    @Override
    public String toString(SqlStatementToString visitor) {
        return visitor.toString(this);
    }

    @Override
    public void accept(SqlWriteStatementVisitor visitor) throws SQLException, DbConnectException {
        visitor.visit(this);
    }
}

