/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractSqlStatementTransform;
import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.CompositeFilterElement;
import Xm.JavaUtils.Database.Counters;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.ISource;
import Xm.JavaUtils.Database.IndexDefinition;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.Join;
import Xm.JavaUtils.Database.OpEqual;
import Xm.JavaUtils.Database.OpLessEqual;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SequenceNumberProperty;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.SqlStatementTransform;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import Xm.JavaUtils.Database.TableInfo;
import Xm.JavaUtils.Database.Value;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteLogger
implements SqlStatementTransform {
    public static final String DELETE_LOG_TABLE_SUFFIX = "_delete_log";
    public static final String COLUMN_TIMESTAMP = "Timestamp";
    private static final String COUNTER_EFFECTIVE_CLEANUP = "DeleteLoggerEffectiveCleanUp";
    private static Counters counters = new Counters();
    private Map<String, List<String>> tableNameToKeysMap;
    private TimestampProvider timestampProvider;

    public DeleteLogger(TableInfo[] tableDefinitions) {
        this(tableDefinitions, new TimestampProvider(){

            public long currentTime() {
                return System.currentTimeMillis() / 1000L;
            }
        });
    }

    public DeleteLogger(TableInfo[] tableDefinitions, TimestampProvider timestampProvider) {
        this.timestampProvider = timestampProvider;
        this.tableNameToKeysMap = new HashMap<String, List<String>>();
        for (TableInfo table : tableDefinitions) {
            this.tableNameToKeysMap.put(table.getName(), table.globallyUniqueKey());
        }
    }

    public static String getDeleteLogTableName(String baseTableName) {
        return baseTableName + DELETE_LOG_TABLE_SUFFIX;
    }

    public static TableDefinition getDeleteLogTableDefinition(TableInfo tableInfo) {
        TableDefinition baseTableDef = tableInfo.getTableDefinition();
        TableDefinition table = new TableDefinition(DeleteLogger.getDeleteLogTableName(baseTableDef.getName()));
        for (String key : tableInfo.globallyUniqueKey()) {
            table.addColumn(baseTableDef.getColumnDefinition(key));
            table.addPrimaryKey(key);
        }
        table.addColumn(ColumnDefinition.column("SequenceNumber", ColumnDefinition.Type.LONGINT, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addColumn(ColumnDefinition.column(COLUMN_TIMESTAMP, ColumnDefinition.Type.DATE, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addIndex(IndexDefinition.index("SequenceNumber", "SequenceNumber"));
        return table;
    }

    public void reapply(DbConnection con, String table) throws SQLException, DbConnectException {
        OpLessEqual filter = SqlFilter.lessEqual(SqlFilter.column(table, "SequenceNumber"), SqlFilter.column(DeleteLogger.getDeleteLogTableName(table), "SequenceNumber"));
        con.execute(this.makeDeleteStatement(table, filter));
    }

    private DeleteStatement makeDeleteStatement(String table, IFilterElement filter) {
        DeleteStatementBuilder deleteBuilder = new DeleteStatementBuilder();
        deleteBuilder.addTable(table);
        String deleteLogTableName = DeleteLogger.getDeleteLogTableName(table);
        Join join = Join.inner((ISource)new Table(deleteLogTableName), (ISource)new Table(table), this.keyEqualityFilter(table));
        deleteBuilder.addUsingTable(join);
        if (filter != null) {
            deleteBuilder.setFilter(filter);
        }
        return deleteBuilder.build();
    }

    private IFilterElement keyEqualityFilter(String table) {
        CompositeFilterElement filter = null;
        for (String key : this.tableNameToKeysMap.get(table)) {
            OpEqual keyFilter = SqlFilter.equal(SqlFilter.column(table + "." + key), SqlFilter.column(DeleteLogger.getDeleteLogTableName(table) + "." + key));
            if (filter == null) {
                filter = keyFilter;
                continue;
            }
            filter = SqlFilter.and(filter, keyFilter);
        }
        return filter;
    }

    private long getCleanupLimit(DbConnection con, String table, long retentionPeriod) throws SQLException, DbConnectException {
        long timeLimit = this.timestampProvider.currentTime() - retentionPeriod;
        SelectStatementBuilder select = new SelectStatementBuilder();
        select.addMax("SequenceNumber");
        select.addTable(new Table(DeleteLogger.getDeleteLogTableName(table)));
        select.setFilter(SqlFilter.less(SqlFilter.column(COLUMN_TIMESTAMP), SqlFilter.value(new Timestamp(timeLimit * 1000L))));
        ResultSet result = con.execute(select.build());
        result.next();
        long seqNum = result.getLong(1);
        return seqNum;
    }

    public void cleanup(DbConnection con, String table, long retentionPeriod) throws SQLException, DbConnectException {
        long limit = this.getCleanupLimit(con, table, retentionPeriod);
        DeleteLogger.cleanupBySeqNum(con, table, limit);
    }

    public static void cleanupBySeqNum(DbConnection con, String table, long seqNumLimit) throws SQLException, DbConnectException {
        DeleteLogger.updateEffectiveCleanupCounter(con, table, seqNumLimit);
        DeleteStatementBuilder delete = new DeleteStatementBuilder();
        delete.addTable(DeleteLogger.getDeleteLogTableName(table));
        delete.setFilter(SqlFilter.lessEqual(SqlFilter.column("SequenceNumber"), SqlFilter.value(seqNumLimit)));
        con.execute(delete.build());
    }

    private static void updateEffectiveCleanupCounter(DbConnection con, String table, long limit) throws SQLException, DbConnectException {
        Long currentValue = counters.queryLong(con, COUNTER_EFFECTIVE_CLEANUP, table);
        if (currentValue == null) {
            counters.initLong(con, COUNTER_EFFECTIVE_CLEANUP, table, limit);
        } else {
            counters.setLong(con, COUNTER_EFFECTIVE_CLEANUP, table, Math.max(currentValue, limit));
        }
    }

    public static long getMaximumEffectiveCleanupSeqNum(DbConnection con) throws SQLException, DbConnectException {
        return counters.getMaxLong(con, COUNTER_EFFECTIVE_CLEANUP);
    }

    public static long getEffectiveCleanupSeqNum(DbConnection con, String table) throws SQLException, DbConnectException {
        Long value = counters.queryLong(con, COUNTER_EFFECTIVE_CLEANUP, table);
        return value == null ? 0L : value;
    }

    public static void purge(DbConnection con, String table) throws SQLException, DbConnectException {
        DeleteStatementBuilder delete = new DeleteStatementBuilder();
        delete.addTable(DeleteLogger.getDeleteLogTableName(table));
        con.execute(delete.build());
        counters.erase(con, COUNTER_EFFECTIVE_CLEANUP, table);
    }

    @Override
    public SqlWriteStatement transform(SqlWriteStatement statement) throws SQLException, DbConnectException {
        Transformer transformer = new Transformer();
        statement.accept(transformer);
        return transformer.getTransformedStatement();
    }

    private SqlWriteStatement makeInsertAndDeleteStatements(DeleteStatement deleteStatement) {
        List<String> affectedTables = deleteStatement.tables();
        long sequenceNumber = SequenceNumberProperty.get(deleteStatement.getProperties());
        Timestamp timestamp = new Timestamp(this.timestampProvider.currentTime() * 1000L);
        SqlWriteStatement[] resultStatements = new SqlWriteStatement[affectedTables.size() * 2];
        int index = 0;
        for (String table : affectedTables) {
            List<String> keys = this.tableNameToKeysMap.get(table);
            SelectStatement select = this.makeSelectStatement(deleteStatement, table, sequenceNumber, timestamp);
            InsertStatementBuilder insertTempBuilder = new InsertStatementBuilder();
            insertTempBuilder.table(DeleteLogger.getDeleteLogTableName(table));
            ArrayList<String> columns = new ArrayList<String>(keys);
            columns.add("SequenceNumber");
            columns.add(COLUMN_TIMESTAMP);
            insertTempBuilder.setSelectClause(select, columns);
            insertTempBuilder.addUpdateValue("SequenceNumber", sequenceNumber);
            insertTempBuilder.addUpdateValue(COLUMN_TIMESTAMP, timestamp);
            resultStatements[index++] = insertTempBuilder.build();
        }
        for (String table : affectedTables) {
            OpEqual filter = SqlFilter.equal(SqlFilter.column(DeleteLogger.getDeleteLogTableName(table) + "." + "SequenceNumber"), SqlFilter.value(sequenceNumber));
            resultStatements[index++] = this.makeDeleteStatement(table, filter);
        }
        return new BatchStatement(resultStatements, true);
    }

    private SelectStatement makeSelectStatement(DeleteStatement deleteStatement, String table, long sequenceNumber, Timestamp timestamp) {
        SelectStatementBuilder selectBuilder = new SelectStatementBuilder();
        List<ISource> usingClause = deleteStatement.using();
        if (!usingClause.isEmpty()) {
            for (ISource source : usingClause) {
                selectBuilder.addTable(source);
            }
        } else {
            selectBuilder.addTable(new Table(table));
        }
        selectBuilder.setFilter(deleteStatement.getFilter());
        for (String key : this.tableNameToKeysMap.get(table)) {
            selectBuilder.addColumn(table + "." + key);
        }
        selectBuilder.addColumn(Long.toString(sequenceNumber));
        selectBuilder.addColumn(new Value(timestamp));
        selectBuilder.limit(deleteStatement.beginLimit(), deleteStatement.maxLimit());
        return selectBuilder.build();
    }

    public static <T> boolean containsNone(Set<T> set, Collection<T> collection) {
        for (T item : collection) {
            if (!set.contains(item)) continue;
            return false;
        }
        return true;
    }

    private class Transformer
    extends AbstractSqlStatementTransform {
        private Transformer() {
        }

        public void visit(DeleteStatement deleteStatement) {
            Set tableWithDeleteLog = DeleteLogger.this.tableNameToKeysMap.keySet();
            if (tableWithDeleteLog.containsAll(deleteStatement.tables())) {
                this.transformedStatement = DeleteLogger.this.makeInsertAndDeleteStatements(deleteStatement);
            } else if (DeleteLogger.containsNone(tableWithDeleteLog, deleteStatement.tables())) {
                this.transformedStatement = deleteStatement;
            } else {
                throw new IllegalArgumentException("Cannot mix tables with and without delete log");
            }
        }
    }

    static interface TimestampProvider {
        public long currentTime();
    }
}

