/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.DbComponentInstance;
import Xm.FaultTolerance.DbSynchronizationFailed;
import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DatabaseManager;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbVersionMismatchException;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.LockTablesStatement;
import Xm.JavaUtils.Database.LockTablesStatementBuilder;
import Xm.JavaUtils.Database.OpEqual;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.UnlockTablesStatement;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.UnreconciliablePartitionException;
import Xm.JavaUtils.ValidatorI;
import Xm.JavaUtils.Validators;
import Xm.JavaUtils.Version;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.omg.CORBA.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbSynchronizer {
    protected SingletonFileLogger m_FileLogger = SingletonFileLogger.GetInstance();
    protected ValidatorI m_ServiceActive;

    public DbSynchronizer() {
        this.m_ServiceActive = Validators.ServiceIsNotStopping();
    }

    public DbSynchronizer(ValidatorI ServiceIsActive) {
        this.m_ServiceActive = ServiceIsActive;
    }

    public abstract boolean backupAndClearAllTables(DbConnection var1);

    public void ReconcileFromPartition() throws UnreconciliablePartitionException {
        throw new UnreconciliablePartitionException();
    }

    protected abstract void DoSynchronizeWithoutLock(DbConnection var1, DbConnection var2, DbComponentInstance var3) throws SQLException, DbConnectException, DbSynchronizationFailed;

    protected abstract String[] TablesToLock(DbConnection var1) throws SQLException, DbConnectException;

    protected abstract void DoSynchronizeWithLock(DbConnection var1, DbConnection var2) throws SQLException, DbConnectException, DbSynchronizationFailed;

    protected abstract void DoBecomePrimary(DatabaseManager var1) throws DbConnectException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Synchronize(DbConnection localCon, DbConnection sourceCon, String localDatabaseId, DbComponentInstance primaryInstance, DbComponentInstance localInstance) throws DbSynchronizationFailed, DbConnectException, DbVersionMismatchException, UnreconciliablePartitionException {
        String LOG_GUARD = "DbSynchronizer::Synchronize...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-007", "DbSynchronizer::Synchronize...");
        boolean sourceIsLocked = false;
        DbConnection.Lock lock = null;
        try {
            this.AssertSameDatabaseVersion(localCon, sourceCon);
            this.DoSynchronizeWithoutLock(localCon, sourceCon, primaryInstance);
            lock = sourceCon.getLock();
            sourceCon.setAutoCommit(false);
            this.LockTables(sourceCon, LockTablesStatement.LockType.READ);
            sourceIsLocked = true;
            this.DoSynchronizeWithLock(localCon, sourceCon);
            primaryInstance.NotifyRecovered(localInstance, localDatabaseId);
            this.UnlockTables(sourceCon);
            sourceIsLocked = false;
            sourceCon.commit();
            sourceCon.setAutoCommit(true);
            this.m_FileLogger.LogWriteLowLevel("XMJU20-008", "DbSynchronizer::Synchronize...Done");
        }
        catch (SQLException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-009", "DbSynchronizer::Synchronize...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-009", "SQLException: " + e.getMessage());
            throw new DbSynchronizationFailed(e.getMessage() == null ? "" : e.getMessage());
        }
        catch (DbConnectException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-010", "DbSynchronizer::Synchronize...Error: DbConnectException");
            throw e;
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-011", "DbSynchronizer::Synchronize...Error: CORBA.SystemException: " + e.toString());
            throw e;
        }
        finally {
            try {
                if (sourceIsLocked) {
                    this.UnlockTables(sourceCon);
                }
            }
            catch (SQLException ex) {
            }
            catch (DbConnectException ex) {
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public void BecomePrimary(DatabaseManager manager) throws DbConnectException, SQLException {
        this.DoBecomePrimary(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void SynchronizeLastLine(DatabaseManager manager, String tableName, String uniqueIdColumnName, boolean deleteExtraLine) throws DbConnectException, SQLException {
        DbConnection sourceCon = null;
        DbConnection localCon = null;
        try {
            long localMax;
            sourceCon = manager.localConnection();
            localCon = manager.localConnection();
            SelectStatementBuilder ssb = new SelectStatementBuilder();
            ssb.addColumn("MAX(" + uniqueIdColumnName + ")");
            ssb.addTable(new Table(tableName));
            SelectStatement maxQuery = ssb.build();
            ResultSet maxResult = localCon.execute(maxQuery);
            long lowestMax = localMax = maxResult.next() ? maxResult.getLong(1) : 0L;
            long highestMax = localMax;
            Map<String, DbConnection> backupConnections = null;
            try {
                backupConnections = manager.backupConnections();
                for (Map.Entry<String, DbConnection> backup : backupConnections.entrySet()) {
                    try {
                        long max;
                        DbConnection currentCon = backup.getValue();
                        maxResult = currentCon.execute(maxQuery);
                        long l = max = maxResult.next() ? maxResult.getLong(1) : 0L;
                        if (max > highestMax) {
                            highestMax = max;
                            sourceCon = currentCon;
                        }
                        lowestMax = Math.min(lowestMax, max);
                    }
                    catch (DbConnectException e) {
                        manager.remoteDatabaseFailed(backup.getKey());
                    }
                    catch (SQLException e) {
                        manager.remoteDatabaseFailed(backup.getKey());
                    }
                }
            }
            finally {
                this.CloseAllConnections(backupConnections);
            }
            if (highestMax == lowestMax) {
                return;
            }
            ssb = new SelectStatementBuilder();
            ssb.addColumn("*");
            ssb.addTable(new Table(tableName));
            SelectStatement ss = ssb.build();
            DeleteStatementBuilder deleteStmt = new DeleteStatementBuilder();
            deleteStmt.addTable(tableName);
            OpEqual filter = SqlFilter.equal(SqlFilter.column(uniqueIdColumnName), SqlFilter.value(highestMax));
            deleteStmt.setFilter(filter);
            switch ((int)(highestMax - localMax)) {
                case 0: {
                    if (!deleteExtraLine) break;
                    localCon.execute(deleteStmt.build());
                    break;
                }
                case 1: {
                    if (deleteExtraLine) break;
                    this.AddMissingRecords(localCon, tableName, sourceCon.execute(ss));
                    break;
                }
                default: {
                    throw new SQLException("Local table " + tableName + " has more than one record to update");
                }
            }
            backupConnections = null;
            try {
                backupConnections = manager.backupConnections();
                block25: for (Map.Entry<String, DbConnection> backup : backupConnections.entrySet()) {
                    try {
                        DbConnection currentCon = backup.getValue();
                        maxResult = currentCon.execute(maxQuery);
                        long max = maxResult.next() ? maxResult.getLong(1) : 0L;
                        switch ((int)(highestMax - max)) {
                            case 0: {
                                if (!deleteExtraLine) continue block25;
                                currentCon.execute(deleteStmt.build());
                                break;
                            }
                            case 1: {
                                if (deleteExtraLine) continue block25;
                                this.AddMissingRecords(currentCon, tableName, sourceCon.execute(ss));
                                break;
                            }
                            default: {
                                manager.remoteDatabaseFailed(backup.getKey());
                                break;
                            }
                        }
                    }
                    catch (DbConnectException e) {
                        manager.remoteDatabaseFailed(backup.getKey());
                    }
                    catch (SQLException e) {
                        manager.remoteDatabaseFailed(backup.getKey());
                    }
                }
            }
            finally {
                this.CloseAllConnections(backupConnections);
            }
        }
        finally {
            ConnectionUtils.close(sourceCon);
            ConnectionUtils.close(localCon);
        }
    }

    protected void CloseAllConnections(Map<String, DbConnection> connections) {
        if (connections != null) {
            ConnectionUtils.close(connections.values());
        }
    }

    protected int AddMissingRecords(DbConnection con, String tableName, ResultSet results) throws SQLException, DbConnectException {
        String LOG_GUARD = "DbBackupUpdater - AddMissingRecords in table " + tableName + "...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-016", LOG_GUARD);
        ResultSetMetaData tableMetaData = results.getMetaData();
        int nbColumns = tableMetaData.getColumnCount();
        String[] columnNames = new String[nbColumns];
        for (int i = 0; i < nbColumns; ++i) {
            columnNames[i] = tableMetaData.getColumnName(i + 1);
        }
        int added = 0;
        while (results.next() && this.m_ServiceActive.Validate()) {
            InsertStatementBuilder insertStmt = new InsertStatementBuilder();
            insertStmt.table(tableName);
            for (int i = 0; i < nbColumns; ++i) {
                String value = results.getString(i + 1);
                if (results.wasNull()) {
                    insertStmt.addNullValue(columnNames[i]);
                    continue;
                }
                insertStmt.addValue(columnNames[i], value);
            }
            con.execute(insertStmt.build());
            ++added;
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU20-017", LOG_GUARD + "Done");
        return added;
    }

    protected boolean IsResultIdentical(ResultSet result1, ResultSet result2, int nbColumns) throws SQLException {
        boolean isIdentical = true;
        for (int i = 1; isIdentical && i <= nbColumns; ++i) {
            String value1 = result1.getString(i);
            String value2 = result2.getString(i);
            if (value1 != null && value2 != null) {
                isIdentical = value1.equals(value2);
                continue;
            }
            if (value1 != null) {
                isIdentical = value1.equals("") || value1.equals("0");
                continue;
            }
            if (value2 == null) continue;
            isIdentical = value2.equals("") || value2.equals("0");
        }
        return isIdentical;
    }

    public void LockTables(DbConnection con, LockTablesStatement.LockType lockType) throws SQLException, DbConnectException {
        String LOG_GUARD = "DbSynchronizer::LockTables...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-012", "DbSynchronizer::LockTables...");
        if (con.getAutoCommit()) {
            String msg = "Connection must not be in AutoCommit mode in order to lock tables";
            this.m_FileLogger.LogWriteFatalError("XMJU20-026", msg);
            throw new IllegalStateException(msg);
        }
        LockTablesStatementBuilder builder = new LockTablesStatementBuilder();
        for (String table : this.TablesToLock(con)) {
            builder.addTable(table, lockType);
        }
        con.execute(builder.build());
        this.m_FileLogger.LogWriteLowLevel("XMJU20-013", "DbSynchronizer::LockTables...Done");
    }

    public void UnlockTables(DbConnection con) throws SQLException, DbConnectException {
        String LOG_GUARD = "DbSynchronizer::UnlockTables...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-014", "DbSynchronizer::UnlockTables...");
        con.execute(new UnlockTablesStatement());
        this.m_FileLogger.LogWriteLowLevel("XMJU20-015", "DbSynchronizer::UnlockTables...Done");
    }

    private void AssertSameDatabaseVersion(DbConnection localCon, DbConnection sourceCon) throws DbVersionMismatchException, DbConnectException {
        String LOG_GUARD = "DbSynchronizer::ValidateVersion...";
        this.m_FileLogger.LogWriteLowLevel("XMJU20-000", "DbSynchronizer::ValidateVersion...");
        Version localVersion = null;
        try {
            localVersion = this.GetVersion(localCon);
            if (localVersion == null) {
                this.m_FileLogger.LogWriteFatalError("XMJU20-001", "DbSynchronizer::ValidateVersion...Error");
                this.m_FileLogger.LogWriteFatalError("XMJU20-001", "Unable to get local database version");
                throw new DbVersionMismatchException("Unable to get local database version");
            }
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-002", "DbSynchronizer::ValidateVersion...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-002", "Unable to connect to local database");
            throw ex;
        }
        Version sourceVersion = null;
        try {
            sourceVersion = this.GetVersion(sourceCon);
            if (sourceVersion == null) {
                this.m_FileLogger.LogWriteFatalError("XMJU20-003", "DbSynchronizer::ValidateVersion...Error");
                this.m_FileLogger.LogWriteFatalError("XMJU20-003", "Unable to get source database version");
                throw new DbVersionMismatchException("Unable to get source database version");
            }
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-004", "DbSynchronizer::ValidateVersion...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU20-004", "Unable to connect to source database");
            throw ex;
        }
        if (localVersion.compareTo(sourceVersion) != 0) {
            this.m_FileLogger.LogWriteFatalError("XMJU20-005", "DbSynchronizer::ValidateVersion...Error");
            StringBuffer buf = new StringBuffer();
            buf.append("Database version mismatch: cannot synchronize the local database (");
            buf.append(localVersion.toString());
            buf.append(") with the source database (");
            buf.append(sourceVersion.toString());
            buf.append(")");
            this.m_FileLogger.LogWriteFatalError("XMJU20-005", buf.toString());
            throw new DbVersionMismatchException(buf.toString());
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU20-006", "DbSynchronizer::ValidateVersion...Done");
    }

    private Version GetVersion(DbConnection con) throws DbConnectException {
        Version version = null;
        try {
            SelectStatementBuilder ssb = new SelectStatementBuilder();
            ssb.addColumn("DatabaseVersion");
            ssb.addTable(new Table("Version"));
            ResultSet result = con.execute(ssb.build());
            if (result.next()) {
                String value = result.getString(1);
                if (!result.wasNull()) {
                    version = Version.fromString(value);
                }
            }
            result.close();
        }
        catch (SQLException ex) {
        }
        catch (NullPointerException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return version;
    }
}

