/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.ComponentGroupInfo;
import Xm.FaultTolerance.ComponentInstance;
import Xm.FaultTolerance.ComponentInstanceInfo;
import Xm.FaultTolerance.ComponentInstanceMembership;
import Xm.FaultTolerance.ComponentInstancePackage.InstanceFailed;
import Xm.FaultTolerance.ComponentInstancePackage.InstanceFailedCause;
import Xm.FaultTolerance.ComponentInstancePackage.NoGroupMemberActive;
import Xm.FaultTolerance.ComponentInstancePackage.UnknownGroup;
import Xm.FaultTolerance.ComponentInstancePackage.UnsupportedFacet;
import Xm.FaultTolerance.ComponentInstanceStatus;
import Xm.FaultTolerance.DatabaseInfo;
import Xm.FaultTolerance.DbComponentInstance;
import Xm.FaultTolerance.DbComponentInstanceHelper;
import Xm.FaultTolerance.DbComponentInstancePOA;
import Xm.FaultTolerance.DbSynchronizationFailed;
import Xm.FaultTolerance.Heartbeat.Monitor;
import Xm.FaultTolerance.Heartbeat.Subscription;
import Xm.FaultTolerance.Heartbeat.UnsupportedInterval;
import Xm.FaultTolerance.PartGroupInfo;
import Xm.FaultTolerance.System;
import Xm.FaultTolerance.SystemHelper;
import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DatabaseManager;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.DbSynchronizer;
import Xm.JavaUtils.Database.DbVersionMismatchException;
import Xm.JavaUtils.Database.FacetManager;
import Xm.JavaUtils.Database.LockTablesStatement;
import Xm.JavaUtils.Database.MySqlDbConnectionFactory;
import Xm.JavaUtils.Database.ReplicaStateImpl;
import Xm.JavaUtils.Database.SeqNumManager;
import Xm.JavaUtils.Database.SqlStatementExecute;
import Xm.JavaUtils.Database.StatementExecutorImpl;
import Xm.JavaUtils.Database.SystemView;
import Xm.JavaUtils.DirectoryHelper;
import Xm.JavaUtils.HostList;
import Xm.JavaUtils.JavaRegistry;
import Xm.JavaUtils.Port;
import Xm.JavaUtils.ReplicatedService;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.UnreconciliablePartitionException;
import Xm.JavaUtils.ValidatorI;
import Xm.JavaUtils.Validators;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.FT.Property;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class DbReplicationComponent
extends DbComponentInstancePOA {
    private final ReplicatedService m_Service;
    private DatabaseManager m_DbManager;
    private final NameComponent[] m_LocationId;
    private NameComponent[] m_ComponentGroupId;
    private Property[] m_ComponentDescription;
    private String m_strComponentType;
    private System m_ReplicationManager;
    private DbComponentInstance m_PrimaryInstance;
    private DbSynchronizer m_DbSynchronizer;
    private SingletonFileLogger m_FileLogger;
    private ORB m_Orb;
    private POA m_Poa;
    private byte[] m_ObjectId;
    private ReplicaStateImpl replicaState;
    private HostList.HostListIterator m_HostIterator = new HostList().createIterator();
    private AtomicBoolean activationInProgress = new AtomicBoolean(false);
    private AtomicBoolean activated = new AtomicBoolean(false);
    private FacetManager facetManager = new FacetManager();
    private ValidatorI replicaIsActivePrimary;
    private final String version;

    public DbReplicationComponent(int iServiceType, ReplicatedService TheService, String strServiceName, String version) {
        this.m_FileLogger = SingletonFileLogger.GetInstance();
        this.replicaState = new ReplicaStateImpl(iServiceType);
        this.replicaIsActivePrimary = new ValidatorI(){

            public boolean Validate() {
                return DbReplicationComponent.this.replicaState.currentState() == 1 && Validators.ServiceIsNotStopping().Validate();
            }
        };
        this.m_strComponentType = DbReplicationComponent.getComponentType(iServiceType);
        this.version = version;
        this.m_Service = TheService;
        this.m_LocationId = DbReplicationComponent.getLocationId(strServiceName, DbReplicationComponent.getComponentName(iServiceType));
    }

    public ValidatorI replicaIsActivePrimary() {
        return this.replicaIsActivePrimary;
    }

    private boolean isStopping() {
        return !Validators.ServiceIsNotStopping().Validate();
    }

    private static String getComponentType(int serviceType) {
        switch (serviceType) {
            case 0: {
                return "Archive";
            }
            case 1: {
                return "CompanyConfig";
            }
            case 2: {
                return "Phonebook";
            }
            case 3: {
                return "FaxBoxConfig";
            }
        }
        return "";
    }

    private static String getComponentName(int serviceType) {
        switch (serviceType) {
            case 0: {
                return "Archive";
            }
            case 1: {
                return "CompanyConfig";
            }
            case 2: {
                return "Phonebook";
            }
            case 3: {
                return "FaxBoxConfig";
            }
        }
        return "";
    }

    public static NameComponent[] getLocationId(String serviceName, String componentName) {
        String hostGuid = JavaRegistry.GetRegistryString(3, "SOFTWARE\\Interstar Technologies\\XMedius\\Guids", "Host");
        return DbReplicationComponent.getLocationId(serviceName, componentName, hostGuid);
    }

    public static NameComponent[] getLocationId(String serviceName, String componentName, String hostGuid) {
        NameComponent[] locationId = new NameComponent[3];
        locationId[0] = new NameComponent();
        locationId[0].kind = "Host";
        locationId[0].id = hostGuid;
        locationId[1] = new NameComponent();
        locationId[1].kind = "Service";
        locationId[1].id = serviceName;
        locationId[2] = new NameComponent();
        locationId[2].kind = "ComponentId";
        locationId[2].id = componentName;
        return locationId;
    }

    private Property[] getComponentDescription() {
        Property[] description = new Property[]{new Property()};
        description[0].nam = new NameComponent[1];
        description[0].nam[0] = new NameComponent();
        description[0].nam[0].id = "Version";
        description[0].nam[0].kind = "PropertyName";
        description[0].val = this.m_Orb.create_any();
        description[0].val.insert_string(this.version);
        return description;
    }

    private void Activate(int replicaState) throws InstanceFailed {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-006", "DbReplicationComponent.Activate()");
        if (!this.activationInProgress.compareAndSet(false, true)) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-113", "Cannot activate now, another thread is performing activation");
            throw new InstanceFailed(InstanceFailedCause.UNABLE_TO_SETSTATE, "Cannot activate now, another thread is performing activation");
        }
        String strType = null;
        try {
            if (!this.PrepareDatabase()) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-094", "DbReplicationComponent - Database preparation failed");
                throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "Database preparation failed");
            }
            if (replicaState == 1) {
                strType = "primary";
                this.activateAsPrimary();
            } else if (replicaState == 2) {
                strType = "backup";
                this.activateAsBackup();
            } else {
                throw new IllegalArgumentException("invalid replica state");
            }
            this.m_FileLogger.LogWriteNormal("XMJU02-011", "DbReplicationComponent - Initializing as a " + strType + " component...Done");
        }
        catch (DbSynchronizationFailed ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-012", "DbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-012", ex.Message);
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, ex.Message);
        }
        catch (UnreconciliablePartitionException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-099", "DbReplicationComponent - Initializing as a " + strType + " component...Error");
            throw new InstanceFailed(InstanceFailedCause.SYSTEM_PARTITION_DETECTED, "Unreconciliable partition");
        }
        catch (DbVersionMismatchException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-093", "DbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-093", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.VERSION_MISMATCH, ex.getMessage());
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", "DbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", "DbReplicationComponent - Database unreachable");
            this.m_FileLogger.LogWriteFatalError("XMJU02-095", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "DbConnectException");
        }
        catch (SQLException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-109", "DbReplicationComponent - Initializing as a " + strType + " component...Error");
            this.m_FileLogger.LogWriteFatalError("XMJU02-109", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "SQLException");
        }
        finally {
            this.activationInProgress.set(false);
        }
    }

    private void activateAsPrimary() throws DbConnectException, SQLException {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-007", "DbReplicationComponent.activateAsPrimary()");
        this.m_DbSynchronizer.BecomePrimary(this.m_DbManager);
        this.m_FileLogger.LogWriteLowLevel("XMJU02-008", "DbReplicationComponent.activateAsPrimary() Done");
    }

    private void activateAsBackup() throws DbSynchronizationFailed, DbVersionMismatchException, SQLException, DbConnectException, UnreconciliablePartitionException {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-009", "Starting database recovery");
        this.Recover();
        this.m_FileLogger.LogWriteLowLevel("XMJU02-010", "Database recovery...done");
    }

    private synchronized void Sleep() {
        try {
            this.wait(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String StringifyMembershipAndStatus(ComponentInstanceMembership Membership2, ComponentInstanceStatus Status2) {
        String status;
        String membership;
        switch (Membership2.value()) {
            case 0: {
                membership = "Primary";
                break;
            }
            case 1: {
                membership = "Backup";
                break;
            }
            case 2: {
                membership = "StandBy";
                break;
            }
            case 3: {
                membership = "None";
                break;
            }
            default: {
                membership = "";
            }
        }
        switch (Status2.value()) {
            case 0: {
                status = "Fault";
                break;
            }
            case 1: {
                status = "Recovering";
                break;
            }
            case 2: {
                status = "Active";
                break;
            }
            default: {
                status = "";
            }
        }
        return "Status: " + status + " - Membership: " + membership;
    }

    private void UpdateBackupAndPrimaryLists(ComponentGroupInfo NewInfo) {
        try {
            TreeMap<String, DatabaseInfo> databaseInfos = new TreeMap<String, DatabaseInfo>();
            TreeMap<String, DbComponentInstance> instances = new TreeMap<String, DbComponentInstance>();
            String message = "Updating GroupInfo (" + NewInfo.Instances.length + " instances)";
            this.m_FileLogger.LogWriteNormal("XMJU02-019", message);
            for (int i = 0; i < NewInfo.Instances.length; ++i) {
                String instanceDbId;
                message = "Updating GroupInfo (processing instance " + i + " - " + DbReplicationComponent.StringifyMembershipAndStatus(NewInfo.Instances[i].Membership, NewInfo.Instances[i].Status) + ")";
                this.m_FileLogger.LogWriteNormal("XMJU02-020", message);
                DbComponentInstance instance = DbComponentInstanceHelper.narrow(NewInfo.Instances[i].TheComponent);
                if (instance == null) {
                    if (NewInfo.Instances[i].Membership != ComponentInstanceMembership.MEMBER_PRIMARY) continue;
                    this.m_FileLogger.LogWriteWarning("XMJU02-021", "Updating GroupInfo (MEMBER_PRIMARY is null)");
                    continue;
                }
                if (NewInfo.Instances[i].Status != ComponentInstanceStatus.STATUS_ACTIVE) continue;
                if (NewInfo.Instances[i].Membership == ComponentInstanceMembership.MEMBER_PRIMARY) {
                    this.m_PrimaryInstance = instance;
                    continue;
                }
                if (NewInfo.Instances[i].Membership != ComponentInstanceMembership.MEMBER_BACKUP || (instanceDbId = instance.DatabaseId()).equals(this.DatabaseId())) continue;
                databaseInfos.put(instanceDbId, instance.DbInfo());
                instances.put(instanceDbId, instance);
            }
            this.m_DbManager.updateBackupList(databaseInfos, instances);
            this.m_FileLogger.LogWriteNormal("XMJU02-031", "Updating GroupInfo - Done");
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-029", "Updating GroupInfo - System exception: " + e.toString());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveComponentGroupId(NameComponent[] GroupId) {
        File TheDir = new File(DirectoryHelper.GetDataFolder("Replication/" + this.m_strComponentType));
        File TheFile = new File(TheDir.getPath() + "/GroupId.dat");
        FileOutputStream ofstream = null;
        ObjectOutputStream object_stream = null;
        try {
            TheDir.mkdirs();
            TheFile.createNewFile();
            ofstream = new FileOutputStream(TheFile);
            object_stream = new ObjectOutputStream(ofstream);
            object_stream.writeObject(GroupId);
            object_stream.flush();
        }
        catch (IOException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-031", "DbReplicationComponent - SaveComponentGroupId - IOException: " + e.getMessage());
        }
        finally {
            try {
                if (object_stream != null) {
                    object_stream.close();
                }
                if (ofstream != null) {
                    ofstream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameComponent[] LoadComponentGroupId(String componentType) {
        File TheFile = new File(DirectoryHelper.GetDataFolder("Replication/" + componentType) + "/GroupId.dat");
        FileInputStream ifstream = null;
        ObjectInputStream object_stream = null;
        try {
            if (TheFile.exists()) {
                ifstream = new FileInputStream(TheFile);
                object_stream = new ObjectInputStream(ifstream);
                NameComponent[] nameComponentArray = (NameComponent[])object_stream.readObject();
                return nameComponentArray;
            }
        }
        catch (ClassNotFoundException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-032", "DbReplicationComponent - LoadComponentGroupId - ClassNotFoundException: " + e.getMessage());
        }
        catch (IOException e) {
            this.m_FileLogger.LogWriteWarning("XMJU02-033", "DbReplicationComponent - LoadComponentGroupId - IOException: " + e.getMessage());
        }
        finally {
            try {
                if (object_stream != null) {
                    object_stream.close();
                }
                if (ifstream != null) {
                    ifstream.close();
                }
            }
            catch (IOException e) {}
        }
        return new NameComponent[0];
    }

    private void ComponentStarting() {
        while (!this.isStopping()) {
            this.m_FileLogger.LogWriteNormal("XMJU02-037", "DbReplicationComponent - ComponentStarting...");
            if (this.activationInProgress.get()) {
                this.m_FileLogger.LogWriteNormal("XMJU02-114", "Another thread is currently running activation. Waiting for it to complete before going on with activation to FtSystem.");
                this.Sleep();
                continue;
            }
            if (this.activated.get()) {
                this.m_FileLogger.LogWriteNormal("XMJU02-115", "Component is already activated.");
                break;
            }
            try {
                ComponentInstance instance = this.getComponentInstance();
                this.m_ReplicationManager.ComponentStarting(this.m_LocationId, this.m_strComponentType, this.m_ComponentDescription, instance);
                this.activated.set(true);
                this.m_FileLogger.LogWriteNormal("XMJU02-048", "DbReplicationComponent - ComponentStarting...Done");
                break;
            }
            catch (SystemException e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-043", "System exception: " + e.toString());
                this.RenewReplicationManager();
            }
            catch (UserException e) {
                this.m_FileLogger.LogWriteWarning("XMJU02-046", "User exception: " + e.toString());
            }
            this.replicaState.changeState(0);
            this.deactivate();
            this.Sleep();
        }
    }

    private void deactivate() {
        this.m_Service.StopPrimary();
        this.deactivateComponentInstance();
        this.activated.set(false);
    }

    private synchronized ComponentInstance getComponentInstance() throws ServantAlreadyActive, ServantNotActive, WrongPolicy {
        if (this.m_ObjectId == null) {
            this.m_ObjectId = this.m_Poa.activate_object((Servant)this);
        }
        return DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
    }

    private synchronized void deactivateComponentInstance() {
        try {
            this.m_Poa.deactivate_object(this.m_ObjectId);
        }
        catch (WrongPolicy e) {
        }
        catch (ObjectNotActive objectNotActive) {
            // empty catch block
        }
        this.m_ObjectId = null;
    }

    private void ComponentStopping() {
        try {
            if (this.m_ReplicationManager != null) {
                this.m_ReplicationManager.ComponentStopping(this.m_LocationId, this.m_strComponentType, this.m_ComponentDescription);
            }
        }
        catch (SystemException e) {
            this.m_FileLogger.LogWriteNormal("XMJU02-105", "ComponentStopping()... SystemException: " + e.getMessage());
        }
        catch (UserException e) {
            this.m_FileLogger.LogWriteNormal("XMJU02-105", "ComponentStopping()... UserException: " + e.getMessage());
        }
    }

    private static String getCorbalocForReplicationManager(String host) {
        StringBuffer corbaloc = new StringBuffer();
        corbaloc.append("corbaloc:iiop:");
        corbaloc.append(host);
        corbaloc.append(":");
        corbaloc.append(Port.FaultTolerancePort());
        corbaloc.append("/");
        corbaloc.append("FtSystem45");
        return corbaloc.toString();
    }

    private void RenewReplicationManager() {
        String host = this.m_HostIterator.current();
        while (!this.isStopping()) {
            String corbaloc = DbReplicationComponent.getCorbalocForReplicationManager(host);
            this.m_FileLogger.LogWriteLowLevel("XMJU02-049", "DbReplicationComponent - RenewReplicationManager (" + corbaloc + ")...");
            try {
                this.m_ReplicationManager = SystemHelper.narrow(this.m_Orb.string_to_object(corbaloc));
                if (null != this.m_ReplicationManager) {
                    Any timeout_value = this.m_Orb.create_any();
                    timeout_value.insert_ulonglong(864000000000L);
                    Policy policy = this.m_Orb.create_policy(32, timeout_value);
                    this.m_ReplicationManager = SystemHelper.narrow(this.m_ReplicationManager._set_policy_override(new Policy[]{policy}, SetOverrideType.SET_OVERRIDE));
                    this.m_FileLogger.LogWriteLowLevel("XMJU02-053", "DbReplicationComponent - RenewReplicationManager (" + corbaloc + ")...Done");
                    break;
                }
                this.m_FileLogger.LogWriteFatalError("XMJU02-051", "Can't connect to ReplicationManager (nil reference) - Is FaultTolerance running? - Waiting to retry connection");
            }
            catch (SystemException e) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", e.toString());
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", "Can't connect to ReplicationManager on host " + host + " - Is FaultTolerance running? - Waiting to retry connection");
            }
            catch (PolicyError e) {
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", e.toString());
                this.m_FileLogger.LogWriteFatalError("XMJU02-052", "Failed to apply timeout policy on ReplicationManager");
            }
            if ((host = this.m_HostIterator.nextOrRefreshAndNull()) != null) continue;
            this.Sleep();
            host = this.m_HostIterator.current();
        }
    }

    private boolean NameComponentArrayEquals(NameComponent[] nc1, NameComponent[] nc2) {
        boolean is_equal = nc1.length == nc2.length;
        for (int i = 0; is_equal && i < nc1.length; ++i) {
            is_equal = nc1[i].id.equals(nc2[i].id) && nc1[i].kind.equals(nc2[i].kind);
        }
        return is_equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Recover() throws DbSynchronizationFailed, DbVersionMismatchException, SQLException, DbConnectException, UnreconciliablePartitionException {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-054", "DbReplicationComponent - Recover...");
        DbComponentInstance this_instance = null;
        try {
            this_instance = DbComponentInstanceHelper.narrow(this.m_Poa.servant_to_reference((Servant)this));
        }
        catch (UserException ex) {
            this.m_FileLogger.LogWriteWarning("XMJU02-103", "DbReplicationComponent - Recover...Error - " + ex.getMessage());
            throw new DbSynchronizationFailed(ex.getMessage() == null ? "" : ex.getMessage());
        }
        DbConnection localCon = null;
        Map<String, DbConnection> backupCons = null;
        DbConnection sourceConnection = null;
        try {
            localCon = this.m_DbManager.localConnection();
            backupCons = this.m_DbManager.backupConnections();
            Iterator<Map.Entry<String, DbConnection>> iterBackups = backupCons.entrySet().iterator();
            if (iterBackups.hasNext()) {
                Map.Entry<String, DbConnection> backup = iterBackups.next();
                sourceConnection = backup.getValue();
            } else {
                DatabaseInfo PrimaryDatabaseInfo = this.m_PrimaryInstance.DbInfo();
                MySqlDbConnectionFactory factory = new MySqlDbConnectionFactory(DatabaseManager.toDbInfo(PrimaryDatabaseInfo));
                sourceConnection = factory.create();
            }
            this.m_DbSynchronizer.Synchronize(localCon, sourceConnection, this.DatabaseId(), this.m_PrimaryInstance, this_instance);
        }
        catch (Throwable throwable) {
            ConnectionUtils.close(localCon);
            ConnectionUtils.close(sourceConnection);
            if (backupCons != null) {
                ConnectionUtils.close(backupCons.values());
            }
            throw throwable;
        }
        ConnectionUtils.close(localCon);
        ConnectionUtils.close(sourceConnection);
        if (backupCons != null) {
            ConnectionUtils.close(backupCons.values());
        }
        this.m_FileLogger.LogWriteLowLevel("XMJU02-055", "DbReplicationComponent - Recover...Done");
    }

    public boolean Init(DbSynchronizer Synchronizer, DatabaseManager Manager2, ORB orb, SqlStatementExecute statementExecutorHook) {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-000", "DbReplicationComponent - Initialization...");
        this.m_Orb = orb;
        this.m_DbSynchronizer = Synchronizer;
        try {
            this.m_Poa = POAHelper.narrow((Object)this.m_Orb.resolve_initial_references("RootPOA"));
            this.m_Poa.the_POAManager().activate();
        }
        catch (InvalidName e) {
            this.m_FileLogger.LogWriteFatalError("Failed to init POA and POAManager: ", SingletonFileLogger.StackTraceOf(e));
            return false;
        }
        catch (AdapterInactive e) {
            this.m_FileLogger.LogWriteFatalError("Failed to init POA and POAManager: ", SingletonFileLogger.StackTraceOf(e));
            return false;
        }
        this.m_ComponentGroupId = this.LoadComponentGroupId(this.m_strComponentType);
        this.m_ComponentDescription = this.getComponentDescription();
        this.m_DbManager = Manager2;
        try {
            this.activateStatementExecutorFacet(statementExecutorHook);
        }
        catch (Exception e) {
            this.m_FileLogger.LogWriteFatalError("Failed to activate facet: ", SingletonFileLogger.StackTraceOf(e));
            return false;
        }
        this.RenewReplicationManager();
        this.ComponentStarting();
        return true;
    }

    private void activateStatementExecutorFacet(SqlStatementExecute statementExecutorHook) throws ServantAlreadyActive, WrongPolicy, ServantNotActive {
        StatementExecutorImpl servant = new StatementExecutorImpl(this.getConnectionFactory(), statementExecutorHook, this.replicaIsActivePrimary);
        this.m_Poa.activate_object((Servant)servant);
        Object reference = this.m_Poa.servant_to_reference((Servant)servant);
        this.facetManager.add("StatementExecutor", reference);
    }

    public synchronized void shutdown() {
        this.m_FileLogger.LogWriteLowLevel("XMJU02-004", "DbReplicationComponent - Stop called");
        this.notifyAll();
        this.ComponentStopping();
        if (this.m_DbManager != null) {
            this.m_DbManager.close();
        }
    }

    public boolean PrepareDatabase() throws DbConnectException, SQLException {
        return this.m_Service.PrepareDatabase();
    }

    public Subscription RegisterMonitor(Monitor TheMonitor, long Interval) throws UnsupportedInterval {
        throw new NO_IMPLEMENT();
    }

    public boolean is_alive() {
        return true;
    }

    public void Fault() {
        this.m_FileLogger.LogWriteWarning("XMJU02-014", "Fault called from Replication Manager");
        this.AssociatedDatabaseFailed();
    }

    public Object[] InitGroup(NameComponent[] GroupId, String[] PartIds) throws InstanceFailed {
        this.m_FileLogger.LogWriteNormal("XMJU02-015", "DbReplicationComponent.InitGroup()...");
        this.m_ComponentGroupId = GroupId;
        this.SaveComponentGroupId(this.m_ComponentGroupId);
        this.resetReplicationData();
        try {
            this.replicaState.changeState(0);
            this.Activate(1);
        }
        catch (InstanceFailed ex) {
            this.m_FileLogger.LogWriteWarning("XMJU02-098", "DbReplicationComponent.InitGroup()...Error - Should not come here - InstanceFailed");
            throw ex;
        }
        this.initSystemView();
        this.replicaState.changeState(1);
        this.startPrimary();
        return this.m_Service.GetObjects(PartIds);
    }

    public Object[] JoinGroup(ComponentGroupInfo GroupInfo, String[] PartIds) throws InstanceFailed, NoGroupMemberActive {
        this.m_FileLogger.LogWriteNormal("XMJU02-016", "DbReplicationComponent.JoinGroup()");
        if (!this.NameComponentArrayEquals(this.m_ComponentGroupId, GroupInfo.GroupId)) {
            DbConnection localCon = null;
            try {
                localCon = this.m_DbManager.localConnection();
                if (!this.m_DbSynchronizer.backupAndClearAllTables(localCon)) {
                    throw new InstanceFailed("", InstanceFailedCause.SYNCHRONIZATION_FAILED, "Could not backup the database");
                }
            }
            catch (DbConnectException ex) {
                throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "Could not backup the database: " + ex.getMessage());
            }
            catch (SQLException ex) {
                throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "Could not backup the database: " + ex.getMessage());
            }
            finally {
                ConnectionUtils.close(localCon);
            }
            this.m_ComponentGroupId = GroupInfo.GroupId;
            this.SaveComponentGroupId(this.m_ComponentGroupId);
        }
        this.resetReplicationData();
        this.UpdateBackupAndPrimaryLists(GroupInfo);
        this.replicaState.changeState(0);
        this.Activate(2);
        this.replicaState.changeState(2);
        return this.m_Service.GetObjects(PartIds);
    }

    public Object[] MergeIntoGroup(ComponentGroupInfo GroupInfo, String[] PartIds, ComponentInstanceInfo[] ExpectedViewFromSystem) throws InstanceFailed, NoGroupMemberActive {
        this.m_FileLogger.LogWriteNormal("XMJU02-112", "DbReplicationComponent.MergeIntoGroup()");
        return this.JoinGroup(GroupInfo, PartIds);
    }

    public Object[] RestartGroup(ComponentGroupInfo GroupInfo, String[] PartIds) throws InstanceFailed, UnknownGroup {
        this.m_FileLogger.LogWriteNormal("XMJU02-017", "DbReplicationComponent.RestartGroup()");
        this.m_ComponentGroupId = GroupInfo.GroupId;
        this.SaveComponentGroupId(this.m_ComponentGroupId);
        this.resetReplicationData();
        this.UpdateBackupAndPrimaryLists(GroupInfo);
        this.replicaState.changeState(0);
        this.Activate(1);
        this.updateSystemView(GroupInfo);
        this.replicaState.changeState(1);
        this.startPrimary();
        return this.m_Service.GetObjects(PartIds);
    }

    public void GroupUpdate(ComponentGroupInfo NewInfo, PartGroupInfo[] PartRefs) {
        this.m_FileLogger.LogWriteNormal("XMJU02-018", "DbReplicationComponent.GroupUpdate()");
        if (this.replicaState.currentState() == 1) {
            this.UpdateBackupAndPrimaryLists(NewInfo);
            this.m_FileLogger.LogWriteNormal("XMJU02-030", "DbReplicationComponent.GroupUpdate() Done");
        }
    }

    public Object[] GetPartReferences(String[] PartIds) throws InstanceFailed {
        return this.m_Service.GetObjects(PartIds);
    }

    public Object GetFacet(String FacetId) throws UnsupportedFacet {
        return this.facetManager.get(FacetId);
    }

    public String DatabaseId() {
        return this.m_DbManager.getLocalDatabaseId();
    }

    public DatabaseInfo DbInfo() {
        return this.m_DbManager.dbInfo();
    }

    public void NotifyRecovered(DbComponentInstance RecoveredDb, String RecoveredDatabaseId) {
        this.m_FileLogger.LogWriteNormal("XMJU02-034", "Adding recovered database to backup list...");
        try {
            DatabaseInfo databaseInfo = RecoveredDb.DbInfo();
            this.m_DbManager.addBackup(RecoveredDatabaseId, databaseInfo, RecoveredDb);
            this.m_FileLogger.LogWriteNormal("XMJU02-034", "Adding recovered database to backup list...Done");
        }
        catch (RuntimeException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-034", "Adding recovered database to backup list...Error: " + SingletonFileLogger.StackTraceOf(e));
            throw e;
        }
    }

    public void AssociatedDatabaseFailed() {
        this.m_FileLogger.LogWriteWarning("XMJU02-047", "AssociatedDatabaseFailed() called. Reactivating component instance...");
        if (this.replicaState.changeState(0) != 0) {
            class ComponentReStartingThread
            extends Thread {
                public ComponentReStartingThread() {
                    this.setName("ComponentStartingThread");
                }

                public void run() {
                    DbReplicationComponent.this.deactivate();
                    DbReplicationComponent.this.ComponentStarting();
                }
            }
            new ComponentReStartingThread().start();
        }
    }

    public DbConnectionFactory getConnectionFactory() {
        return new DbConnectionFactory(){

            public DbConnection create() throws SQLException, DbConnectException {
                return DbReplicationComponent.this.m_DbManager.getConnection();
            }
        };
    }

    private void resetReplicationData() throws InstanceFailed {
        try {
            this.m_DbManager.reset();
        }
        catch (SQLException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-111", "DbReplicationComponent.resetReplicationData()...SQLException: " + e.getMessage());
            this.m_FileLogger.LogWriteFatalError("XMJU02-111", SingletonFileLogger.StackTraceOf(e));
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "SQLException");
        }
        catch (DbConnectException e) {
            this.m_FileLogger.LogWriteFatalError("XMJU02-112", "DbReplicationComponent.resetReplicationData()...DbConnectException: " + e.getMessage());
            this.m_FileLogger.LogWriteFatalError("XMJU02-112", SingletonFileLogger.StackTraceOf(e));
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "DbConnectException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDeleteLogCleanUp(String[] tables, long retentionPeriod) throws SQLException, DbConnectException {
        DbConnection con = null;
        try {
            con = this.m_DbManager.getPlainReplicatedConnection();
            for (String table : tables) {
                this.m_DbManager.getDeleteLogger().cleanup(con, table, retentionPeriod);
            }
        }
        finally {
            ConnectionUtils.close(con);
        }
    }

    public static void initSystemView(DbConnection con, NameComponent[] location) throws SQLException, DbConnectException {
        assert (location[0].kind.equals("Host"));
        ArrayList<SystemView.ComponentInstance> systemView = new ArrayList<SystemView.ComponentInstance>();
        systemView.add(new SystemView.ComponentInstance(location[0].id, true, 0L));
        SystemView.setView(con, systemView);
    }

    private void initSystemView() throws InstanceFailed {
        DbConnection localCon = null;
        try {
            localCon = this.m_DbManager.localConnection();
            DbReplicationComponent.initSystemView(localCon, this.m_LocationId);
        }
        catch (SQLException ex) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", "SQLException");
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "SQLException");
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", "DbConnectException");
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "DbConnectException");
        }
        finally {
            ConnectionUtils.close(localCon);
        }
    }

    public static void updateSystemView(DbConnection con, ComponentGroupInfo groupInfo) throws SQLException, DbConnectException {
        List<SystemView.ComponentInstance> oldSystemView = SystemView.getView(con);
        SystemView.updatePrimarySeqNum(oldSystemView, SeqNumManager.maxSeqNum(con));
        ArrayList<SystemView.ComponentInstance> newSystemView = new ArrayList<SystemView.ComponentInstance>();
        for (ComponentInstanceInfo instance : groupInfo.Instances) {
            assert (instance.ComponentId[0].kind.equals("Host"));
            newSystemView.add(new SystemView.ComponentInstance(instance.ComponentId[0].id, instance.Membership.value() == 0, SystemView.getSeqNum(oldSystemView, instance.ComponentId[0].id)));
        }
        SystemView.setView(con, newSystemView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSystemView(ComponentGroupInfo groupInfo) throws InstanceFailed {
        DbConnection localCon = null;
        DbConnection.Lock lock = null;
        try {
            localCon = this.m_DbManager.localConnection();
            lock = localCon.getLock();
            localCon.setAutoCommit(false);
            int num_attempts_remaining = 10;
            while (true) {
                try {
                    --num_attempts_remaining;
                    this.m_DbSynchronizer.LockTables(localCon, LockTablesStatement.LockType.WRITE);
                    DbReplicationComponent.updateSystemView(localCon, groupInfo);
                }
                catch (SQLException e) {
                    if (num_attempts_remaining > 0 && e.getErrorCode() == 1205) {
                        this.m_FileLogger.LogWriteWarning("XMJU02-116", "Received retryable error " + e.getErrorCode() + ", " + num_attempts_remaining + " attempts remaining");
                        localCon.rollback();
                        continue;
                    }
                    throw e;
                }
                finally {
                    this.m_DbSynchronizer.UnlockTables(localCon);
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", "SQLException");
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "SQLException");
        }
        catch (DbConnectException ex) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", "DbConnectException");
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::initSystemView", ex.getMessage());
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "DbConnectException");
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
            ConnectionUtils.close(localCon);
        }
    }

    private void startPrimary() throws InstanceFailed {
        try {
            this.m_Service.StartPrimary();
        }
        catch (SQLException e) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::startPrimary", SingletonFileLogger.StackTraceOf(e));
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "SQLException");
        }
        catch (DbConnectException e) {
            this.m_FileLogger.LogWriteFatalError("DbReplicationComponent::startPrimary", SingletonFileLogger.StackTraceOf(e));
            throw new InstanceFailed(InstanceFailedCause.SYNCHRONIZATION_FAILED, "DbConnectException");
        }
    }

    public DatabaseManager getDatabaseManager() {
        return this.m_DbManager;
    }
}

