/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.DbConnectionGuard;
import Xm.JavaUtils.Database.DbFailureObserver;
import Xm.JavaUtils.Database.DbReplicatedConnection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DbReplicatedConnectionFactory
implements DbConnectionFactory {
    private DbConnectionFactory m_localDbConnectionFactory;
    private Map<String, DbConnectionFactory> m_backupDbConnectionFactories;
    private Set<DbReplicatedConnection> m_openedReplicatedConnections;
    private DbFailureObserver m_dbFailureObserver;

    public DbReplicatedConnectionFactory(DbConnectionFactory localConnectionFactory, DbFailureObserver dbFailureObserver) {
        this.m_localDbConnectionFactory = localConnectionFactory;
        this.m_backupDbConnectionFactories = new TreeMap<String, DbConnectionFactory>();
        this.m_openedReplicatedConnections = new HashSet<DbReplicatedConnection>();
        this.m_dbFailureObserver = dbFailureObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbConnection create() throws SQLException, DbConnectException {
        DbReplicatedConnection replicatedDbconnection = new DbReplicatedConnection(this.m_localDbConnectionFactory.create(), this.m_dbFailureObserver);
        TreeMap<String, DbConnectionFactory> backupFactories = new TreeMap<String, DbConnectionFactory>();
        DbReplicatedConnectionFactory dbReplicatedConnectionFactory = this;
        synchronized (dbReplicatedConnectionFactory) {
            this.m_openedReplicatedConnections.add(replicatedDbconnection);
            backupFactories.putAll(this.m_backupDbConnectionFactories);
        }
        for (Map.Entry entry : backupFactories.entrySet()) {
            String databaseId = (String)entry.getKey();
            try {
                replicatedDbconnection.addBackupConnection(databaseId, ((DbConnectionFactory)entry.getValue()).create());
            }
            catch (SQLException e) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
            catch (DbConnectException e) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
        }
        return new DbConnectionGuard(replicatedDbconnection, new OnConnectionClose());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupFactory(String databaseId, DbConnectionFactory factory) {
        DbReplicatedConnection[] connections;
        DbReplicatedConnectionFactory dbReplicatedConnectionFactory = this;
        synchronized (dbReplicatedConnectionFactory) {
            this.m_backupDbConnectionFactories.put(databaseId, factory);
            connections = this.m_openedReplicatedConnections.toArray(new DbReplicatedConnection[0]);
        }
        for (DbReplicatedConnection replicatedConnection : connections) {
            try {
                replicatedConnection.addBackupConnection(databaseId, factory.create());
            }
            catch (SQLException e) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
            catch (DbConnectException e) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
        }
    }

    public synchronized void removeBackupFactory(String backupDatabaseId) {
        this.m_backupDbConnectionFactories.remove(backupDatabaseId);
        for (DbReplicatedConnection replicatedConnection : this.m_openedReplicatedConnections) {
            replicatedConnection.removeBackupConnection(backupDatabaseId);
        }
    }

    public synchronized void clearBackupFactories() {
        this.m_backupDbConnectionFactories.clear();
        for (DbReplicatedConnection replicatedConnection : this.m_openedReplicatedConnections) {
            replicatedConnection.clearBackupConnections();
        }
    }

    private synchronized void removeOpenedConnection(DbConnection dbConnection) throws SQLException {
        this.m_openedReplicatedConnections.remove(dbConnection);
    }

    private class OnConnectionClose
    implements DbConnectionGuard.OnConnectionClose {
        private OnConnectionClose() {
        }

        public void onConnectionClose(DbConnection dbConnection) throws SQLException {
            DbReplicatedConnectionFactory.this.removeOpenedConnection(dbConnection);
            dbConnection.close();
        }
    }
}

