/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractDbConnection;
import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbFailureObserver;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbReplicatedConnection
extends AbstractDbConnection {
    private DbConnection m_localDbConnection;
    private Map<String, DbConnection> m_backupDbConnections = new TreeMap<String, DbConnection>();
    private ArrayList<DbConnection> m_deadBackupDbConnections = new ArrayList();
    private TreeSet<String> m_applyAutoCommitOn;
    private DbFailureObserver m_dbFailureObserver;
    private static ReentrantLock m_transactionSerializer = new ReentrantLock();
    private static SingletonFileLogger logger = SingletonFileLogger.GetInstance();

    public DbReplicatedConnection(DbConnection localConnection, DbFailureObserver dbFailureObserver) {
        this.m_localDbConnection = localConnection;
        this.m_dbFailureObserver = dbFailureObserver;
        this.m_applyAutoCommitOn = new TreeSet();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException, DbConnectException {
        return this.m_localDbConnection.getMetaData();
    }

    public synchronized void addBackupConnection(String databaseId, DbConnection connection) {
        this.m_backupDbConnections.put(databaseId, connection);
        this.m_applyAutoCommitOn.add(databaseId);
    }

    public synchronized void removeBackupConnection(String backupDatabaseId) {
        DbConnection backupConnection = this.m_backupDbConnections.remove(backupDatabaseId);
        if (backupConnection != null) {
            this.m_deadBackupDbConnections.add(backupConnection);
        }
    }

    public synchronized void clearBackupConnections() {
        this.closeBackupConnections();
    }

    private synchronized Map<String, DbConnection> getBackupConnections() {
        return new TreeMap<String, DbConnection>(this.m_backupDbConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeadBackupConnections() {
        ArrayList<DbConnection> copies = new ArrayList<DbConnection>();
        DbReplicatedConnection dbReplicatedConnection = this;
        synchronized (dbReplicatedConnection) {
            copies.addAll(this.m_deadBackupDbConnections);
            this.m_deadBackupDbConnections.clear();
        }
        ConnectionUtils.close(copies);
    }

    private synchronized void applyAutoCommitIfNeeded(String databaseId, DbConnection con) throws SQLException, DbConnectException {
        if (this.m_applyAutoCommitOn.remove(databaseId)) {
            con.setAutoCommit(this.getAutoCommit());
        }
    }

    private void closeBackupConnections() {
        ConnectionUtils.close(this.m_backupDbConnections.values());
        this.flushDeadBackupConnections();
    }

    @Override
    public ResultSet execute(SelectStatement statement) throws SQLException, DbConnectException {
        try {
            return this.m_localDbConnection.execute(statement);
        }
        catch (DbConnectException ex) {
            this.m_dbFailureObserver.localDatabaseFailed();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(SqlWriteStatement statement) throws SQLException, DbConnectException {
        m_transactionSerializer.lock();
        try {
            int result;
            try {
                result = this.m_localDbConnection.execute(statement);
            }
            catch (DbConnectException ex) {
                this.m_dbFailureObserver.localDatabaseFailed();
                throw ex;
            }
            this.executeJobOnBackups(new ExecuteAndValidateResult(statement, result, this.m_dbFailureObserver));
            int n = result;
            return n;
        }
        finally {
            m_transactionSerializer.unlock();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException, DbConnectException {
        try {
            return this.m_localDbConnection.getAutoCommit();
        }
        catch (DbConnectException ex) {
            this.m_dbFailureObserver.localDatabaseFailed();
            throw ex;
        }
        catch (SQLException ex) {
            this.m_dbFailureObserver.localDatabaseFailed();
            throw ex;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException, DbConnectException {
        if (!autoCommit && !m_transactionSerializer.isHeldByCurrentThread()) {
            SingletonFileLogger.GetInstance().LogWriteFatalError("XMU09-001", "setAutoCommit(false) with no lock");
            throw new SQLException("setAutoCommit(false) with no lock");
        }
        SetAutoCommit job = new SetAutoCommit(autoCommit);
        this.executeJob(job);
    }

    @Override
    public DbConnection.Lock getLock() {
        m_transactionSerializer.lock();
        return new LockAccess(m_transactionSerializer);
    }

    @Override
    public void commit() throws SQLException, DbConnectException {
        Commit job = new Commit();
        this.executeJob(job);
    }

    @Override
    public void rollback() throws SQLException, DbConnectException {
        Rollback job = new Rollback();
        this.executeJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob(Job job) throws SQLException, DbConnectException {
        m_transactionSerializer.lock();
        try {
            try {
                job.executeOn(this.m_localDbConnection, "local database");
            }
            catch (DbConnectException ex) {
                this.m_dbFailureObserver.localDatabaseFailed();
                throw ex;
            }
            this.executeJobOnBackups(job);
        }
        finally {
            m_transactionSerializer.unlock();
        }
    }

    private void executeJobOnBackups(Job job) {
        TreeSet<String> backupAlreadyProcessed = new TreeSet<String>();
        Map<String, DbConnection> backupConnections = this.getBackupConnections();
        Set<Map.Entry<String, DbConnection>> backups = backupConnections.entrySet();
        Iterator<Map.Entry<String, DbConnection>> iterBackup = backups.iterator();
        while (iterBackup.hasNext()) {
            Map.Entry<String, DbConnection> backup = iterBackup.next();
            DbConnection backupConnection = backup.getValue();
            String databaseId = backup.getKey();
            if (backupAlreadyProcessed.contains(databaseId)) continue;
            try {
                this.applyAutoCommitIfNeeded(databaseId, backupConnection);
                job.executeOn(backupConnection, databaseId);
            }
            catch (DbConnectException ex) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
            catch (SQLException e) {
                this.m_dbFailureObserver.remoteDatabaseFailed(databaseId);
            }
            backupAlreadyProcessed.add(databaseId);
            this.dispose(databaseId, backupConnection);
            backupConnections = this.getBackupConnections();
            backups = backupConnections.entrySet();
            iterBackup = backups.iterator();
        }
        this.flushDeadBackupConnections();
    }

    private synchronized void dispose(String databaseId, DbConnection backupConnection) {
        if (!this.m_backupDbConnections.containsKey(databaseId)) {
            ConnectionUtils.close(backupConnection);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        super.close();
        this.closeBackupConnections();
        this.m_localDbConnection.close();
    }

    @Override
    public void closeActiveResultSet() throws SQLException {
        this.m_localDbConnection.closeActiveResultSet();
        this.executeJobOnBackups(new CloseActiveResultSet());
    }

    private static class LockAccess
    implements DbConnection.Lock {
        private ReentrantLock m_Lock;

        public LockAccess(ReentrantLock lock) {
            this.m_Lock = lock;
        }

        public void unlock() {
            if (this.m_Lock != null) {
                this.m_Lock.unlock();
                this.m_Lock = null;
            }
        }

        public void finalize() {
            if (this.m_Lock != null) {
                SingletonFileLogger.GetInstance().LogWriteFatalError("LockAccess::finalyze", "not unlocked !");
            }
        }
    }

    private static class CloseActiveResultSet
    implements Job {
        private CloseActiveResultSet() {
        }

        public void executeOn(DbConnection con, String databaseId) throws SQLException {
            con.closeActiveResultSet();
        }
    }

    private static class Rollback
    implements Job {
        private Rollback() {
        }

        public void executeOn(DbConnection con, String databaseId) throws SQLException, DbConnectException {
            con.rollback();
        }
    }

    private static class Commit
    implements Job {
        public void executeOn(DbConnection con, String databaseId) throws SQLException, DbConnectException {
            con.commit();
        }
    }

    private static class SetAutoCommit
    implements Job {
        private boolean m_AutoCommit;

        public SetAutoCommit(boolean autoCommit) {
            this.m_AutoCommit = autoCommit;
        }

        public void executeOn(DbConnection con, String databaseId) throws SQLException, DbConnectException {
            con.setAutoCommit(this.m_AutoCommit);
        }
    }

    private static class ExecuteAndValidateResult
    implements Job {
        private final SqlWriteStatement m_statement;
        private int expectedResult;
        private DbFailureObserver observer;

        public ExecuteAndValidateResult(SqlWriteStatement statement, int expectedResult, DbFailureObserver observer) {
            this.m_statement = statement;
            this.expectedResult = expectedResult;
            this.observer = observer;
        }

        public void executeOn(DbConnection con, String databaseId) throws SQLException, DbConnectException {
            int result = con.execute(this.m_statement);
            if (result != this.expectedResult) {
                logger.LogWriteWarning("XMJU09-001", "SqlWriteStatement execution on backup returned " + result + " while execution on primary returned " + this.expectedResult);
                this.observer.remoteDatabaseFailed(databaseId);
            }
        }
    }

    static interface Job {
        public void executeOn(DbConnection var1, String var2) throws SQLException, DbConnectException;
    }
}

