/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.DbConnectionGuard;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DbConnectionPool
implements DbConnectionFactory {
    DbConnectionFactory m_connectionFactory;
    private int m_maxConnectionAvailable;
    private List<DbConnection> m_connectionsAvailable;
    boolean closed = false;

    public DbConnectionPool(DbConnectionFactory connectionFactory, int maxConnectionAvailable) {
        this.m_connectionFactory = connectionFactory;
        this.m_maxConnectionAvailable = maxConnectionAvailable;
        this.m_connectionsAvailable = new ArrayList<DbConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbConnection create() throws SQLException, DbConnectException {
        List<DbConnection> list = this.m_connectionsAvailable;
        synchronized (list) {
            if (!this.m_connectionsAvailable.isEmpty()) {
                return new DbConnectionGuard(this.m_connectionsAvailable.remove(0), new OnConnectionClose());
            }
        }
        return new DbConnectionGuard(this.m_connectionFactory.create(), new OnConnectionClose());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<DbConnection> list = this.m_connectionsAvailable;
        synchronized (list) {
            this.closed = true;
            ConnectionUtils.close(this.m_connectionsAvailable);
            this.m_connectionsAvailable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<DbConnection> list = this.m_connectionsAvailable;
        synchronized (list) {
            ConnectionUtils.close(this.m_connectionsAvailable);
            this.m_connectionsAvailable.clear();
        }
    }

    private class OnConnectionClose
    implements DbConnectionGuard.OnConnectionClose {
        private OnConnectionClose() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionClose(DbConnection dbConnection) throws SQLException {
            boolean needToClose = true;
            try {
                this.closeActiveResultSet(dbConnection);
                this.setAutocommit(dbConnection);
                List list = DbConnectionPool.this.m_connectionsAvailable;
                synchronized (list) {
                    if (!DbConnectionPool.this.closed && DbConnectionPool.this.m_connectionsAvailable.size() < DbConnectionPool.this.m_maxConnectionAvailable) {
                        DbConnectionPool.this.m_connectionsAvailable.add(dbConnection);
                        needToClose = false;
                    }
                }
            }
            catch (SQLException ex) {
                String message = "Evictoring connection on SQLException: " + ex.getMessage();
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU31-001", message);
            }
            catch (DbConnectException ex) {
                String message = "Evictoring connection on DbConnectException: " + ex.getMessage();
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU31-001", message);
            }
            if (needToClose) {
                dbConnection.close();
            }
        }

        private void closeActiveResultSet(DbConnection dbConnection) throws SQLException {
            try {
                dbConnection.closeActiveResultSet();
            }
            catch (SQLException ex) {
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU31-002", "SQLException: " + ex.getMessage());
                throw ex;
            }
        }

        private void setAutocommit(DbConnection dbConnection) throws SQLException, DbConnectException {
            try {
                dbConnection.setAutoCommit(true);
            }
            catch (SQLException ex) {
                SingletonFileLogger.GetInstance().LogWriteWarning("XMJU31-003", "SQLException: " + ex.getMessage());
                throw ex;
            }
        }
    }
}

