/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractDbConnection;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.SelectStatement;
import Xm.JavaUtils.Database.SqlWriteStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbConnectionGuard
extends AbstractDbConnection {
    private DbConnection m_dbConnection;
    private OnConnectionClose m_onConnectionClose;
    private boolean m_hasBeenClosed;

    public DbConnectionGuard(DbConnection dbConnection, OnConnectionClose onConnectionClose) {
        this.m_dbConnection = dbConnection;
        this.m_onConnectionClose = onConnectionClose;
        this.m_hasBeenClosed = false;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException, DbConnectException {
        this.assertNotClosed();
        return this.m_dbConnection.getMetaData();
    }

    public ResultSet execute(SelectStatement statement) throws SQLException, DbConnectException {
        this.assertNotClosed();
        return this.m_dbConnection.execute(statement);
    }

    public int execute(SqlWriteStatement statement) throws SQLException, DbConnectException {
        this.assertNotClosed();
        return this.m_dbConnection.execute(statement);
    }

    public synchronized boolean getAutoCommit() throws SQLException, DbConnectException {
        this.assertNotClosed();
        return this.m_dbConnection.getAutoCommit();
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException, DbConnectException {
        this.assertNotClosed();
        this.m_dbConnection.setAutoCommit(autoCommit);
    }

    public synchronized void commit() throws SQLException, DbConnectException {
        this.assertNotClosed();
        this.m_dbConnection.commit();
    }

    public synchronized void rollback() throws SQLException, DbConnectException {
        this.assertNotClosed();
        this.m_dbConnection.rollback();
    }

    public synchronized void close() throws SQLException {
        super.close();
        if (!this.m_hasBeenClosed) {
            this.m_onConnectionClose.onConnectionClose(this.m_dbConnection);
            this.m_hasBeenClosed = true;
        }
    }

    private void assertNotClosed() throws DbConnectException {
        if (this.m_hasBeenClosed) {
            throw new DbConnectException("Connection has been closed");
        }
    }

    public DbConnection getConnection() {
        return this.m_dbConnection;
    }

    public void closeActiveResultSet() throws SQLException {
        if (!this.m_hasBeenClosed) {
            this.m_dbConnection.closeActiveResultSet();
        }
    }

    public DbConnection.Lock getLock() {
        return this.m_dbConnection.getLock();
    }

    public static interface OnConnectionClose {
        public void onConnectionClose(DbConnection var1) throws SQLException;
    }
}

