/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.FaultTolerance.DatabaseInfo;
import Xm.FaultTolerance.DbComponentInstance;
import Xm.FaultTolerance.DbComponentInstanceOperations;
import Xm.JavaUtils.Database.ConnectionObserver;
import Xm.JavaUtils.Database.ConnectionUtils;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DbConnectionFactory;
import Xm.JavaUtils.Database.DbConnectionFactoryFactory;
import Xm.JavaUtils.Database.DbConnectionPool;
import Xm.JavaUtils.Database.DbFailureObserver;
import Xm.JavaUtils.Database.DbInfo;
import Xm.JavaUtils.Database.DbReplicatedConnection;
import Xm.JavaUtils.Database.DbReplicatedConnectionFactory;
import Xm.JavaUtils.Database.DeleteLogger;
import Xm.JavaUtils.Database.ObservableConnectionFactory;
import Xm.JavaUtils.Database.SeqNumManager;
import Xm.JavaUtils.Database.SqlStatementAddSeqNum;
import Xm.JavaUtils.Database.SqlStatementTransform;
import Xm.JavaUtils.Database.TableInfo;
import Xm.JavaUtils.Database.TransformDbConnectionFactory;
import Xm.JavaUtils.SingletonFileLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jacorb.util.Network;
import org.omg.CORBA.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseManager
implements DbFailureObserver {
    private String m_localDatabaseId;
    private DatabaseInfo m_localDatabaseInfo;
    private DbComponentInstanceOperations m_localComponent;
    private DbReplicatedConnectionFactory m_replicatedConnectionFactory;
    private DbConnectionFactory m_connectionFactory;
    private static final int m_maximumConnectionInPool = 10;
    private SeqNumManager m_seqNumManager;
    private DeleteLogger m_deleteLogger;
    private DbConnectionFactoryFactory m_DbConnectionFactoryFactory;
    private DbConnectionPool localConnectionPool;
    private Map<String, BackupInfo> backupInfos;
    private ObservableConnectionFactory m_ObservableConnectionFactory;
    private TransformDbConnectionFactory m_BeforeReplicationTransforms;

    public DatabaseManager(String localDatabaseId, DatabaseInfo localDatabaseInfo, DbComponentInstanceOperations localComponent, DbConnectionFactoryFactory dbConnectionFactoryFactory, TableInfo[] tables) throws SQLException, DbConnectException {
        this.m_localDatabaseId = localDatabaseId;
        this.m_localDatabaseInfo = localDatabaseInfo;
        DatabaseManager.fixDatabaseInfo(this.m_localDatabaseInfo);
        this.m_localComponent = localComponent;
        this.backupInfos = new HashMap<String, BackupInfo>();
        this.m_DbConnectionFactoryFactory = dbConnectionFactoryFactory;
        this.localConnectionPool = new DbConnectionPool(this.m_DbConnectionFactoryFactory.create(DatabaseManager.toDbInfo(localDatabaseInfo)), 10);
        this.m_seqNumManager = new SeqNumManager();
        this.init();
        this.m_deleteLogger = new DeleteLogger(tables);
        this.m_replicatedConnectionFactory = new DbReplicatedConnectionFactory(this.localConnectionPool, this);
        this.m_BeforeReplicationTransforms = new TransformDbConnectionFactory(this.m_replicatedConnectionFactory, new SqlStatementTransform[0]);
        this.m_BeforeReplicationTransforms.add(this.m_deleteLogger);
        this.m_ObservableConnectionFactory = new ObservableConnectionFactory(this.m_BeforeReplicationTransforms);
        this.m_connectionFactory = new TransformDbConnectionFactory(this.m_ObservableConnectionFactory, new SqlStatementAddSeqNum(this.m_seqNumManager));
    }

    public String getLocalDatabaseId() {
        return this.m_localDatabaseId;
    }

    public SeqNumManager getSeqNumManager() {
        return this.m_seqNumManager;
    }

    public DeleteLogger getDeleteLogger() {
        return this.m_deleteLogger;
    }

    public synchronized DatabaseInfo dbInfo() {
        return this.m_localDatabaseInfo;
    }

    public synchronized DbConnection getConnection() throws SQLException, DbConnectException {
        return this.m_connectionFactory.create();
    }

    public DbConnectionFactory getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public synchronized DbConnection getPlainReplicatedConnection() throws SQLException, DbConnectException {
        DbConnection localCon = this.localConnectionPool.create();
        try {
            DbReplicatedConnection con = new DbReplicatedConnection(localCon, this);
            for (Map.Entry<String, DbConnection> entry : this.backupConnections().entrySet()) {
                con.addBackupConnection(entry.getKey(), entry.getValue());
            }
            return con;
        }
        catch (SQLException e) {
            ConnectionUtils.close(localCon);
            throw e;
        }
        catch (DbConnectException e) {
            ConnectionUtils.close(localCon);
            throw e;
        }
    }

    public synchronized void addBackup(String databaseId, DatabaseInfo databaseInfo, DbComponentInstance instance) {
        if (this.backupInfos.containsKey(databaseId)) {
            throw new IllegalArgumentException("The instance " + databaseId + " is already a backup of this group");
        }
        BackupInfo backupInfo = new BackupInfo(databaseInfo, instance, this.m_DbConnectionFactoryFactory.create(DatabaseManager.toDbInfo(databaseInfo)));
        this.m_replicatedConnectionFactory.addBackupFactory(databaseId, backupInfo.getConnectionPool());
        this.backupInfos.put(databaseId, backupInfo);
    }

    public void addObserver(ConnectionObserver observer) {
        this.m_ObservableConnectionFactory.addObserver(observer);
    }

    public void addBeforeReplicationTransform(SqlStatementTransform transform) {
        this.m_BeforeReplicationTransforms.add(transform);
    }

    public synchronized void updateBackupList(Map<String, DatabaseInfo> databaseInfos, Map<String, DbComponentInstance> instances) throws IllegalArgumentException {
        if (databaseInfos.size() != instances.size()) {
            throw new IllegalArgumentException("Arguments length mismatch");
        }
        TreeSet<String> instancesToRemove = new TreeSet<String>(this.backupInfos.keySet());
        for (Map.Entry<String, DatabaseInfo> backupEntry : databaseInfos.entrySet()) {
            String peerDatabaseId = backupEntry.getKey();
            if (peerDatabaseId.equals(this.m_localDatabaseId)) continue;
            DatabaseInfo peerDatabaseInfo = backupEntry.getValue();
            DbComponentInstance peerInstance = instances.get(peerDatabaseId);
            BackupInfo found = this.backupInfos.get(peerDatabaseId);
            if (found == null) {
                this.addBackup(peerDatabaseId, peerDatabaseInfo, peerInstance);
                continue;
            }
            found.update(peerDatabaseInfo, peerInstance);
            instancesToRemove.remove(peerDatabaseId);
        }
        for (String toRemove : instancesToRemove) {
            this.backupInfos.remove(toRemove).close();
            this.m_replicatedConnectionFactory.removeBackupFactory(toRemove);
        }
    }

    public synchronized void close() {
        for (BackupInfo backupInfo : this.backupInfos.values()) {
            backupInfo.close();
        }
        this.m_replicatedConnectionFactory.clearBackupFactories();
        this.localConnectionPool.close();
    }

    public synchronized void reset() throws SQLException, DbConnectException {
        for (BackupInfo backupInfo : this.backupInfos.values()) {
            backupInfo.close();
        }
        this.m_replicatedConnectionFactory.clearBackupFactories();
        this.localConnectionPool.clear();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SQLException, DbConnectException {
        DbConnection localConnection = null;
        try {
            localConnection = this.localConnectionPool.create();
            this.m_seqNumManager.init(localConnection);
        }
        finally {
            ConnectionUtils.close(localConnection);
        }
    }

    @Override
    public synchronized void localDatabaseFailed() {
        this.m_localComponent.AssociatedDatabaseFailed();
    }

    @Override
    public synchronized void remoteDatabaseFailed(String databaseId) {
        BackupInfo found = this.backupInfos.get(databaseId);
        if (found != null) {
            this.removeBackup(databaseId);
            class NotifierThread
            extends Thread {
                private DbComponentInstance m_Obj = null;

                public NotifierThread(DbComponentInstance Obj) {
                    this.setName("DatabaseManager.NotifierThread");
                    this.m_Obj = Obj;
                }

                public void run() {
                    String dbHost = "";
                    try {
                        DatabaseInfo info = this.m_Obj.DbInfo();
                        dbHost = info.DbHost;
                        this.m_Obj.AssociatedDatabaseFailed();
                    }
                    catch (SystemException e) {
                        String message = "CORBA.SystemException while trying to notify a failure: " + e.toString();
                        DatabaseManager.logger().LogWriteWarning("XMJU26-001", message);
                    }
                    DatabaseManager.logger().LogWriteWarning("XMJU26-002", "SQL Exception happened on database located at " + dbHost);
                    DatabaseManager.logger().LogWriteWarning("XMJU26-002", "The component on this computer has been notified");
                }
            }
            NotifierThread notifier = new NotifierThread(found.getDbComponentInstance());
            notifier.start();
        }
    }

    public synchronized void removeBackup(String databaseId) {
        BackupInfo removed = this.backupInfos.remove(databaseId);
        if (removed != null) {
            removed.close();
        }
        this.m_replicatedConnectionFactory.removeBackupFactory(databaseId);
    }

    private static SingletonFileLogger logger() {
        return SingletonFileLogger.GetInstance();
    }

    public DbConnection localConnection() throws SQLException, DbConnectException {
        return this.localConnectionPool.create();
    }

    private static void fixDatabaseInfo(DatabaseInfo info) {
        if (info.DbHost.equals("localhost")) {
            InetAddress localhost = null;
            try {
                localhost = Network.getLocalHost();
                if (localhost != null) {
                    info.DbHost = localhost.getHostAddress();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public static DbInfo toDbInfo(DatabaseInfo databaseInfo) {
        return new DbInfo(databaseInfo.DbHost, databaseInfo.DbPort, databaseInfo.DbName, databaseInfo.DbUser, databaseInfo.DbPassword);
    }

    public synchronized Map<String, DbConnection> backupConnections() throws SQLException, DbConnectException {
        TreeMap<String, DbConnection> connections = new TreeMap<String, DbConnection>();
        try {
            for (Map.Entry<String, BackupInfo> entry : this.backupInfos.entrySet()) {
                connections.put(entry.getKey(), entry.getValue().getConnectionPool().create());
            }
            return connections;
        }
        catch (SQLException e) {
            ConnectionUtils.close(connections.values());
            throw e;
        }
        catch (DbConnectException e) {
            ConnectionUtils.close(connections.values());
            throw e;
        }
    }

    private static class BackupInfo {
        private DatabaseInfo databaseInfo;
        private DbComponentInstance dbComponentInstance;
        private DbConnectionPool connectionPool;

        BackupInfo(DatabaseInfo databaseInfo, DbComponentInstance dbComponentInstance, DbConnectionFactory factory) {
            this.databaseInfo = databaseInfo;
            this.dbComponentInstance = dbComponentInstance;
            this.connectionPool = new DbConnectionPool(factory, 10);
        }

        private static boolean equals(DatabaseInfo db1, DatabaseInfo db2) {
            return db1.DbHost.equals(db2.DbHost) && db1.DbPort.equals(db2.DbPort) && db1.DbName.equals(db2.DbName) && db1.DbUser.equals(db2.DbUser) && db1.DbPassword.equals(db2.DbPassword) && db1.DbmsType.equals(db2.DbmsType);
        }

        void update(DatabaseInfo databaseInfo, DbComponentInstance dbComponentInstance) {
            if (!BackupInfo.equals(this.databaseInfo, databaseInfo)) {
                throw new IllegalArgumentException("DatabaseInfo must not change");
            }
            this.dbComponentInstance = dbComponentInstance;
        }

        void close() {
            this.connectionPool.close();
        }

        DbConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        DbComponentInstance getDbComponentInstance() {
            return this.dbComponentInstance;
        }
    }
}

