/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.ColumnDefinition;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.DeleteStatementBuilder;
import Xm.JavaUtils.Database.IFilterElement;
import Xm.JavaUtils.Database.InsertStatementBuilder;
import Xm.JavaUtils.Database.SelectStatementBuilder;
import Xm.JavaUtils.Database.SqlFilter;
import Xm.JavaUtils.Database.Table;
import Xm.JavaUtils.Database.TableDefinition;
import Xm.JavaUtils.Database.UpdateStatementBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Counters {
    private static String TABLE_NAME = "ReplicationCounters";
    private static String COLUMN_TABLE_NAME = "TableName";
    private static String COLUMN_PROPERTY_NAME = "PropertyName";
    private static String COLUMN_LONG_VALUE = "LongValue";
    private static ColumnDefinition.Type STRING_COLUMN_TYPE = ColumnDefinition.Type.GUID;

    Counters() {
    }

    private static void validateString(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        if (propertyName.length() > STRING_COLUMN_TYPE.getColumnSize()) {
            throw new IllegalArgumentException("strings must have at most " + STRING_COLUMN_TYPE.getColumnSize() + " characters");
        }
    }

    public static String getCountersTableName() {
        return TABLE_NAME;
    }

    public static TableDefinition getCountersTableDefinition() {
        TableDefinition table = new TableDefinition(TABLE_NAME);
        table.addColumn(ColumnDefinition.column(COLUMN_PROPERTY_NAME, STRING_COLUMN_TYPE, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addColumn(ColumnDefinition.column(COLUMN_TABLE_NAME, STRING_COLUMN_TYPE, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addColumn(ColumnDefinition.column(COLUMN_LONG_VALUE, ColumnDefinition.Type.LONGINT, ColumnDefinition.NullRestriction.NOT_NULL));
        table.addPrimaryKey(COLUMN_PROPERTY_NAME);
        table.addPrimaryKey(COLUMN_TABLE_NAME);
        return table;
    }

    void initLong(DbConnection connection, String propertyName, String tableName, long value) throws SQLException, DbConnectException {
        Counters.validateString(propertyName);
        Counters.validateString(tableName);
        InsertStatementBuilder statement = new InsertStatementBuilder();
        statement.table(TABLE_NAME);
        statement.addValue(COLUMN_PROPERTY_NAME, propertyName);
        statement.addValue(COLUMN_TABLE_NAME, tableName);
        statement.addValue(COLUMN_LONG_VALUE, value);
        connection.execute(statement.build());
    }

    private IFilterElement getFilter(String propertyName) {
        return SqlFilter.equal(SqlFilter.column(COLUMN_PROPERTY_NAME), SqlFilter.value(propertyName));
    }

    private IFilterElement getFilter(String propertyName, String tableName) {
        return SqlFilter.and(SqlFilter.equal(SqlFilter.column(COLUMN_PROPERTY_NAME), SqlFilter.value(propertyName)), SqlFilter.equal(SqlFilter.column(COLUMN_TABLE_NAME), SqlFilter.value(tableName)));
    }

    void setLong(DbConnection connection, String propertyName, String tableName, long value) throws SQLException, DbConnectException {
        Counters.validateString(propertyName);
        Counters.validateString(tableName);
        UpdateStatementBuilder statement = new UpdateStatementBuilder();
        statement.table(TABLE_NAME);
        statement.addValue(COLUMN_LONG_VALUE, value);
        statement.setFilter(this.getFilter(propertyName, tableName));
        if (connection.execute(statement.build()) != 1) {
            throw new IllegalStateException("Property " + propertyName + " does not exist");
        }
    }

    private ResultSet doQueryLong(DbConnection connection, String propertyName, String tableName) throws SQLException, DbConnectException {
        Counters.validateString(propertyName);
        Counters.validateString(tableName);
        SelectStatementBuilder statement = new SelectStatementBuilder();
        statement.addColumn(COLUMN_LONG_VALUE);
        statement.addTable(new Table(TABLE_NAME));
        statement.setFilter(this.getFilter(propertyName, tableName));
        return connection.execute(statement.build());
    }

    long getLong(DbConnection connection, String propertyName, String tableName) throws SQLException, DbConnectException {
        ResultSet results = this.doQueryLong(connection, propertyName, tableName);
        if (!results.next()) {
            throw new IllegalStateException("No mapping for property " + propertyName);
        }
        return results.getLong(1);
    }

    Long queryLong(DbConnection connection, String propertyName, String tableName) throws SQLException, DbConnectException {
        ResultSet results = this.doQueryLong(connection, propertyName, tableName);
        if (results.next()) {
            return new Long(results.getLong(1));
        }
        return null;
    }

    long getMaxLong(DbConnection connection, String propertyName) throws SQLException, DbConnectException {
        Counters.validateString(propertyName);
        SelectStatementBuilder statement = new SelectStatementBuilder();
        statement.addMax(COLUMN_LONG_VALUE);
        statement.addTable(new Table(TABLE_NAME));
        statement.setFilter(this.getFilter(propertyName));
        ResultSet result = connection.execute(statement.build());
        result.next();
        return result.getLong(1);
    }

    void erase(DbConnection connection, String propertyName, String tableName) throws SQLException, DbConnectException {
        Counters.validateString(propertyName);
        Counters.validateString(tableName);
        DeleteStatementBuilder statement = new DeleteStatementBuilder();
        statement.addTable(TABLE_NAME);
        statement.setFilter(this.getFilter(propertyName, tableName));
        connection.execute(statement.build());
    }
}

