/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtils {
    private static SingletonFileLogger logger = SingletonFileLogger.GetInstance();

    public static void close(DbConnection connection) {
        if (connection != null) {
            ConnectionUtils.closeAndHandleException(connection);
        }
    }

    public static void close(Collection<DbConnection> connections) {
        Iterator<DbConnection> iter = connections.iterator();
        while (iter.hasNext()) {
            ConnectionUtils.closeAndHandleException(iter.next());
        }
    }

    private static void closeAndHandleException(DbConnection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            logger.LogWriteWarning("XMJU13-001", "Error closing connection: " + SingletonFileLogger.StackTraceOf(e));
        }
    }
}

