/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.Value;

public class ColumnDefinition {
    private String m_name;
    private Type m_type;
    private NullRestriction m_null;
    private Value m_defaultValue;
    private String[] m_enumValues;
    private boolean m_clientTruncate;

    public static ColumnDefinition column(String name, Type type) {
        return ColumnDefinition.column(name, type, NullRestriction.NULL);
    }

    public static ColumnDefinition column(String name, Type type, NullRestriction restriction) {
        return ColumnDefinition.column(name, type, restriction, ColumnDefinition.nullDefaultValue());
    }

    public static ColumnDefinition column(String name, Type type, NullRestriction restriction, Value defaultValue) {
        return new ColumnDefinition(name, type, restriction, defaultValue, false, null);
    }

    public static ColumnDefinition clientTruncateColumn(String name, Type type) {
        return ColumnDefinition.clientTruncateColumn(name, type, NullRestriction.NULL);
    }

    public static ColumnDefinition clientTruncateColumn(String name, Type type, NullRestriction restriction) {
        return ColumnDefinition.clientTruncateColumn(name, type, restriction, ColumnDefinition.nullDefaultValue());
    }

    public static ColumnDefinition clientTruncateColumn(String name, Type type, NullRestriction restriction, Value defaultValue) {
        return new ColumnDefinition(name, type, restriction, defaultValue, true, null);
    }

    public static ColumnDefinition enumColumn(String name, NullRestriction restriction, String[] values) {
        return new ColumnDefinition(name, Type.ENUM, restriction, ColumnDefinition.nullDefaultValue(), false, values);
    }

    public static Value defaultValue(int value) {
        return new Value(value);
    }

    public static Value defaultValue(boolean value) {
        return new Value(value);
    }

    public static Value defaultValue(String value) {
        return new Value(value);
    }

    public static Value nullDefaultValue() {
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Type getType() {
        return this.m_type;
    }

    public NullRestriction getNull() {
        return this.m_null;
    }

    public Value getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isClientTruncate() {
        return this.m_clientTruncate;
    }

    public String[] getEnumValues() {
        return this.m_enumValues;
    }

    public String getTypeStringRepresentation() {
        if (this.m_type == Type.ENUM) {
            return "ENUM" + Type.sqlTypeToString(this.m_type.getSqlType(), this.maxLength(this.m_enumValues));
        }
        return this.m_type.toString();
    }

    private ColumnDefinition(String name, Type type, NullRestriction restriction, Value defaultValue, boolean clientTruncate, String[] enumValues) {
        this.m_name = name;
        this.m_type = type;
        this.m_null = restriction;
        this.m_defaultValue = defaultValue;
        this.m_clientTruncate = clientTruncate;
        this.m_enumValues = enumValues;
    }

    public boolean equals(Object o) {
        if (o instanceof ColumnDefinition) {
            ColumnDefinition cd = (ColumnDefinition)o;
            return cd.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private int maxLength(String[] values) {
        int len = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                len = Math.max(len, values[i].length());
            }
        }
        return len;
    }

    public static final class NullRestriction {
        public static final NullRestriction NULL = new NullRestriction();
        public static final NullRestriction NOT_NULL = new NullRestriction();

        private NullRestriction() {
        }
    }

    public static final class Type {
        public static final Type BOOLEAN = new Type(1, 1);
        public static final Type INT = new Type(4, -1);
        public static final Type DATE = new Type(93, -1);
        public static final Type STRING = new Type(12, 255);
        public static final Type BYTE = new Type(-6, -1);
        public static final Type LONGINT = new Type(-5, -1);
        public static final Type LONGSTRING = new Type(-1, 65535);
        public static final Type TRANSACTIONID = new Type(12, 62);
        public static final Type GUID = new Type(12, 38);
        public static final Type ENTRYID = new Type(12, 100);
        public static final Type ENUM = new Type(1, -1);
        private int m_sqlType;
        private int m_columnSize;

        public String toString() {
            return Type.sqlTypeToString(this.m_sqlType, this.m_columnSize);
        }

        public int getSqlType() {
            return this.m_sqlType;
        }

        public int getColumnSize() {
            return this.m_columnSize;
        }

        public static String sqlTypeToString(int sqlType, int columnSize) {
            switch (sqlType) {
                case -6: 
                case -5: 
                case 4: 
                case 93: {
                    return Type.toString(sqlType);
                }
                case -1: 
                case 1: 
                case 12: {
                    return Type.toString(sqlType) + "(" + columnSize + ")";
                }
            }
            return null;
        }

        private static String toString(int sqlType) {
            switch (sqlType) {
                case -5: {
                    return "BIGINT";
                }
                case 4: {
                    return "INT";
                }
                case -6: {
                    return "TINYINT";
                }
                case 1: {
                    return "CHAR";
                }
                case 12: {
                    return "VARCHAR";
                }
                case -1: {
                    return "LONGVARCHAR";
                }
                case 93: {
                    return "SQL_TIMESTAMP";
                }
            }
            return null;
        }

        private Type(int sqlType, int columnSize) {
            this.m_sqlType = sqlType;
            this.m_columnSize = columnSize;
        }
    }
}

