/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.AbstractSqlStatementExecute;
import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DbConnection;
import Xm.JavaUtils.Database.MySqlStatementBuilder;
import Xm.JavaUtils.Database.SqlStatementExecute;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.SingletonFileLogger;
import java.sql.SQLException;

public class BatchStatementExecute
implements SqlStatementExecute {
    public int execute(SqlWriteStatement statement, DbConnection con) throws SQLException, DbConnectException {
        Executor exec = new Executor(con);
        statement.accept(exec);
        return exec.getResult();
    }

    private static class Executor
    extends AbstractSqlStatementExecute {
        Executor(DbConnection con) {
            super(con);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visit(BatchStatement statement) throws SQLException, DbConnectException {
            if (!statement.isExecuteWithinSameTransaction() || statement.count() < 2) {
                this.doExecute(statement);
                return;
            }
            DbConnection.Lock lock = null;
            try {
                boolean restoreAutoCommit = this.con.getAutoCommit();
                if (restoreAutoCommit) {
                    try {
                        lock = this.con.getLock();
                        this.con.setAutoCommit(false);
                    }
                    catch (SQLException ex) {
                        MySqlStatementBuilder builder = new MySqlStatementBuilder();
                        SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU57-001", ex.getMessage());
                        SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU57-001", builder.toString(statement));
                        throw ex;
                    }
                }
                try {
                    this.doExecute(statement);
                    if (restoreAutoCommit) {
                        this.con.commit();
                    }
                }
                finally {
                    if (restoreAutoCommit) {
                        try {
                            this.con.setAutoCommit(true);
                        }
                        catch (SQLException ex) {
                            MySqlStatementBuilder builder = new MySqlStatementBuilder();
                            SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU57-001", ex.getMessage());
                            SingletonFileLogger.GetInstance().LogWriteFatalError("XMJU57-001", builder.toString(statement));
                            throw ex;
                        }
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        private void doExecute(BatchStatement statements) throws SQLException, DbConnectException {
            int batchResult = 0;
            for (SqlWriteStatement statement : statements.all()) {
                statement.accept(this);
                batchResult += this.getResult();
            }
            this.result = batchResult;
        }
    }
}

