/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.SqlStatementToString;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SqlWriteStatementVisitor;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchStatement
extends SqlWriteStatement {
    private static final long serialVersionUID = -4183876317248662818L;
    private final SqlWriteStatement[] m_statements;
    private final boolean executeWithinSameTransaction;

    public BatchStatement(SqlWriteStatement[] statements) {
        this(statements, false, null);
    }

    public BatchStatement(SqlWriteStatement[] statements, boolean executeWithinSameTransaction) {
        this(statements, executeWithinSameTransaction, null);
    }

    public BatchStatement(BatchStatement statement, Map<String, Object> additionalProperties) {
        this(statement.m_statements, statement.executeWithinSameTransaction, BatchStatement.merge(statement.cloneProperties(), additionalProperties));
    }

    public BatchStatement(SqlWriteStatement[] statements, boolean executeWithinSameTransaction, Map<String, Object> properties) {
        super(properties);
        this.m_statements = (SqlWriteStatement[])statements.clone();
        this.executeWithinSameTransaction = executeWithinSameTransaction;
    }

    private static Map<String, Object> merge(Map<String, Object> properties, Map<String, Object> additionalproperties) {
        properties.putAll(additionalproperties);
        return properties;
    }

    boolean isExecuteWithinSameTransaction() {
        return this.executeWithinSameTransaction;
    }

    public SqlWriteStatement[] all() {
        return (SqlWriteStatement[])this.m_statements.clone();
    }

    public int count() {
        return this.m_statements.length;
    }

    @Override
    public String toString(SqlStatementToString visitor) {
        return visitor.toString(this);
    }

    @Override
    public void accept(SqlWriteStatementVisitor visitor) throws SQLException, DbConnectException {
        visitor.visit(this);
    }
}

