/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.Database;

import Xm.JavaUtils.Database.BatchStatement;
import Xm.JavaUtils.Database.CreateFunctionStatement;
import Xm.JavaUtils.Database.CreateTableStatement;
import Xm.JavaUtils.Database.CreateTriggerStatement;
import Xm.JavaUtils.Database.DbConnectException;
import Xm.JavaUtils.Database.DeleteStatement;
import Xm.JavaUtils.Database.DropFunctionStatement;
import Xm.JavaUtils.Database.DropTableStatement;
import Xm.JavaUtils.Database.DropTriggerStatement;
import Xm.JavaUtils.Database.InsertStatement;
import Xm.JavaUtils.Database.LockTablesStatement;
import Xm.JavaUtils.Database.RenameTablesStatement;
import Xm.JavaUtils.Database.SqlWriteStatement;
import Xm.JavaUtils.Database.SqlWriteStatementVisitor;
import Xm.JavaUtils.Database.UnlockTablesStatement;
import Xm.JavaUtils.Database.UpdateStatement;
import java.sql.SQLException;

public class AbstractSqlStatementTransform
implements SqlWriteStatementVisitor {
    protected SqlWriteStatement transformedStatement;

    public SqlWriteStatement getTransformedStatement() {
        return this.transformedStatement;
    }

    public void visit(UpdateStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(InsertStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(DeleteStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(CreateTableStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(LockTablesStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(UnlockTablesStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(DropTableStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(RenameTablesStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(BatchStatement statement) throws SQLException, DbConnectException {
        SqlWriteStatement[] statements = statement.all();
        SqlWriteStatement[] newStatements = new SqlWriteStatement[statements.length];
        for (int index = 0; index < statements.length; ++index) {
            statements[index].accept(this);
            newStatements[index] = this.transformedStatement;
        }
        this.transformedStatement = new BatchStatement(newStatements);
    }

    public void visit(CreateTriggerStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(DropTriggerStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(CreateFunctionStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }

    public void visit(DropFunctionStatement statement) throws SQLException, DbConnectException {
        this.transformedStatement = statement;
    }
}

