/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.Credentials;
import Xm.JavaUtils.DirectoryHelper;
import Xm.JavaUtils.ServiceUnavailableX;
import com.interstarinc.jacorbext.OrbFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public final class CorbaInitializer {
    private boolean isInitialized;
    private ORB orb;
    private POA rootPoa;
    private String jacorbPropFile;
    private String principal;

    CorbaInitializer(String jacorbPropFile, String principal) {
        this.jacorbPropFile = jacorbPropFile;
        this.principal = principal;
    }

    public ORB getOrb() throws ServiceUnavailableX {
        this.init();
        return this.orb;
    }

    public POA getRootPoa() throws ServiceUnavailableX {
        this.init();
        return this.rootPoa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws ServiceUnavailableX {
        if (this.isInitialized) {
            return;
        }
        CorbaInitializer corbaInitializer = this;
        synchronized (corbaInitializer) {
            if (this.isInitialized) {
                return;
            }
            try {
                Credentials.EstablishSecurityOrThrow(this.principal);
                Properties props = new Properties();
                props.putAll((Map<?, ?>)System.getProperties());
                props.putAll((Map<?, ?>)this.getJacorbProperties());
                props.putAll((Map<?, ?>)this.getKeystoreProperties());
                props.putAll((Map<?, ?>)this.getClientLocaleInterceptorProperties());
                this.orb = OrbFactory.createOrb(this.getCustomPropertiesFileName(), props);
                this.rootPoa = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
                this.rootPoa.the_POAManager().activate();
            }
            catch (Exception e) {
                throw new ServiceUnavailableX(e.getMessage(), e);
            }
            this.isInitialized = true;
        }
    }

    private Properties getJacorbProperties() {
        Properties props = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(this.jacorbPropFile);
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    private Properties getKeystoreProperties() {
        Properties props = new Properties();
        props.put("jacorb.security.keystore", DirectoryHelper.GetDataFolder("Security") + "/" + this.principal + "KeyStore.keystore");
        props.put("jacorb.security.keystore_password", this.principal);
        props.put("jacorb.security.default_user", this.principal);
        props.put("jacorb.security.default_password", this.principal);
        return props;
    }

    private Properties getClientLocaleInterceptorProperties() {
        Properties props = new Properties();
        props.put("org.omg.PortableInterceptor.ORBInitializerClass.Xm.JavaUtils.LocaleClientInterceptorInitializer", "Xm.JavaUtils.LocaleClientInterceptorInitializer");
        return props;
    }

    private String getCustomPropertiesFileName() {
        return null;
    }
}

