/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.JavaUtils.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleLogger
implements Logger {
    private int m_iErrorLevel;
    private DateFormat m_DateFormat;

    public ConsoleLogger() {
        this(1);
    }

    public ConsoleLogger(int iErrorLevel) {
        this.m_iErrorLevel = iErrorLevel;
        this.m_DateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    }

    public void ChangeErrorLevel(int iErrorLevel) {
        if (iErrorLevel < 0 || iErrorLevel > 3) {
            throw new IllegalArgumentException();
        }
        this.m_iErrorLevel = iErrorLevel;
    }

    private String GetLocalTime() {
        return this.m_DateFormat.format(new Date());
    }

    public void LogWriteLowLevel(String strLogCode, String strLogToAdd) {
        this.outputLog(strLogToAdd, 0, strLogCode);
    }

    public void LogWriteNormal(String strLogCode, String strLogToAdd) {
        this.outputLog(strLogToAdd, 1, strLogCode);
    }

    public void LogWriteWarning(String strLogCode, String strLogToAdd) {
        this.outputLog(strLogToAdd, 2, strLogCode);
    }

    public void LogWriteFatalError(String strLogCode, String strLogToAdd) {
        this.outputLog(strLogToAdd, 3, strLogCode);
    }

    private void outputLog(String strLogToAdd, int iErrorLevel, String strLogCode) {
        if (iErrorLevel >= this.m_iErrorLevel) {
            StringBuffer CompleteLine = new StringBuffer();
            CompleteLine.append("(");
            CompleteLine.append(iErrorLevel);
            CompleteLine.append(")(");
            CompleteLine.append(this.GetLocalTime());
            CompleteLine.append(")(");
            CompleteLine.append(Thread.currentThread().getName());
            CompleteLine.append(")");
            CompleteLine.append("(");
            CompleteLine.append(strLogCode);
            CompleteLine.append(")");
            CompleteLine.append(": ");
            CompleteLine.append(strLogToAdd);
            this.outputLog(CompleteLine.toString());
        }
    }

    private synchronized void outputLog(String completeLine) {
        System.out.println(completeLine);
    }
}

