/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.BadParamsX;
import Xm.InvalidPropertiesX;
import Xm.JavaUtils.ConfigListLinkObserver;
import Xm.JavaUtils.CorbaObjectResolver;
import Xm.JavaUtils.Database.JavaCorbaConversion.ListConverter;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.List;
import Xm.ListNotif;
import Xm.ListNotifier;
import Xm.ListNotifierHelper;
import Xm.ListNotifierPOA;
import Xm.StorageException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigListLink<MappedStruct>
extends ListNotifierPOA {
    private java.util.List<MappedStruct> list = new ArrayList<MappedStruct>();
    private ListConverter<MappedStruct> converter;
    private ConfigListLinkObserver observer;
    private CorbaObjectResolver<List> configResolver;
    private volatile boolean needUpdate = true;
    private boolean isRegistered = false;
    private int configUpdateRegistrationId;
    private List cachedList;
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private POA poa;

    public ConfigListLink(ListConverter<MappedStruct> converter, CorbaObjectResolver<List> configResolver, POA poa, ConfigListLinkObserver observer) {
        this.converter = converter;
        this.configResolver = configResolver;
        this.poa = poa;
        this.observer = observer;
    }

    public java.util.List<MappedStruct> getAllRecords() throws ConfigListLinkException, CorbaObjectResolver.ResolveException, SystemException {
        try {
            if (!this.isRegistered) {
                this.registerToConfigUpdate(this.poa);
            }
            if (this.needUpdate) {
                this.Update();
            }
        }
        catch (NoSuchMethodException e) {
            throw new ConfigListLinkException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigListLinkException(e);
        }
        catch (UserException e) {
            throw new ConfigListLinkException(e);
        }
        catch (InstantiationException e) {
            this.fileLogger.LogWriteFatalError("XMJU32-001", "Cannot instantiate object: " + e.getMessage());
            throw new IllegalStateException();
        }
        catch (IllegalAccessException e) {
            this.fileLogger.LogWriteFatalError("XMJU32-002", "Cannot access object: " + e.getMessage());
            throw new IllegalStateException();
        }
        return this.list;
    }

    public long add(final MappedStruct entity) throws StorageException, InvalidPropertiesX, BadParamsX, IllegalArgumentException, CorbaObjectResolver.ResolveException, ConfigListLinkException {
        try {
            this.fileLogger.LogWriteLowLevel("XMJU32-003", "ConfigListLink add a new record in the list");
            ListRefHandler<Long> handler = new ListRefHandler<Long>(this.cachedList){

                @Override
                public void targetMethod() throws StorageException, InvalidPropertiesX, BadParamsX, IllegalArgumentException, CorbaObjectResolver.ResolveException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    this.result = this.getList().AddTypedValues(ConfigListLink.this.converter.getProperties(), ConfigListLink.this.converter.toTypedValues(entity));
                }
            };
            handler.call();
            return (Long)handler.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new ConfigListLinkException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigListLinkException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigListLinkException(e);
        }
        catch (IllegalAccessException e) {
            this.fileLogger.LogWriteFatalError("XMJU32-003", "Cannot access object: " + e.getMessage());
            throw new IllegalStateException();
        }
    }

    public void remove(final long[] ids) throws StorageException, InvalidPropertiesX, BadParamsX, IllegalArgumentException, CorbaObjectResolver.ResolveException, IllegalAccessException, ConfigListLinkException {
        try {
            this.fileLogger.LogWriteLowLevel("XMJU32-004", "ConfigListLink remove some records from the list : " + ids);
            ListRefHandler handler = new ListRefHandler(this.cachedList){

                public void targetMethod() throws StorageException, CorbaObjectResolver.ResolveException {
                    this.getList().DeleteRecords(ids);
                }
            };
            handler.call();
        }
        catch (NoSuchFieldException e) {
            throw new ConfigListLinkException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigListLinkException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigListLinkException(e);
        }
    }

    public void update(final MappedStruct entity) throws StorageException, InvalidPropertiesX, BadParamsX, IllegalArgumentException, CorbaObjectResolver.ResolveException, ConfigListLinkException {
        try {
            this.fileLogger.LogWriteLowLevel("XMJU32-005", "ConfigListLink update a record in the list...");
            ListRefHandler handler = new ListRefHandler(this.cachedList){

                public void targetMethod() throws StorageException, InvalidPropertiesX, BadParamsX, CorbaObjectResolver.ResolveException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
                    long id = ConfigListLink.this.converter.getId(entity);
                    this.getList().SetTypedValues(new long[]{id}, ConfigListLink.this.converter.getProperties(), ConfigListLink.this.converter.toTypedValues(entity));
                }
            };
            handler.call();
        }
        catch (NoSuchFieldException e) {
            throw new ConfigListLinkException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigListLinkException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigListLinkException(e);
        }
        catch (IllegalAccessException e) {
            this.fileLogger.LogWriteFatalError("XMJU32-005", "Cannot access object: " + e.getMessage());
            throw new IllegalStateException();
        }
    }

    public void unregisterToConfigUpdate() {
        if (!this.isRegistered) {
            return;
        }
        try {
            List peerList = this.getPrimaryList();
            peerList.UnregisterNotifier(this.configUpdateRegistrationId);
            this.fileLogger.LogWriteNormal("XMJU32-006", "ConfigListLink notifier unregistered from ConfigManager.");
            this.isRegistered = false;
        }
        catch (CorbaObjectResolver.ResolveException e) {
            this.fileLogger.LogWriteWarning("XMJU32-007", "ConfigListLink notifier was not unregistered from ConfigManager." + e.getMessage());
        }
        catch (SystemException e) {
            this.fileLogger.LogWriteWarning("XMJU32-008", "ConfigListLink notifier was not unregistered from ConfigManager. " + e.getMessage());
        }
        catch (UserException e) {
            this.fileLogger.LogWriteWarning("XMJU32-009", "ConfigListLink notifier was not unregistered from ConfigManager. " + e.getMessage());
        }
    }

    @Override
    public void TransmitNotification(ListNotif Notification, long SeqNumber) {
        this.fileLogger.LogWriteWarning("XMJU32-010", "ConfigListLink configuration change: Update needed");
        this.needUpdate = true;
        if (this.observer != null) {
            this.observer.configListUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Update() throws UserException, CorbaObjectResolver.ResolveException, InstantiationException, ConfigListLinkException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String log_begin = "Updating ConfigListLink...";
        this.fileLogger.LogWriteNormal("XMJU32-011", log_begin);
        try {
            java.util.List<MappedStruct> list = this.converter.toJavaList(this.getPrimaryList());
            this.fileLogger.LogWriteNormal("XMJU32-011", log_begin + "Done collecting records");
            ConfigListLink configListLink = this;
            synchronized (configListLink) {
                this.list = list;
                this.needUpdate = false;
            }
            this.fileLogger.LogWriteNormal("XMJU32-011", log_begin + "Done saving records");
        }
        catch (UserException e) {
            this.fileLogger.LogWriteWarning("XMJU32-011", log_begin + "Error - " + e.getMessage());
        }
    }

    private void registerToConfigUpdate(POA Poa) throws UserException, CorbaObjectResolver.ResolveException {
        String log_begin = "Registering ConfigListLink Notifier to ConfigManager...";
        this.fileLogger.LogWriteNormal("XMJU32-012", log_begin);
        ListNotifier config_notifier = ListNotifierHelper.narrow(Poa.servant_to_reference((Servant)this));
        List peer_list = this.getPrimaryList();
        Integer temp = peer_list.RegisterNotifier(config_notifier);
        this.configUpdateRegistrationId = temp;
        this.isRegistered = true;
        this.fileLogger.LogWriteNormal("XMJU32-012", log_begin + "Done");
    }

    private List getPrimaryList() throws CorbaObjectResolver.ResolveException {
        this.cachedList = this.configResolver.resolve();
        return this.cachedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ListRefHandler<Result> {
        private List list;
        private short attempt = 0;
        protected Result result;

        public ListRefHandler(List list) {
            this.list = list;
        }

        public void call() throws StorageException, InvalidPropertiesX, BadParamsX, CorbaObjectResolver.ResolveException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
            while (true) {
                try {
                    this.targetMethod();
                    return;
                }
                catch (SystemException e) {
                    this.handleException(e);
                    continue;
                }
                break;
            }
        }

        public Result getResult() {
            return this.result;
        }

        public abstract void targetMethod() throws StorageException, InvalidPropertiesX, BadParamsX, CorbaObjectResolver.ResolveException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException;

        protected List getList() throws CorbaObjectResolver.ResolveException {
            if (this.list == null) {
                this.list = ConfigListLink.this.getPrimaryList();
                this.attempt = (short)(this.attempt + 1);
            }
            return this.list;
        }

        protected void handleException(SystemException e) {
            if (this.attempt >= 1 || e instanceof TIMEOUT) {
                throw e;
            }
            this.list = null;
        }
    }

    public static class ConfigListLinkException
    extends Exception {
        private static final long serialVersionUID = 431750055092888626L;

        public ConfigListLinkException(Throwable cause) {
            super(cause);
        }
    }
}

