/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.Config;
import Xm.ConfigNotifier;
import Xm.ConfigNotifierHelper;
import Xm.ConfigNotifierPOA;
import Xm.JavaUtils.ConfigLinkObserver;
import Xm.JavaUtils.CorbaObjectResolver;
import Xm.JavaUtils.Database.JavaCorbaConversion.NamedPropertyConverter;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.StorageException;
import Xm.TypedValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLink
extends ConfigNotifierPOA {
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private ConfigLinkObserver observer;
    private POA poa;
    private boolean isRegistered = false;
    private int configUpdateRegistrationId;
    private CorbaObjectResolver<Config> configResolver;
    private Map<String, Object> properties;
    private NamedPropertyConverter converter;
    private Set<String> propertySet;

    public ConfigLink(CorbaObjectResolver<Config> configResolver, POA poa, ConfigLinkObserver observer) {
        this.configResolver = configResolver;
        this.poa = poa;
        this.observer = observer;
        this.converter = new NamedPropertyConverter();
        this.properties = new Hashtable<String, Object>();
    }

    public ConfigLink(CorbaObjectResolver<Config> configResolver, POA poa, ConfigLinkObserver observer, String[] propertySet) {
        this(configResolver, poa, observer);
        this.propertySet = new HashSet<String>(Arrays.asList(propertySet));
    }

    @Override
    public void TransmitUpdatedValue(String[] properties, TypedValue[] values, long SeqNumber) {
        this.update(properties, values);
        if (this.observer != null) {
            this.observer.configListUpdated(this.properties);
        }
    }

    public Map<String, Object> getProperties() throws UserException, CorbaObjectResolver.ResolveException {
        if (!this.isRegistered) {
            this.registerToConfigUpdate(this.poa);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    private void update(String[] properties, TypedValue[] values) {
        Hashtable<String, Object> copy = new Hashtable<String, Object>(this.properties);
        for (int index = 0; index < properties.length; ++index) {
            if (this.propertySet != null && !this.propertySet.contains(properties[index])) continue;
            copy.put(properties[index], this.converter.toValue(values[index]));
        }
        this.properties = copy;
    }

    private void registerToConfigUpdate(POA Poa) throws UserException, CorbaObjectResolver.ResolveException {
        String log_begin = "Registering ConfigListLink Notifier to ConfigManager...";
        this.fileLogger.LogWriteNormal("XMJU34-001", log_begin);
        ConfigNotifier config_notifier = ConfigNotifierHelper.narrow(Poa.servant_to_reference((Servant)this));
        Config config = this.getConfig();
        String[] props = this.propertySet != null ? this.propertySet.toArray(new String[0]) : config.GetProperties();
        this.update(props, config.GetTypedValues(props));
        this.configUpdateRegistrationId = config.RegisterNotifier(config_notifier);
        this.isRegistered = true;
        this.fileLogger.LogWriteNormal("XMJU34-001", log_begin + "Done");
    }

    public void unregisterToConfigUpdate() throws CorbaObjectResolver.ResolveException, StorageException {
        if (!this.isRegistered) {
            return;
        }
        Config config = this.getConfig();
        config.UnregisterNotifier(this.configUpdateRegistrationId);
        this.isRegistered = false;
        this.fileLogger.LogWriteNormal("XMJU34-002", "ConfigListLink notifier unregistered from ConfigManager.");
    }

    private Config getConfig() throws CorbaObjectResolver.ResolveException {
        return this.configResolver.resolve();
    }
}

