/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils;

import Xm.CoConfigEroHelper;
import Xm.CoConfigRwHelper;
import Xm.ConfigNotifierHelper;
import Xm.FaultTolerance.ComponentInstanceHelper;
import Xm.FaultTolerance.DbComponentInstanceHelper;
import Xm.FaultTolerance.MonitorableHelper;
import Xm.FaultTolerance.StatementExecutorHelper;
import Xm.FaxArchive.AccessorHelper;
import Xm.FaxArchive.ArchiveHelper;
import Xm.FaxArchive.InboundFaxAccessorHelper;
import Xm.FaxArchive.InboundHistoryImporterHelper;
import Xm.FaxArchive.OffsiteReplication.FaxBoxDelegationConfigManagerHelper;
import Xm.FaxArchive.OffsiteReplication.ManagerHelper;
import Xm.FaxArchive.OffsiteReplication.PhonebookManagerHelper;
import Xm.FaxArchive.OffsiteReplication.UpdaterHelper;
import Xm.FaxArchive.OutboundHistoryImporterHelper;
import Xm.FaxArchive.UserInboxesHelper;
import Xm.FaxArchive.UserOutboxesHelper;
import Xm.FaxManager.WorkerHelper;
import Xm.JavaUtils.ReplicaState;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.JavaUtils.TradingService;
import Xm.ListNotifierHelper;
import Xm.Phonebook.CleanerHelper;
import Xm.Phonebook.ServiceHelper;
import Xm.Security.Impl.SecurityAgentObserverHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.FT.PullMonitorableHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ComponentServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final long serialVersionUID = 2048513634998613367L;
    private SingletonFileLogger m_FileLogger;
    private Map<String, Info> m_Interfaces = new HashMap<String, Info>();
    private Set<String> m_ReadMethodsForWritingInterfaces = new HashSet<String>();
    private Set<String> m_NoForwardRequestInterfaces = new HashSet<String>();
    private Set<String> m_NoForwardRequestOperations = new HashSet<String>();
    private TradingService m_Trading = null;

    public ComponentServerInterceptor() {
        this.m_FileLogger = SingletonFileLogger.GetInstance();
        this.m_Interfaces.put(ArchiveHelper.id(), new Info(Access.WRITE, 0, "ArchiveArchiverGroup"));
        this.m_Interfaces.put(UserOutboxesHelper.id(), new Info(Access.WRITE, 0, "UserOutboxesGroup"));
        this.m_Interfaces.put(UserInboxesHelper.id(), new Info(Access.WRITE, 0, "UserInboxesGroup"));
        this.m_Interfaces.put(WorkerHelper.id(), new Info(Access.WRITE, 0, null));
        this.m_Interfaces.put(InboundHistoryImporterHelper.id(), new Info(Access.WRITE, 0, "InboundHistoryImporterGroup"));
        this.m_Interfaces.put(OutboundHistoryImporterHelper.id(), new Info(Access.WRITE, 0, "OutboundHistoryImporterGroup"));
        this.m_Interfaces.put(ManagerHelper.id(), new Info(Access.WRITE, 0, "OffsiteReplicationManagerGroup"));
        this.m_Interfaces.put(CoConfigRwHelper.id(), new Info(Access.WRITE, 1, "CompanyConfigReadWriteGroup"));
        this.m_Interfaces.put(ServiceHelper.id(), new Info(Access.WRITE, 2, "PhonebookService"));
        this.m_Interfaces.put(PhonebookManagerHelper.id(), new Info(Access.WRITE, 2, "PhonebookOffsiteReplicationManager"));
        this.m_Interfaces.put(CleanerHelper.id(), new Info(Access.WRITE, 2, "PhonebookCleaner"));
        this.m_Interfaces.put(Xm.FaxBoxDelegationConfig.ServiceHelper.id(), new Info(Access.WRITE, 3, "FaxBoxDelegationConfigService"));
        this.m_Interfaces.put(FaxBoxDelegationConfigManagerHelper.id(), new Info(Access.WRITE, 3, "FaxBoxDelegationConfigOffsiteReplicationManager"));
        this.m_Interfaces.put(Xm.FaxBoxDelegationConfig.CleanerHelper.id(), new Info(Access.WRITE, 3, "FaxBoxDelegationConfigCleaner"));
        this.m_Interfaces.put(AccessorHelper.id(), new Info(Access.READ, 0, "ArchiveOutboundAccessorGroup"));
        this.m_Interfaces.put(InboundFaxAccessorHelper.id(), new Info(Access.READ, 0, "ArchiveInboundAccessorGroup"));
        this.m_Interfaces.put(CoConfigEroHelper.id(), new Info(Access.READ, 1, "CompanyConfigEffectiveReadOnlyGroup"));
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetFolders");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetProperties");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetRow");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetTableRow");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetTable");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetSubTable");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetCount");
        this.m_ReadMethodsForWritingInterfaces.add(CoConfigRwHelper.id() + "__GetGlobalCount");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__SearchEntries");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__SearchInGroupDirect");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__GetDirectGroups");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__GetGroupsInfo");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__GetPersonsInfo");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__GetPhonebooks");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__SearchPersons");
        this.m_ReadMethodsForWritingInterfaces.add(ServiceHelper.id() + "__GetPersonsInGroupRecursive");
        this.m_ReadMethodsForWritingInterfaces.add(Xm.FaxBoxDelegationConfig.ServiceHelper.id() + " __AccessibleFaxBoxes");
        this.m_ReadMethodsForWritingInterfaces.add(Xm.FaxBoxDelegationConfig.ServiceHelper.id() + " __GetDelegates");
        this.m_NoForwardRequestInterfaces.add(DbComponentInstanceHelper.id());
        this.m_NoForwardRequestInterfaces.add(ComponentInstanceHelper.id());
        this.m_NoForwardRequestInterfaces.add(MonitorableHelper.id());
        this.m_NoForwardRequestInterfaces.add(PullMonitorableHelper.id());
        this.m_NoForwardRequestInterfaces.add(ConfigNotifierHelper.id());
        this.m_NoForwardRequestInterfaces.add(ListNotifierHelper.id());
        this.m_NoForwardRequestInterfaces.add(StatementExecutorHelper.id());
        this.m_NoForwardRequestInterfaces.add(UpdaterHelper.id());
        this.m_NoForwardRequestInterfaces.add(SecurityAgentObserverHelper.id());
        this.m_NoForwardRequestOperations.add("_create_request");
        this.m_NoForwardRequestOperations.add("_duplicate");
        this.m_NoForwardRequestOperations.add("_get_domain_managers");
        this.m_NoForwardRequestOperations.add("_get_interface_def");
        this.m_NoForwardRequestOperations.add("_get_policy");
        this.m_NoForwardRequestOperations.add("_hash");
        this.m_NoForwardRequestOperations.add("_is_a");
        this.m_NoForwardRequestOperations.add("_is_equivalent");
        this.m_NoForwardRequestOperations.add("_non_existent");
        this.m_NoForwardRequestOperations.add("_release");
        this.m_NoForwardRequestOperations.add("_request");
        this.m_NoForwardRequestOperations.add("_set_policy_override");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TradingService getTradingService() {
        if (this.m_Trading == null) {
            ComponentServerInterceptor componentServerInterceptor = this;
            synchronized (componentServerInterceptor) {
                if (this.m_Trading == null) {
                    this.m_Trading = new TradingService();
                }
            }
        }
        return this.m_Trading;
    }

    private void ForwardRequest(ServerRequestInfo ri) throws ForwardRequest {
        String tradingOfferType;
        String corbaInterface = ri.target_most_derived_interface();
        Info info = this.m_Interfaces.get(corbaInterface);
        String string = tradingOfferType = info != null ? info.tradingOfferType : null;
        if (tradingOfferType != null) {
            try {
                Object primaryObject = this.getTradingService().QueryFirstReference(tradingOfferType, new TraderHelperOptions());
                this.m_FileLogger.LogWriteNormal("XMJU01-004", "ComponentServerInterceptor: Sending the ForwardRequest for operation " + ri.operation() + " on " + corbaInterface);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw new ForwardRequest(primaryObject);
            }
            catch (TradingService.TradingServiceException e) {
                this.m_FileLogger.LogWriteFatalError("XMJU01-005", "ComponentServerInterceptor: Could not query for :" + tradingOfferType + "  " + e.getMessage());
                throw new BAD_OPERATION("Could not query for :" + tradingOfferType);
            }
        }
        this.m_FileLogger.LogWriteFatalError("XMJU01-006", "ComponentServerInterceptor: Interface not supported: " + corbaInterface);
        throw new BAD_OPERATION("The interface '" + corbaInterface + "' is not registered in the ComponentServerInterceptor.");
    }

    public void destroy() {
    }

    public String name() {
        return "ComponentServerInterceptor";
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        try {
            String corbaInterface = ri.target_most_derived_interface();
            if (this.m_NoForwardRequestInterfaces.contains(corbaInterface)) {
                return;
            }
            if (this.m_NoForwardRequestOperations.contains(ri.operation())) {
                return;
            }
            Info info = this.m_Interfaces.get(corbaInterface);
            if (info == null) {
                this.m_FileLogger.LogWriteFatalError("XMJU01-001", "ComponentServerInterceptor: Interface not supported: " + corbaInterface);
                throw new BAD_OPERATION("The interface '" + corbaInterface + "' is not registered in the ComponentServerInterceptor.");
            }
            switch (ReplicaState.getActiveState(info.idReplicatedService)) {
                case 0: {
                    this.ForwardRequest(ri);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (info.access != Access.WRITE || this.m_ReadMethodsForWritingInterfaces.contains(corbaInterface + "__" + ri.operation())) break;
                    this.ForwardRequest(ri);
                }
            }
        }
        catch (NO_RESOURCES e) {
            this.m_FileLogger.LogWriteFatalError("XMJU01-007", "System exception: " + e.toString());
            e.printStackTrace();
        }
        catch (IllegalStateException ex) {
            this.m_FileLogger.LogWriteFatalError("XMJU01-002", "ComponentServerInterceptor: " + ex.getMessage());
            String corbaInterface = ri.target_most_derived_interface();
            this.m_FileLogger.LogWriteFatalError("XMJU01-002", "ComponentServerInterceptor: Interface not supported: " + corbaInterface);
            throw new BAD_OPERATION("The interface '" + corbaInterface + "' is not registered in the ComponentServerInterceptor.");
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    private static class Info {
        public final Access access;
        public final int idReplicatedService;
        public final String tradingOfferType;

        public Info(Access access, int idReplicatedService, String tradingOfferType) {
            this.access = access;
            this.idReplicatedService = idReplicatedService;
            this.tradingOfferType = tradingOfferType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Access {
        READ,
        WRITE;

    }
}

