/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.JavaRegistry;
import Xm.JavaUtils.SingletonFileLogger;
import Xm.JavaUtils.Validators;
import Xm.Security.Impl.SecurityAgentObserver;
import Xm.Security.Impl.SecurityAgentObserverHelper;
import Xm.Security.Impl.SecurityAgentObserverPOA;
import Xm.Security.Impl.SecurityAgentServer;
import Xm.Security.Impl.SecurityAgentServerHelper;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class SecurityAgentObserverImpl
extends SecurityAgentObserverPOA {
    private static SecurityAgentObserverImpl theInstance = new SecurityAgentObserverImpl();
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private ORB orb;
    private POA poa;
    private List<Observer> observers = new ArrayList<Observer>();
    private Integer registrationId;
    private volatile Thread registrationThread;
    private volatile boolean registrationThreadShouldStop = false;

    public static SecurityAgentObserverImpl instance() {
        return theInstance;
    }

    private SecurityAgentObserverImpl() {
    }

    public synchronized void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public synchronized void TrustedCAsCacheChanged() {
        this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "TrustedCAsCacheChanged...");
        for (Observer observer : this.observers) {
            observer.trustedCAsCacheChanged();
        }
        this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "TrustedCAsCacheChanged...Done");
    }

    public void activate(ORB orb, POA poa) throws WrongPolicy, ServantAlreadyActive {
        this.orb = orb;
        poa.activate_object((Servant)this);
        this.poa = poa;
        try {
            SecurityAgentObserver observer = SecurityAgentObserverHelper.narrow(poa.servant_to_reference((Servant)this));
            this.registerObserver(observer);
        }
        catch (ServantNotActive ex) {
            this.fileLogger.LogWriteFatalError("SecurityAgentObserverImpl", "activate: " + ex.getMessage());
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void deactivate() {
        this.unregisterObserver();
        try {
            byte[] oid = this.poa.servant_to_id((Servant)this);
            this.poa.deactivate_object(oid);
            this.poa = null;
        }
        catch (ServantNotActive ex) {
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy wrongPolicy) {
            // empty catch block
        }
    }

    private void registerObserver(SecurityAgentObserver observer) {
        if (this.registrationThread != null) {
            throw new IllegalStateException("RegistrationThread already running");
        }
        this.registrationThreadShouldStop = false;
        class RegistrationThread
        extends Thread {
            private SecurityAgentObserver observer;

            public RegistrationThread(SecurityAgentObserver observer) {
                this.observer = observer;
                this.setName("SecurityAgentObserverImpl.RegistrationThread");
            }

            public void run() {
                while (SecurityAgentObserverImpl.this.shouldRetryToRegisterObserver()) {
                    SecurityAgentObserverImpl.this.doRegisterObserver(this.observer);
                    if (!SecurityAgentObserverImpl.this.shouldRetryToRegisterObserver()) continue;
                    try {
                        RegistrationThread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                SecurityAgentObserverImpl.this.registrationThread = null;
            }
        }
        this.registrationThread = new RegistrationThread(observer);
        this.registrationThread.start();
    }

    private boolean shouldRetryToRegisterObserver() {
        return Validators.ServiceIsNotStopping().Validate() && this.registrationId == null && !this.registrationThreadShouldStop;
    }

    private void doRegisterObserver(SecurityAgentObserver observer) {
        try {
            this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "doRegisterObserver...");
            int id = this.resolveSecurityAgentServer().RegisterObserver(observer);
            this.registrationId = new Integer(id);
            this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "doRegisterObserver...Done");
        }
        catch (SystemException ex) {
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doRegisterObserver...SystemException: " + ex.getMessage());
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doRegisterObserver...Will retry later");
        }
        catch (NullPointerException ex) {
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doRegisterObserver...NullPointerException: " + ex.getMessage());
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doRegisterObserver...Will retry later");
        }
    }

    private void unregisterObserver() {
        this.registrationThreadShouldStop = true;
        Thread theRegistrationThread = this.registrationThread;
        if (theRegistrationThread != null) {
            theRegistrationThread.notify();
            try {
                theRegistrationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.doUnregisterObserver();
    }

    private void doUnregisterObserver() {
        if (this.registrationId == null) {
            return;
        }
        try {
            this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "doUnregisterObserver...");
            this.resolveSecurityAgentServer().UnregisterObserver(this.registrationId);
            this.registrationId = null;
            this.fileLogger.LogWriteNormal("SecurityAgentObserverImpl", "doUnregisterObserver...Done");
        }
        catch (SystemException ex) {
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doUnregisterObserver...SystemException: " + ex.getMessage());
        }
        catch (NullPointerException ex) {
            this.fileLogger.LogWriteWarning("SecurityAgentObserverImpl", "doUnregisterObserver...NullPointerException: " + ex.getMessage());
        }
    }

    private SecurityAgentServer resolveSecurityAgentServer() throws NullPointerException {
        String ref = JavaRegistry.GetRegistryString(3, "SOFTWARE\\Interstar Technologies\\XMedius\\Security\\Agent", "ServerRef");
        SecurityAgentServer obj = null;
        if (!ref.equals("")) {
            obj = SecurityAgentServerHelper.narrow(this.orb.string_to_object(ref));
        }
        if (obj == null) {
            throw new NullPointerException("SecurityAgentServer is null");
        }
        return obj;
    }

    public static interface Observer {
        public void trustedCAsCacheChanged();
    }
}

