/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.AccessControl.KeyStoreAndTrustedCAsLoader;
import Xm.JavaUtils.AccessControl.SecurityAgentObserverImpl;
import Xm.JavaUtils.SingletonFileLogger;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreLoader;

public class SSLSocketFactory
extends AbstractSocketFactory
implements SecurityAgentObserverImpl.Observer {
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private org.jacorb.security.ssl.sun_jsse.SSLSocketFactory factory = null;
    private boolean isDirty = true;
    private ORB orb = null;
    private KeyStoreLoader keystoreLoader = null;
    private Configuration configuration = null;

    public SSLSocketFactory(ORB orb) {
        this.orb = orb;
        this.keystoreLoader = new KeyStoreAndTrustedCAsLoader();
        SecurityAgentObserverImpl.instance().addObserver(this);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.factory();
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory().createSocket(host, port);
    }

    public Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        return this.factory().doCreateSocket(host, port, timeout);
    }

    public boolean isSSL(Socket socket) {
        return this.factory().isSSL(socket);
    }

    public void trustedCAsCacheChanged() {
        this.isDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.jacorb.security.ssl.sun_jsse.SSLSocketFactory factory() {
        if (this.isDirty) {
            SSLSocketFactory sSLSocketFactory = this;
            synchronized (sSLSocketFactory) {
                if (this.isDirty) {
                    this.factory = new org.jacorb.security.ssl.sun_jsse.SSLSocketFactory(this.orb, this.keystoreLoader);
                    try {
                        this.factory.configure(this.configuration);
                    }
                    catch (ConfigurationException ex) {
                        this.fileLogger.LogWriteFatalError("SSLSocketFactory", "ConfigurationException: " + ex.getMessage());
                        throw new RuntimeException(ex.getMessage());
                    }
                    this.isDirty = false;
                    this.fileLogger.LogWriteNormal("SSLSocketFactory", "SSLSocketFactory created");
                }
            }
        }
        return this.factory;
    }
}

