/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.AccessControl.KeyStoreAndTrustedCAsLoader;
import Xm.JavaUtils.AccessControl.SecurityAgentObserverImpl;
import Xm.JavaUtils.SingletonFileLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreLoader;

public class SSLServerSocketFactory
implements ServerSocketFactory,
Configurable,
SecurityAgentObserverImpl.Observer {
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private org.jacorb.security.ssl.sun_jsse.SSLServerSocketFactory factory = null;
    private boolean isDirty = true;
    private KeyStoreLoader keystoreLoader = null;
    private Configuration configuration = null;
    private ORB orb = null;

    public SSLServerSocketFactory(ORB orb) {
        this.orb = orb;
        this.keystoreLoader = new KeyStoreAndTrustedCAsLoader();
        SecurityAgentObserverImpl.instance().addObserver(this);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.factory();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.factory().createServerSocket(port);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.factory().createServerSocket(port, backlog);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.factory().createServerSocket(port, backlog, ifAddress);
    }

    public boolean isSSL(ServerSocket socket) {
        return this.factory().isSSL(socket);
    }

    public void trustedCAsCacheChanged() {
        this.isDirty = true;
        this.orb.getBasicAdapter().shouldRenewSSLServerSockets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.jacorb.security.ssl.sun_jsse.SSLServerSocketFactory factory() {
        if (this.isDirty) {
            SSLServerSocketFactory sSLServerSocketFactory = this;
            synchronized (sSLServerSocketFactory) {
                if (this.isDirty) {
                    this.factory = new org.jacorb.security.ssl.sun_jsse.SSLServerSocketFactory(this.keystoreLoader);
                    try {
                        this.factory.configure(this.configuration);
                    }
                    catch (ConfigurationException ex) {
                        this.fileLogger.LogWriteFatalError("SSLServerSocketFactory", "ConfigurationException: " + ex.getMessage());
                        throw new RuntimeException(ex.getMessage());
                    }
                    this.isDirty = false;
                    this.fileLogger.LogWriteNormal("SSLServerSocketFactory", "SSLServerSocketFactory created");
                }
            }
        }
        return this.factory;
    }
}

