/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.AccessControl.TrustedCAs;
import Xm.JavaUtils.SingletonFileLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import org.jacorb.security.ssl.sun_jsse.DefaultKeyStoreLoader;
import org.jacorb.security.ssl.sun_jsse.KeyStoreLoader;

public class KeyStoreAndTrustedCAsLoader
implements KeyStoreLoader {
    public KeyStore getKeyStore(String filename, char[] keystorePassword) throws IOException, GeneralSecurityException {
        KeyStore ks = new DefaultKeyStoreLoader().getKeyStore(filename, keystorePassword);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        byte[][] caCerts = TrustedCAs.GetAllCertificates();
        if (caCerts != null) {
            int i = 0;
            for (byte[] cert : caCerts) {
                String alias = "CA " + ++i;
                ks.setCertificateEntry(alias, cf.generateCertificate(new ByteArrayInputStream(cert)));
            }
            SingletonFileLogger.GetInstance().LogWriteLowLevel("KeyStoreAndTrustedCAsLoader", "Loaded " + i + " additional Trusted CAs");
        } else {
            SingletonFileLogger.GetInstance().LogWriteWarning("KeyStoreAndTrustedCAsLoader", "No Trusted CA Cert");
        }
        return ks;
    }
}

