/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.AccessControl.AccessControlHelper;
import Xm.JavaUtils.AccessControl.AccessController;
import Xm.JavaUtils.AccessControl.DefaultAccessController;
import Xm.JavaUtils.SingletonFileLogger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class AccessInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final long serialVersionUID = -221753174665084574L;
    private Map m_AccessControllers;
    AccessControlHelper m_AccessControlHelper;
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();

    public AccessInterceptor(Map AccessControllers) {
        this.m_AccessControllers = AccessControllers;
        this.m_AccessControlHelper = new AccessControlHelper();
    }

    public void destroy() {
    }

    public String name() {
        return "AccessInterceptor";
    }

    public void receive_request_service_contexts(ServerRequestInfo request_info) throws ForwardRequest {
        this.m_AccessControlHelper.certificateCurrent().push(this.getCertificate(request_info));
    }

    public void receive_request(ServerRequestInfo request_info) throws ForwardRequest {
        this.DoAccessControl(request_info);
    }

    public void send_exception(ServerRequestInfo request_info) throws ForwardRequest {
        this.m_AccessControlHelper.certificateCurrent().pop();
    }

    public void send_other(ServerRequestInfo request_info) throws ForwardRequest {
        this.m_AccessControlHelper.certificateCurrent().pop();
    }

    public void send_reply(ServerRequestInfo request_info) {
        this.m_AccessControlHelper.certificateCurrent().pop();
    }

    private void DoAccessControl(ServerRequestInfo request_info) throws ForwardRequest {
        if (this.IsCorbaObjectCall(request_info)) {
            return;
        }
        X509Certificate certificate = this.m_AccessControlHelper.certificateCurrent().get();
        int decision = this.BestCheckAccess(request_info, certificate);
        String principal = certificate != null ? ((Object)certificate.getSubjectDN()).toString() : "";
        this.m_AccessControlHelper.TakeActionOnDecision(decision, request_info.operation(), principal);
    }

    private int BestCheckAccess(ServerRequestInfo request_info, X509Certificate certificate) {
        String object_type = request_info.target_most_derived_interface();
        return this.FindAccessController(object_type).CheckAccess(request_info, certificate);
    }

    private AccessController FindAccessController(String object_type) {
        AccessController controller = (AccessController)this.m_AccessControllers.get(object_type);
        if (controller != null) {
            return controller;
        }
        return DefaultAccessController.getInstance();
    }

    private boolean IsCorbaObjectCall(ServerRequestInfo request_info) {
        return request_info.operation().equals("_is_a");
    }

    private X509Certificate getCertificate(ServerRequestInfo request_info) {
        ServerRequest request = ((ServerRequestInfoImpl)request_info).request;
        GIOPConnection connection = request.getConnection();
        if (connection != null && connection.isSSL()) {
            ServerIIOPConnection transport = (ServerIIOPConnection)connection.getTransport();
            SSLSocket sslSocket = (SSLSocket)transport.getSocket();
            if (sslSocket == null) {
                this.fileLogger.LogWriteFatalError("AccessInterceptor", "getCertificate... sslSocket is null");
                throw new IMP_LIMIT();
            }
            SSLSession sslSession = sslSocket.getSession();
            if (sslSession == null) {
                this.fileLogger.LogWriteFatalError("AccessInterceptor", "getCertificate... sslSession is null");
                throw new IMP_LIMIT();
            }
            try {
                Certificate[] certificates = sslSession.getPeerCertificates();
                if (certificates == null || certificates.length == 0) {
                    this.fileLogger.LogWriteFatalError("AccessInterceptor", "getCertificate... No certificate in sslSession");
                    throw new IMP_LIMIT();
                }
                return (X509Certificate)certificates[0];
            }
            catch (SSLPeerUnverifiedException ex) {
                this.fileLogger.LogWriteFatalError("AccessInterceptor", "getCertificate...Error: " + ex.getMessage());
                throw new IMP_LIMIT();
            }
        }
        this.fileLogger.LogWriteFatalError("AccessInterceptor", "getCertificate: null");
        return null;
    }
}

