/*
 * Decompiled with CFR 0.152.
 */
package Xm.JavaUtils.AccessControl;

import Xm.JavaUtils.AccessControl.AccessControlHelperI;
import Xm.JavaUtils.AccessControl.ExternalValidator;
import Xm.JavaUtils.JavaRegistry;
import Xm.JavaUtils.SingletonFileLogger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.EmptyStackException;
import java.util.Stack;
import org.omg.CORBA.NO_PERMISSION;

public class AccessControlHelper
implements AccessControlHelperI {
    private SingletonFileLogger fileLogger = SingletonFileLogger.GetInstance();
    private static CertificateCurrent certificateCurrent = new CertificateCurrent();

    public void DelayedAccessControl(String Operation2, String CompanyId2) {
        X509Certificate certificate = certificateCurrent.get();
        String principal = certificate != null ? ((Object)certificate.getSubjectDN()).toString() : "";
        this.TakeActionOnDecision(this.DoDelayedAccessControl(Operation2, certificate, CompanyId2), Operation2, principal);
    }

    private int DoDelayedAccessControl(String Operation2, X509Certificate Certificate2, String CompanyId2) {
        if (Certificate2 == null) {
            return ExternalValidator.getInstance().CheckAccess(Operation2);
        }
        try {
            if (CompanyId2 != null) {
                return ExternalValidator.getInstance().CheckAccess(Operation2, Certificate2.getEncoded(), CompanyId2);
            }
            return ExternalValidator.getInstance().CheckAccess(Operation2, Certificate2.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return ExternalValidator.getInstance().CheckAccess(Operation2);
        }
    }

    void TakeActionOnDecision(int Decision, String Operation2, String PrincipalName) {
        switch (Decision) {
            case 0: {
                break;
            }
            case 1: {
                this.fileLogger.LogWriteNormal("XMJU23-001", "Access denied (Operation: " + Operation2 + ")");
                throw new NO_PERMISSION();
            }
            case 2: {
                boolean enabled;
                String strSubKey = "SOFTWARE\\Interstar Technologies\\XMedius\\Debug\\Security";
                boolean bl = enabled = JavaRegistry.GetRegistryIntDefault(3, strSubKey, "AccessControlEnabled", 1) == 1;
                if (enabled) {
                    this.fileLogger.LogWriteWarning("XMJU23-002", "Access is denied because of insufficient rights. (Operation: " + Operation2 + ", Principal: " + PrincipalName + ")");
                    throw new NO_PERMISSION();
                }
                this.fileLogger.LogWriteWarning("XMJU23-003", "*** ACCESS CONTROL DISABLED *** Access would otherwise be DENIED. (Operation: " + Operation2 + ", Principal: " + PrincipalName + ")");
                break;
            }
            case 3: {
                this.fileLogger.LogWriteNormal("XMJU23-004", "Access is denied, certificate not active (Operation: " + Operation2 + ")");
                throw new NO_PERMISSION();
            }
            default: {
                this.fileLogger.LogWriteWarning("XMJU23-005", "Should not come here, invalid constant used in CheckAccess()");
                throw new NO_PERMISSION();
            }
        }
    }

    public CertificateCurrent certificateCurrent() {
        return certificateCurrent;
    }

    public static class CertificateCurrent {
        private ThreadLocal<Stack<X509Certificate>> certificates = new ThreadLocal();

        public synchronized void push(X509Certificate cert) {
            Stack<X509Certificate> stack = this.certificates.get();
            if (stack == null) {
                stack = new Stack();
                this.certificates.set(stack);
            }
            stack.push(cert);
        }

        public synchronized void pop() {
            Stack<X509Certificate> stack = this.certificates.get();
            if (stack != null) {
                try {
                    stack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
                if (stack.isEmpty()) {
                    this.certificates.remove();
                }
            }
        }

        public synchronized X509Certificate get() {
            Stack<X509Certificate> stack = this.certificates.get();
            if (stack != null) {
                try {
                    return stack.peek();
                }
                catch (EmptyStackException emptyStackException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

