/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax.v1;

import Xm.FaxManager.OutboundFaxSenderPackage.SendInfo;
import Xm.InputStream;
import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.XmlGateway.File;
import Xm.XmlGateway.Sink2;
import Xm.XmlGateway.Sink2Helper;
import com.interstarinc.xmedius.sendfax.FaxException;
import com.interstarinc.xmedius.sendfax.FaxServerNotAvailableException;
import com.interstarinc.xmedius.sendfax.FileInfo;
import com.interstarinc.xmedius.sendfax.model.v1.IFaxModel;
import com.interstarinc.xmedius.sendfax.v1.SendResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;

class SendFax
extends com.interstarinc.xmedius.sendfax.SendFax {
    private SendFax() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final SendResult send(IFaxModel model, java.io.InputStream xmlDoc, String[] references) throws FaxException {
        String[] iors = SendFax.registerIors(references);
        ServiceLocator sl = ServiceLocator.getInstance((String)"/jacorbSendFax.properties", (String)"JavaXmlFaxSender");
        InputStream xmlStream = null;
        File[] files = null;
        SendResult sendResult = null;
        Logger logger = Logger.getLogger("com.interstarinc.xmedius.sendfax");
        int n = iors == null ? 0 : iors.length;
        for (int i = 0; i < n; ++i) {
            FileInfo[] fileInfos = null;
            try {
                xmlStream = SendFax.createInputStream(xmlDoc, "xml");
                fileInfos = SendFax.toFileInfoArray(model);
                files = new File[fileInfos.length];
                for (int j = 0; j < files.length; ++j) {
                    files[j] = SendFax.createFile(fileInfos[j]);
                }
                Sink2 xmlSink = Sink2Helper.narrow(sl.getCorbaInit().getOrb().string_to_object(iors[i]));
                SendInfo result = xmlSink.SubmitXmlFax(xmlStream, files);
                ArrayList<String> transactionIds = new ArrayList<String>();
                for (String s : result.FaxIds) {
                    transactionIds.add(s);
                }
                sendResult = new SendResult();
                sendResult.setTransactionIds(transactionIds);
                sendResult.setBroadcastId(result.BroadcastId);
            }
            catch (SystemException e) {
                SendFax.setErrorIor(iors[i]);
                logger.logp(Level.WARNING, SendFax.class.getName(), "send(...)", "Unable to communicate with XML gateway. Exception is {0}", e.toString());
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        SendFax.closeStreams(files, xmlDoc, xmlStream);
                        throw throwable;
                    }
                }
                SendFax.closeStreams(files, xmlDoc, xmlStream);
                continue;
                catch (UserException e2) {
                    throw new FaxServerNotAvailableException(e2);
                    catch (IOException e3) {
                        throw new FaxServerNotAvailableException(e3);
                    }
                    catch (ServiceUnavailableX e4) {
                        throw new FaxServerNotAvailableException(e4);
                    }
                }
            }
            SendFax.closeStreams(files, xmlDoc, xmlStream);
            break;
        }
        if (sendResult == null) {
            throw new FaxServerNotAvailableException("Unable to communicate with XML Gateway(s)");
        }
        return sendResult;
    }
}

