/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax.test;

import com.interstarinc.xmedius.sendfax.CoverSheetIntegrityException;
import com.interstarinc.xmedius.sendfax.EmptyFaxException;
import com.interstarinc.xmedius.sendfax.Fax;
import com.interstarinc.xmedius.sendfax.FaxException;
import com.interstarinc.xmedius.sendfax.FaxOptionsException;
import com.interstarinc.xmedius.sendfax.InvalidFaxNumberException;
import com.interstarinc.xmedius.sendfax.InvalidProcessingOptionsException;
import com.interstarinc.xmedius.sendfax.NoRecipientException;
import com.interstarinc.xmedius.sendfax.XMLBuilder;
import com.interstarinc.xmedius.sendfax.model.BooleanValue;
import com.interstarinc.xmedius.sendfax.model.CoverSheetType;
import com.interstarinc.xmedius.sendfax.model.DefaultFaxModel;
import com.interstarinc.xmedius.sendfax.model.FaxPriority;
import com.interstarinc.xmedius.sendfax.model.FaxResolution;
import com.interstarinc.xmedius.sendfax.model.Gateway;
import com.interstarinc.xmedius.sendfax.model.IRecipientInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestXMLBuilder
extends TestCase {
    private DefaultFaxModel faxModel = null;
    private File outputDir = null;

    public TestXMLBuilder(String method) {
        super(method);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/GatewayMetaDoc.xml");
            File f = new File(url.toURI());
            this.outputDir = f.getParentFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.faxModel = new DefaultFaxModel();
        this.faxModel.setSubject("Test XML Builder");
        this.faxModel.setComment("A long comment with many lines\n...\n...\n...\nEnd Comment");
        this.faxModel.setPassword("1217aa61");
        this.faxModel.setUserId("bob@acme.com");
        this.faxModel.setInputFileDeleted(BooleanValue.NO);
        this.faxModel.setCoverSheetType(CoverSheetType.SERVER);
        this.faxModel.setCoverSheet(new File("Basic"));
        this.faxModel.addRecipientInfo("Bob", "Acme", "514-000-9999");
        this.faxModel.addRecipientInfo("Bob2", "Acme2", "514-000-9992");
        this.faxModel.newSenderInfo();
        this.faxModel.getSenderInfo().setBillingCode("a1");
        this.faxModel.getSenderInfo().setCellPhoneNumber("514-000-9912");
        this.faxModel.getSenderInfo().setEmail("info@acme2.com");
        this.faxModel.getSenderInfo().setFirstName("Joe");
        this.faxModel.getSenderInfo().setLastName("Young");
        this.faxModel.getSenderInfo().setPagerPhoneNumber("000-000-0012");
        this.faxModel.getSenderInfo().setSubBillingCode("b1");
        this.faxModel.getSenderInfo().setTitle("President");
        this.faxModel.getSenderInfo().newCompany();
        this.faxModel.getSenderInfo().getCompany().setFaxNumber("514-009-232a");
        this.faxModel.getSenderInfo().getCompany().setName("Acme 4");
        this.faxModel.getSenderInfo().getCompany().setPhoneNumber("222-0908-09821");
        this.faxModel.getSenderInfo().getCompany().newAddress();
        this.faxModel.getSenderInfo().getCompany().getAddress().setCity("Montreal");
        this.faxModel.getSenderInfo().getCompany().getAddress().setCountry("Canada");
        this.faxModel.getSenderInfo().getCompany().getAddress().setState("Quebec");
        this.faxModel.getSenderInfo().getCompany().getAddress().setStreet("1001 Ste-Catherine Ouest.");
        this.faxModel.getSenderInfo().getCompany().getAddress().setZipCode("H1B 2G6");
        this.faxModel.newFaxOptions();
        this.faxModel.getFaxOptions().setFailureNotified(BooleanValue.YES);
        this.faxModel.getFaxOptions().setSuccessNotified(BooleanValue.YES);
        this.faxModel.getFaxOptions().setFaxPriority(FaxPriority.NORMAL);
        this.faxModel.getFaxOptions().setFaxResolution(FaxResolution.ULTRA_FINE);
        this.faxModel.getFaxOptions().setNotificationAddress(this.faxModel.getUserId());
        this.faxModel.getFaxOptions().setNotificationGateway(Gateway.SMTP);
        this.faxModel.getFaxOptions().setNumberOfRetries(new Integer(3));
        this.faxModel.getAttachmentList().add(new File("C:\\Program Files\\Tomcat\\jakarta-tomcat-5.0.27\\work\\Catalina\\localhost\\webfaxcompose\\uploads\\upload_00010234.htm"));
        this.faxModel.getAttachmentList().add(new File("C:\\Program Files\\Tomcat\\jakarta-tomcat-5.0.27\\work\\Catalina\\localhost\\webfaxcompose\\uploads\\upload_00010345.gif"));
        this.faxModel.getAttachmentList().add(new File("C:\\Program Files\\Tomcat\\jakarta-tomcat-5.0.27\\work\\Catalina\\localhost\\webfaxcompose\\uploads\\upload_00012311.doc"));
    }

    public void testCreateXMLGatewayFile() {
        try {
            Fax aFax = new Fax();
            aFax.toXML(this.faxModel, (OutputStream)new FileOutputStream(new File(this.outputDir, "GatewayDoc.xml")));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testFaxValidation() {
        CoverSheetIntegrityException ex;
        ArrayList<IRecipientInfo> recipients = new ArrayList<IRecipientInfo>(this.faxModel.getRecipientList());
        this.faxModel.getRecipientList().clear();
        Fax aFax = new Fax();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.outputDir, "GatewayDoc.xml"));
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NoRecipientException));
        }
        this.faxModel.addRecipientInfo("Bob", "acme", "");
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidFaxNumberException));
        }
        this.faxModel.removeRecipientInfo("Bob", "");
        this.faxModel.getRecipientList().addAll(recipients);
        String comment = this.faxModel.getComment();
        this.faxModel.setComment(null);
        ArrayList<File> attachments = new ArrayList<File>(this.faxModel.getAttachmentList());
        this.faxModel.getAttachmentList().clear();
        CoverSheetType cst = this.faxModel.getCoverSheetType();
        this.faxModel.setCoverSheetType(CoverSheetType.NONE);
        File cs = this.faxModel.getCoverSheet();
        this.faxModel.setCoverSheet(null);
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof EmptyFaxException));
        }
        this.faxModel.setComment("");
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof EmptyFaxException));
        }
        this.faxModel.setComment(comment);
        this.faxModel.getAttachmentList().addAll(attachments);
        this.faxModel.setCoverSheetType(cst);
        this.faxModel.setCoverSheet(cs);
        File coverSheet = this.faxModel.getCoverSheet();
        cst = this.faxModel.getCoverSheetType();
        this.faxModel.setCoverSheetType(null);
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FaxException));
        }
        this.faxModel.setCoverSheetType(CoverSheetType.DEFAULT);
        this.faxModel.setCoverSheet(new File("abcde"));
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof CoverSheetIntegrityException));
            ex = (CoverSheetIntegrityException)e;
            Assert.assertTrue((boolean)ex.isCoverSheetMustBeNull());
        }
        this.faxModel.setCoverSheetType(CoverSheetType.NONE);
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof CoverSheetIntegrityException));
            ex = (CoverSheetIntegrityException)e;
            Assert.assertTrue((boolean)ex.isCoverSheetMustBeNull());
        }
        this.faxModel.setCoverSheetType(CoverSheetType.LOCAL);
        this.faxModel.setCoverSheet(null);
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof CoverSheetIntegrityException));
            ex = (CoverSheetIntegrityException)e;
            Assert.assertFalse((boolean)ex.isCoverSheetMustBeNull());
        }
        this.faxModel.setCoverSheet(coverSheet);
        this.faxModel.setCoverSheetType(cst);
        String userId = this.faxModel.getUserId();
        this.faxModel.setUserId(null);
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidProcessingOptionsException));
        }
        this.faxModel.setUserId(userId);
        DefaultFaxModel.DefaultFaxOptions faxOptions = this.faxModel.getFaxOptions();
        this.faxModel.clearFaxOptions();
        try {
            aFax.toXML(this.faxModel, (OutputStream)fos);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FaxOptionsException));
        }
        this.faxModel.newFaxOptions(faxOptions);
    }

    public void testCreateXMLGatewayFileNS() {
        this.createXMLGatewayFile("/GatewayMetaDocNS.xml", "GatewayDocNS.xml");
    }

    public void testCreateXMLGatewayFileNS1() {
        this.createXMLGatewayFile("/GatewayMetaDocNS1.xml", "GatewayDocNS1.xml");
    }

    public void testSenderInfo() {
        this.faxModel.getSenderInfo().getCompany().clearAddress();
        this.createXMLGatewayFile("/GatewayMetaDoc.xml", "sendInfo1.xml");
        this.faxModel.getSenderInfo().clearCompany();
        this.createXMLGatewayFile("/GatewayMetaDoc.xml", "sendInfo2.xml");
    }

    private void createXMLGatewayFile(String metaDocName, String anXmlFaxModel) {
        try {
            InputStream metaDoc = ((Object)((Object)this)).getClass().getResourceAsStream(metaDocName);
            XMLBuilder builder = new XMLBuilder();
            builder.setNameSpaceAware(true);
            Document doc = builder.createDocument(this.faxModel, metaDoc);
            Properties props = new Properties();
            props.setProperty("method", "xml");
            props.setProperty("encoding", "utf-8");
            props.setProperty("indent", "yes");
            FileOutputStream faxXmlFile = new FileOutputStream(new File(this.outputDir, anXmlFaxModel));
            builder.saveDocument(doc, faxXmlFile, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

