/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax.test;

import com.interstarinc.xmedius.sendfax.Fax;
import com.interstarinc.xmedius.sendfax.model.BooleanValue;
import com.interstarinc.xmedius.sendfax.model.CoverSheetType;
import com.interstarinc.xmedius.sendfax.model.DefaultFaxModel;
import com.interstarinc.xmedius.sendfax.model.FaxPriority;
import com.interstarinc.xmedius.sendfax.model.FaxResolution;
import com.interstarinc.xmedius.sendfax.model.Gateway;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import junit.framework.TestCase;

public class TestFaxSubmission
extends TestCase {
    private DefaultFaxModel faxModel = null;
    private File outputDir = null;

    public TestFaxSubmission(String method) {
        super(method);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/GatewayMetaDoc.xml");
            File f = new File(url.toURI());
            this.outputDir = f.getParentFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.faxModel = new DefaultFaxModel();
        this.faxModel.setSubject("Test XML Builder");
        this.faxModel.setComment("A long comment with many lines\n...\n...\n...\nEnd Comment");
        this.faxModel.setUserId("amorin@interstarinc.com");
        this.faxModel.setInputFileDeleted(BooleanValue.NO);
        this.faxModel.setCoverSheetType(CoverSheetType.DEFAULT);
        this.faxModel.addRecipientInfo("Bob", "Acme", "514-000-9999");
        this.faxModel.addRecipientInfo("Bob2", "Acme2", "514-000-9992");
        this.faxModel.newSenderInfo();
        DefaultFaxModel.DefaultSenderInfo senderInfo = this.faxModel.getSenderInfo();
        senderInfo.setBillingCode("a1");
        senderInfo.setCellPhoneNumber("514-000-9912");
        senderInfo.setEmail("info@acme2.com");
        senderInfo.setFirstName("Joe");
        senderInfo.setLastName("Young");
        senderInfo.setPagerPhoneNumber("000-000-0012");
        senderInfo.setSubBillingCode("b1");
        senderInfo.setTitle("President");
        senderInfo.newCompany();
        DefaultFaxModel.DefaultCompanyInfo companyInfo = senderInfo.getCompany();
        companyInfo.setFaxNumber("514-009-232a");
        companyInfo.setName("Acme 4");
        companyInfo.setPhoneNumber("222-0908-09821");
        companyInfo.newAddress();
        DefaultFaxModel.DefaultAddress address = companyInfo.getAddress();
        address.setCity("Montreal");
        address.setCountry("Canada");
        address.setState("Quebec");
        address.setStreet("1001 Ste-Catherine Ouest.");
        address.setZipCode("H1B 2G6");
        this.faxModel.newFaxOptions();
        this.faxModel.getFaxOptions().setFailureNotified(BooleanValue.YES);
        this.faxModel.getFaxOptions().setSuccessNotified(BooleanValue.YES);
        this.faxModel.getFaxOptions().setFaxPriority(FaxPriority.NORMAL);
        this.faxModel.getFaxOptions().setFaxResolution(FaxResolution.ULTRA_FINE);
        this.faxModel.getFaxOptions().setNotificationAddress(this.faxModel.getUserId());
        this.faxModel.getFaxOptions().setNotificationGateway(Gateway.SMTP);
        this.faxModel.getFaxOptions().setNumberOfRetries(new Integer(3));
    }

    public void testSendFaxWithoutAuthentication() {
        try {
            Fax aFax = new Fax();
            File gatewayDoc = new File(this.outputDir, "GatewayDoc1.xml");
            aFax.toXML(this.faxModel, (OutputStream)new FileOutputStream(gatewayDoc));
            aFax.send(this.faxModel, gatewayDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testSendFaxWithAuthentication() {
        try {
            Fax aFax = new Fax();
            File gatewayDoc = new File(this.outputDir, "GatewayDoc2.xml");
            this.faxModel.setPassword("girafe");
            aFax.toXML(this.faxModel, (OutputStream)new FileOutputStream(gatewayDoc));
            aFax.send(this.faxModel, gatewayDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

