/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax.model.v1;

import com.interstarinc.xmedius.sendfax.model.BooleanValue;
import com.interstarinc.xmedius.sendfax.model.CoverSheetType;
import com.interstarinc.xmedius.sendfax.model.DateType;
import com.interstarinc.xmedius.sendfax.model.FaxPriority;
import com.interstarinc.xmedius.sendfax.model.FaxResolution;
import com.interstarinc.xmedius.sendfax.model.Gateway;
import com.interstarinc.xmedius.sendfax.model.IAddress;
import com.interstarinc.xmedius.sendfax.model.ICompanyInfo;
import com.interstarinc.xmedius.sendfax.model.ISenderInfo;
import com.interstarinc.xmedius.sendfax.model.v1.IAttachmentInfo;
import com.interstarinc.xmedius.sendfax.model.v1.IFaxModel;
import com.interstarinc.xmedius.sendfax.model.v1.IFaxOptions;
import com.interstarinc.xmedius.sendfax.model.v1.IRecipientInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaxModel
implements IFaxModel {
    private List<IAttachmentInfo> attachmentList = new ArrayList<IAttachmentInfo>();
    private String comment = null;
    private IAttachmentInfo coverSheet = null;
    private CoverSheetType coverSheetType = null;
    private String userId = null;
    private String password = null;
    private List<IRecipientInfo> recipientList = new ArrayList<IRecipientInfo>();
    private String subject = null;
    private BooleanValue inputFileDeleted = BooleanValue.YES;
    private DefaultSenderInfo senderInfo = null;
    private DefaultFaxOptions faxOptions = null;

    @Override
    public List<IAttachmentInfo> getAttachmentList() {
        return this.attachmentList;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public IAttachmentInfo getCoverSheet() {
        return this.coverSheet;
    }

    @Override
    public CoverSheetType getCoverSheetType() {
        return this.coverSheetType;
    }

    public void newFaxOptions() {
        this.faxOptions = new DefaultFaxOptions();
    }

    public void newFaxOptions(IFaxOptions fo) {
        this.faxOptions = new DefaultFaxOptions(fo);
    }

    public void clearFaxOptions() {
        this.faxOptions = null;
    }

    @Override
    public DefaultFaxOptions getFaxOptions() {
        return this.faxOptions;
    }

    @Override
    public BooleanValue getInputFileDeleted() {
        return this.inputFileDeleted;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public List<IRecipientInfo> getRecipientList() {
        ArrayList<IRecipientInfo> ri = new ArrayList<IRecipientInfo>();
        ri.addAll(this.recipientList);
        return ri;
    }

    public void addRecipientInfo(String name, String company, String faxNumber) {
        DefaultRecipientInfo ri = new DefaultRecipientInfo(name, company, faxNumber);
        this.recipientList.add(ri);
    }

    public void addRecipientInfo(String name, String company, String faxNumber, String billingCode, String subBillingCode) {
        DefaultRecipientInfo ri = new DefaultRecipientInfo(name, company, faxNumber);
        ri.setBillingCode(billingCode);
        ri.setSubBillingCode(subBillingCode);
        this.recipientList.add(ri);
    }

    public void addRecipientInfo(IRecipientInfo ri) {
        this.recipientList.add(new DefaultRecipientInfo(ri));
    }

    public void removeRecipientInfo(String name, String faxNumber) {
        DefaultRecipientInfo ri = new DefaultRecipientInfo(name, "", faxNumber);
        this.recipientList.remove(ri);
    }

    public void removeRecipientInfo(IRecipientInfo ri) {
        this.removeRecipientInfo(ri.getName(), ri.getFaxNumber());
    }

    public void newSenderInfo() {
        this.senderInfo = new DefaultSenderInfo();
    }

    public void newSenderInfo(ISenderInfo si) {
        this.senderInfo = new DefaultSenderInfo(si);
    }

    public void clearSenderInfo() {
        this.senderInfo = null;
    }

    @Override
    public DefaultSenderInfo getSenderInfo() {
        return this.senderInfo;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCoverSheet(IAttachmentInfo coverSheet) {
        this.coverSheet = coverSheet;
    }

    public void setCoverSheetType(CoverSheetType coverSheetType) {
        this.coverSheetType = coverSheetType;
    }

    public void setInputFileDeleted(BooleanValue inputFileDeleted) {
        this.inputFileDeleted = inputFileDeleted;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public class DefaultAddress
    implements IAddress {
        private String city = null;
        private String street = null;
        private String state = null;
        private String zipCode = null;
        private String country = null;

        private DefaultAddress() {
        }

        private DefaultAddress(IAddress address) {
            if (address != null) {
                this.street = address.getStreet();
                this.city = address.getCity();
                this.state = address.getState();
                this.zipCode = address.getZipCode();
                this.country = address.getCountry();
            }
        }

        public String getCity() {
            return this.city;
        }

        public String getCountry() {
            return this.country;
        }

        public String getState() {
            return this.state;
        }

        public String getStreet() {
            return this.street;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }
    }

    public class DefaultCompanyInfo
    implements ICompanyInfo {
        private DefaultAddress address = null;
        private String faxNumber = null;
        private String name = null;
        private String phoneNumber = null;

        private DefaultCompanyInfo() {
        }

        private DefaultCompanyInfo(ICompanyInfo companyInfo) {
            if (companyInfo != null) {
                this.address = new DefaultAddress(companyInfo.getAddress());
                this.faxNumber = companyInfo.getFaxNumber();
                this.name = companyInfo.getName();
                this.phoneNumber = companyInfo.getPhoneNumber();
            }
        }

        public String getFaxNumber() {
            return this.faxNumber;
        }

        public void setFaxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public DefaultAddress getAddress() {
            return this.address;
        }

        public void clearAddress() {
            this.address = null;
        }

        public void newAddress() {
            this.address = new DefaultAddress();
        }
    }

    public class DefaultSenderInfo
    implements ISenderInfo {
        private String billingCode = null;
        private String subBillingCode = null;
        private String cellPhoneNumber = null;
        private DefaultCompanyInfo company = null;
        private String email = null;
        private String firstName = null;
        private String lastName = null;
        private String pagerPhoneNumber = null;
        private String title = null;

        private DefaultSenderInfo() {
        }

        private DefaultSenderInfo(ISenderInfo senderInfo) {
            if (senderInfo != null) {
                this.billingCode = senderInfo.getBillingCode();
                this.subBillingCode = senderInfo.getSubBillingCode();
                this.cellPhoneNumber = senderInfo.getCellPhoneNumber();
                this.company = new DefaultCompanyInfo(senderInfo.getCompany());
                this.email = senderInfo.getEmail();
                this.firstName = senderInfo.getFirstName();
                this.lastName = senderInfo.getLastName();
                this.pagerPhoneNumber = senderInfo.getPagerPhoneNumber();
                this.title = senderInfo.getTitle();
            }
        }

        public String getBillingCode() {
            return this.billingCode;
        }

        public void setBillingCode(String billingCode) {
            this.billingCode = billingCode;
        }

        public String getCellPhoneNumber() {
            return this.cellPhoneNumber;
        }

        public void setCellPhoneNumber(String cellPhoneNumber) {
            this.cellPhoneNumber = cellPhoneNumber;
        }

        public DefaultCompanyInfo getCompany() {
            return this.company;
        }

        public void clearCompany() {
            this.company = null;
        }

        public void newCompany() {
            this.company = new DefaultCompanyInfo();
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getPagerPhoneNumber() {
            return this.pagerPhoneNumber;
        }

        public void setPagerPhoneNumber(String pagerPhoneNumber) {
            this.pagerPhoneNumber = pagerPhoneNumber;
        }

        public String getSubBillingCode() {
            return this.subBillingCode;
        }

        public void setSubBillingCode(String subBillingCode) {
            this.subBillingCode = subBillingCode;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    private class DefaultRecipientInfo
    implements IRecipientInfo {
        private String faxNumber = null;
        private String company = null;
        private String name = null;
        private String title = null;
        private String billingCode = null;
        private String subBillingCode = null;
        private String phone = null;
        private String pager = null;
        private String cellular = null;
        private String email = null;
        private DefaultAddress address = null;
        private String userDefined1 = null;
        private String userDefined2 = null;
        private String userDefined3 = null;
        private String userDefined4 = null;

        private DefaultRecipientInfo(IRecipientInfo ri) {
            if (ri != null) {
                this.faxNumber = ri.getFaxNumber();
                this.company = ri.getCompany();
                this.name = ri.getName();
                this.title = ri.getTitle();
                this.billingCode = ri.getBillingCode();
                this.subBillingCode = ri.getSubBillingCode();
                this.phone = ri.getPhone();
                this.pager = ri.getPager();
                this.cellular = ri.getCellular();
                this.email = ri.getEmail();
                this.address = new DefaultAddress(ri.getAddress());
                this.userDefined1 = ri.getUserDefined1();
                this.userDefined2 = ri.getUserDefined2();
                this.userDefined3 = ri.getUserDefined3();
                this.userDefined4 = ri.getUserDefined4();
            }
        }

        private DefaultRecipientInfo(String name, String company, String faxNumber) {
            this.faxNumber = faxNumber;
            this.company = company;
            this.name = name;
        }

        public String getCompany() {
            return this.company;
        }

        public void setCompany(String company) {
            this.company = company;
        }

        public String getFaxNumber() {
            return this.faxNumber;
        }

        public void setFaxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBillingCode(String code) {
            this.billingCode = code;
        }

        public String getBillingCode() {
            return this.billingCode;
        }

        public String getSubBillingCode() {
            return this.subBillingCode;
        }

        public void setSubBillingCode(String subBillingCode) {
            this.subBillingCode = subBillingCode;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getPager() {
            return this.pager;
        }

        public void setPager(String pager) {
            this.pager = pager;
        }

        public String getCellular() {
            return this.cellular;
        }

        public void setCellular(String cellular) {
            this.cellular = cellular;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public DefaultAddress getAddress() {
            return this.address;
        }

        public void clearAddress() {
            this.address = null;
        }

        public void newAddress() {
            this.address = new DefaultAddress();
        }

        public String getUserDefined1() {
            return this.userDefined1;
        }

        public void setUserDefined1(String userDefined1) {
            this.userDefined1 = userDefined1;
        }

        public String getUserDefined2() {
            return this.userDefined2;
        }

        public void setUserDefined2(String userDefined2) {
            this.userDefined2 = userDefined2;
        }

        public String getUserDefined3() {
            return this.userDefined3;
        }

        public void setUserDefined3(String userDefined3) {
            this.userDefined3 = userDefined3;
        }

        public String getUserDefined4() {
            return this.userDefined4;
        }

        public void setUserDefined4(String userDefined4) {
            this.userDefined4 = userDefined4;
        }

        public boolean equals(Object o) {
            if (o instanceof IRecipientInfo) {
                IRecipientInfo ri = (IRecipientInfo)o;
                return ri.getFaxNumber() != null && this.getFaxNumber() != null && ri.getFaxNumber().equals(this.getFaxNumber()) && ri.getName() != null && this.getName() != null && ri.getName().equals(this.getName());
            }
            return false;
        }

        public int hashCode() {
            return (this.getFaxNumber() + "" + this.getName() + "").hashCode();
        }
    }

    public class DefaultFaxOptions
    implements IFaxOptions {
        private FaxPriority faxPriority = null;
        private FaxResolution faxResolution = null;
        private String notificationAddress = null;
        private Gateway notificationGateway = null;
        private Integer numberOfRetries = null;
        private BooleanValue failureNotified = null;
        private BooleanValue successNotified = null;
        private BooleanValue broadcastNotification = null;
        private DateType delayUntil = null;

        private DefaultFaxOptions() {
        }

        private DefaultFaxOptions(IFaxOptions faxOptions) {
            if (faxOptions != null) {
                this.failureNotified = faxOptions.getFailureNotified();
                this.faxPriority = faxOptions.getFaxPriority();
                this.faxResolution = faxOptions.getFaxResolution();
                this.notificationAddress = faxOptions.getNotificationAddress();
                this.notificationGateway = faxOptions.getNotificationGateway();
                this.numberOfRetries = faxOptions.getNumberOfRetries();
                this.successNotified = faxOptions.getSuccessNotified();
                this.broadcastNotification = faxOptions.getBroadcastNotification();
                this.delayUntil = faxOptions.getDelayUntil();
            }
        }

        public BooleanValue getFailureNotified() {
            return this.failureNotified;
        }

        public void setFailureNotified(BooleanValue failureNotified) {
            this.failureNotified = failureNotified;
        }

        public FaxPriority getFaxPriority() {
            return this.faxPriority;
        }

        public void setFaxPriority(FaxPriority faxPriority) {
            this.faxPriority = faxPriority;
        }

        public FaxResolution getFaxResolution() {
            return this.faxResolution;
        }

        public void setFaxResolution(FaxResolution faxResolution) {
            this.faxResolution = faxResolution;
        }

        public String getNotificationAddress() {
            return this.notificationAddress;
        }

        public void setNotificationAddress(String notificationAddress) {
            this.notificationAddress = notificationAddress;
        }

        public Gateway getNotificationGateway() {
            return this.notificationGateway;
        }

        public void setNotificationGateway(Gateway notificationGateway) {
            this.notificationGateway = notificationGateway;
        }

        public Integer getNumberOfRetries() {
            return this.numberOfRetries;
        }

        public void setNumberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
        }

        public BooleanValue getSuccessNotified() {
            return this.successNotified;
        }

        public void setSuccessNotified(BooleanValue successNotified) {
            this.successNotified = successNotified;
        }

        public BooleanValue getBroadcastNotification() {
            return this.broadcastNotification;
        }

        public void setBroadcastNotification(BooleanValue broadcastNotification) {
            this.broadcastNotification = broadcastNotification;
        }

        public void setDelayUntil(DateType delayUntil) {
            this.delayUntil = delayUntil;
        }

        public DateType getDelayUntil() {
            return this.delayUntil;
        }
    }
}

