/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax;

import com.interstarinc.xmedius.sendfax.XMLBuilderException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBuilder {
    private boolean nameSpaceAware = false;

    public boolean isNameSpaceAware() {
        return this.nameSpaceAware;
    }

    public void setNameSpaceAware(boolean nameSpaceAware) {
        this.nameSpaceAware = nameSpaceAware;
    }

    public Document createDocument(Object aModel, InputStream aMetaDoc) throws XMLBuilderException {
        return this.createDocument(aModel, aMetaDoc, null);
    }

    public Document createDocument(Object aModel, InputStream aMetaDoc, Properties parserProperties) throws XMLBuilderException {
        MetaDocHandler handler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(this.isNameSpaceAware());
            if (this.isNameSpaceAware()) {
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            factory.setValidating(false);
            handler = new MetaDocHandler(aModel);
            SAXParser parser = factory.newSAXParser();
            if (parserProperties != null) {
                Iterator<Map.Entry<Object, Object>> it = parserProperties.entrySet().iterator();
                Map.Entry<Object, Object> me = null;
                while (it.hasNext()) {
                    me = it.next();
                    parser.setProperty((String)me.getKey(), me.getValue());
                }
            }
            parser.parse(aMetaDoc, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new XMLBuilderException(e);
        }
        catch (FactoryConfigurationError er) {
            throw new XMLBuilderException(er.getException());
        }
        return handler.getXmlDoc();
    }

    public void saveDocument(Document aDocument, OutputStream target) throws XMLBuilderException {
        this.saveDocument(aDocument, target, null);
    }

    public void saveDocument(Document aDocument, OutputStream target, Properties outputProperties) throws XMLBuilderException {
        try {
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer transformer = xformFactory.newTransformer();
            if (outputProperties != null) {
                transformer.setOutputProperties(outputProperties);
            }
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
            DOMSource input = new DOMSource(aDocument);
            StreamResult output = new StreamResult(target);
            transformer.transform(input, output);
            target.flush();
            target.close();
        }
        catch (Exception e) {
            throw new XMLBuilderException(e);
        }
        catch (TransformerFactoryConfigurationError err) {
            throw new XMLBuilderException(err.getException());
        }
    }

    public class MetaDocHandler
    extends DefaultHandler {
        public static final String XMB_NAME_SPACE = "http://xml.utility/XMLBuilder";
        private DOMImplementation impl = null;
        private Document xmlDoc = null;
        private Node parent = null;
        private String skippedElement = null;
        private Object model = null;
        private List metaAttList = null;
        private boolean nameSpaceAware = false;

        public MetaDocHandler(Object model) {
            this.model = model;
        }

        public Document getXmlDoc() {
            return this.xmlDoc;
        }

        public void startDocument() throws SAXException {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.impl = builder.getDOMImplementation();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            catch (FactoryConfigurationError err) {
                throw new SAXException(err.getException());
            }
        }

        public void startElement(String nameSpaceUri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.skippedElement != null) {
                return;
            }
            String eName = localName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this.xmlDoc == null) {
                this.nameSpaceAware = !"".equals(nameSpaceUri);
                this.xmlDoc = this.impl.createDocument(this.nameSpaceAware ? nameSpaceUri : null, qName, null);
                this.parent = this.xmlDoc.getDocumentElement();
                this.addAttributes((Element)this.parent, atts);
            } else {
                String skip = this.getAttributeValue(atts, "skip");
                if (skip == null) {
                    skip = "false";
                }
                if (skip.equals("true") && atts.getLength() == 1) {
                    this.skippedElement = qName;
                    return;
                }
                String defaultValue = this.getAttributeValue(atts, "default");
                Object aModelPropValue = null;
                String index = this.getAttributeValue(atts, "index");
                String propName = null;
                propName = index != null ? MessageFormat.format(this.getAttributeValue(atts, "property"), index) : this.getAttributeValue(atts, "property");
                if (propName != null) {
                    block11: {
                        try {
                            aModelPropValue = PropertyUtils.getProperty((Object)this.model, (String)propName);
                        }
                        catch (Exception e) {
                            if (defaultValue != null || !skip.equals("false")) break block11;
                            throw new SAXException(e);
                        }
                    }
                    if (aModelPropValue instanceof List && ((List)aModelPropValue).isEmpty()) {
                        aModelPropValue = null;
                    }
                    if (aModelPropValue == null && defaultValue == null) {
                        this.skippedElement = qName;
                        return;
                    }
                }
                Element elem = null;
                elem = "".equals(nameSpaceUri) ? this.xmlDoc.createElement(qName) : this.xmlDoc.createElementNS(nameSpaceUri, qName);
                this.addAttributes(elem, atts);
                this.parent.appendChild(elem);
                this.parent = elem;
            }
        }

        private String getAttributeValue(Attributes atts, String attName) {
            String s = atts.getValue(XMB_NAME_SPACE, attName);
            if (s == null || "".equals(s)) {
                s = atts.getValue(attName);
            }
            return s;
        }

        private String getAttributeValue(Element elem, String attName) {
            String s = elem.getAttributeNS(XMB_NAME_SPACE, attName);
            if ("".equals(s)) {
                s = elem.getAttribute(attName);
            }
            return s;
        }

        public void endElement(String nameSpaceUri, String localName, String qName) throws SAXException {
            String eName = localName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this.skippedElement != null) {
                if (this.skippedElement.equals(eName)) {
                    this.skippedElement = null;
                }
                return;
            }
            Object aModelPropValue = null;
            Element element = (Element)this.parent;
            String index = this.getAttributeValue(element, "index");
            String defaultValue = this.getAttributeValue(element, "default");
            String propName = null;
            propName = index.length() > 0 ? MessageFormat.format(this.getAttributeValue(element, "property"), index) : this.getAttributeValue(element, "property");
            if (propName.length() > 0) {
                block12: {
                    try {
                        aModelPropValue = PropertyUtils.getProperty((Object)this.model, (String)propName);
                    }
                    catch (Exception e) {
                        if (defaultValue != null) break block12;
                        throw new SAXException(e);
                    }
                }
                if (aModelPropValue instanceof List) {
                    List l = (List)aModelPropValue;
                    for (int i = 1; i < l.size(); ++i) {
                        this.addNodes(this.parent.getFirstChild(), String.valueOf(i));
                    }
                }
            }
            if (aModelPropValue != null) {
                String hasChildTextNode = this.getAttributeValue(element, "childIsText");
                if (hasChildTextNode.equals("true")) {
                    this.parent.appendChild(this.xmlDoc.createTextNode(aModelPropValue.toString()));
                }
            } else if (defaultValue.length() > 0) {
                this.parent.appendChild(this.xmlDoc.createTextNode(defaultValue));
            }
            this.parent = this.parent.getParentNode();
        }

        private void addNodes(Node aListItem, String currentIndex) throws SAXException {
            Attributes attList = this.createAttributes(aListItem.getAttributes(), currentIndex);
            if (aListItem.getNamespaceURI() != null) {
                this.startElement(aListItem.getNamespaceURI(), aListItem.getLocalName(), aListItem.getNodeName(), attList);
            } else {
                this.startElement("", "", aListItem.getNodeName(), attList);
            }
            NodeList l = aListItem.getChildNodes();
            Node n = null;
            for (int i = 0; i < l.getLength(); ++i) {
                n = l.item(i);
                if (!(n instanceof Element)) continue;
                this.addNodes(n, currentIndex);
            }
            if (aListItem.getNamespaceURI() != null) {
                this.endElement(aListItem.getNamespaceURI(), aListItem.getLocalName(), aListItem.getNodeName());
            } else {
                this.endElement("", "", aListItem.getNodeName());
            }
        }

        private Attributes createAttributes(NamedNodeMap map, String currentIndex) {
            AttributesImpl attList = new AttributesImpl();
            Attr n = null;
            for (int i = 0; i < map.getLength(); ++i) {
                n = (Attr)map.item(i);
                if (n.getNamespaceURI() != null && n.getNamespaceURI().equals(XMB_NAME_SPACE)) {
                    if (n.getLocalName().equals("index")) {
                        attList.addAttribute(n.getNamespaceURI(), n.getLocalName(), n.getNodeName(), "CDATA", currentIndex);
                        continue;
                    }
                    attList.addAttribute(n.getNamespaceURI(), n.getLocalName(), n.getNodeName(), "CDATA", n.getNodeValue());
                    continue;
                }
                if (n.getName().equals("index")) {
                    attList.addAttribute("", "", n.getNodeName(), "CDATA", currentIndex);
                    continue;
                }
                attList.addAttribute("", "", n.getNodeName(), "CDATA", n.getNodeValue());
            }
            return attList;
        }

        public void endDocument() throws SAXException {
            this.removeMetaAttributes(this.xmlDoc.getDocumentElement());
        }

        private void removeMetaAttributes(Element element) throws SAXException {
            try {
                NamedNodeMap map = element.getAttributes();
                Attr att = null;
                for (int i = map.getLength() - 1; i >= 0; --i) {
                    att = (Attr)map.item(i);
                    if (att.getNamespaceURI() != null && att.getNamespaceURI().equals(XMB_NAME_SPACE)) {
                        if (!this.metaAttList.contains(att.getLocalName())) continue;
                        element.removeAttributeNode(att);
                        continue;
                    }
                    if (att.getValue().equals(XMB_NAME_SPACE)) {
                        element.removeAttributeNode(att);
                        continue;
                    }
                    if (this.nameSpaceAware || !this.metaAttList.contains(att.getName())) continue;
                    element.removeAttributeNode(att);
                }
                NodeList l = element.getChildNodes();
                for (int i = 0; i < l.getLength(); ++i) {
                    if (!(l.item(i) instanceof Element)) continue;
                    this.removeMetaAttributes((Element)l.item(i));
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void addAttributes(Element element, Attributes atts) throws SAXException {
            try {
                String aName = null;
                for (int i = 0; i < atts.getLength(); ++i) {
                    aName = atts.getLocalName(i);
                    if ("".equals(aName)) {
                        element.setAttribute(atts.getQName(i), atts.getValue(i));
                        continue;
                    }
                    element.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (!target.equalsIgnoreCase("meta-att-list") || !this.isInstructionDataValid(data)) {
                throw new SAXException("Expecting meta-att-list value=\"att1 att2 ... attn\"");
            }
            int p = data.indexOf(34) + 1;
            int p2 = data.lastIndexOf(34);
            this.metaAttList = Arrays.asList(data.substring(p, p2).split(" +"));
        }

        private boolean isInstructionDataValid(String data) {
            String token = "value=\"";
            int p = data.indexOf(token);
            int p2 = data.lastIndexOf("\"");
            return p >= 0 && p2 != p + token.length() - 1;
        }
    }
}

