/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax;

import Xm.InputStream;
import Xm.InputStreamHelper;
import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.XmlGateway.File;
import Xm.XmlGateway.ProcessingResult;
import Xm.XmlGateway.Sink;
import Xm.XmlGateway.SinkHelper;
import com.interstarinc.xmedius.sendfax.FaxException;
import com.interstarinc.xmedius.sendfax.FaxServerNotAvailableException;
import com.interstarinc.xmedius.sendfax.FileInfo;
import com.interstarinc.xmedius.sendfax.IdlInputStream;
import com.interstarinc.xmedius.sendfax.SendResult;
import com.interstarinc.xmedius.sendfax.model.CoverSheetType;
import com.interstarinc.xmedius.sendfax.model.v1.IAttachmentInfo;
import com.interstarinc.xmedius.sendfax.model.v1.IFaxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class SendFax {
    protected static volatile List<String> iors = new ArrayList<String>();

    protected SendFax() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final SendResult send(IFaxModel model, java.io.InputStream xmlDoc, String[] references) throws FaxException {
        String[] iors = SendFax.registerIors(references);
        ServiceLocator sl = ServiceLocator.getInstance((String)"/jacorbSendFax.properties", (String)"JavaXmlFaxSender");
        InputStream xmlStream = null;
        File[] files = null;
        SendResult sendResult = null;
        Logger logger = Logger.getLogger("com.interstarinc.xmedius.sendfax");
        int n = iors == null ? 0 : iors.length;
        for (int i = 0; i < n; ++i) {
            FileInfo[] fileInfos = null;
            try {
                xmlStream = SendFax.createInputStream(xmlDoc, "xml");
                fileInfos = SendFax.toFileInfoArray(model);
                files = new File[fileInfos.length];
                for (int j = 0; j < files.length; ++j) {
                    files[j] = SendFax.createFile(fileInfos[j]);
                }
                Sink xmlSink = SinkHelper.narrow(sl.getCorbaInit().getOrb().string_to_object(iors[i]));
                ProcessingResult result = xmlSink.SubmitXmlFax(xmlStream, files);
                sendResult = new SendResult();
                sendResult.setMessage(result.Message);
                sendResult.setTransactionId("N/A");
                sendResult.setSuccessState(result.Type);
            }
            catch (SystemException e) {
                SendFax.setErrorIor(iors[i]);
                logger.logp(Level.WARNING, SendFax.class.getName(), "send(...)", "Unable to communicate with XML gateway. Exception is {0}", e.toString());
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        SendFax.closeStreams(files, xmlDoc, xmlStream);
                        throw throwable;
                    }
                }
                SendFax.closeStreams(files, xmlDoc, xmlStream);
                continue;
                catch (UserException e2) {
                    throw new FaxServerNotAvailableException(e2);
                    catch (IOException e3) {
                        throw new FaxServerNotAvailableException(e3);
                    }
                    catch (ServiceUnavailableX e4) {
                        throw new FaxServerNotAvailableException(e4);
                    }
                }
            }
            SendFax.closeStreams(files, xmlDoc, xmlStream);
            break;
        }
        if (sendResult == null) {
            throw new FaxServerNotAvailableException("Unable to communicate with XML Gateway(s)");
        }
        return sendResult;
    }

    protected static void closeStreams(File[] files, java.io.InputStream xmlDoc, InputStream xmlStream) {
        Logger logger = Logger.getLogger("com.interstarinc.xmedius.sendfax");
        try {
            ServiceLocator sl = ServiceLocator.getInstance((String)"/jacorbSendFax.properties", (String)"JavaXmlFaxSender");
            POA poa = sl.getCorbaInit().getRootPoa();
            if (files != null) {
                for (int k = 0; k < files.length; ++k) {
                    if (files[k] == null || files[k].Body == null) continue;
                    logger.logp(Level.INFO, SendFax.class.getName(), "send(...)", "Closing file stream {0}", files[k].Name);
                    files[k].Body.Close();
                    poa.deactivate_object(poa.reference_to_id((Object)files[k].Body));
                }
            }
            if (xmlDoc != null) {
                logger.logp(Level.INFO, SendFax.class.getName(), "send(...)", "Closing xmlDoc stream {0}", xmlDoc);
                xmlDoc.close();
            }
            if (xmlStream != null) {
                logger.logp(Level.INFO, SendFax.class.getName(), "send(...)", "Closing xmlStream {0}", xmlStream);
                xmlStream.Close();
                poa.deactivate_object(poa.reference_to_id((Object)xmlStream));
            }
        }
        catch (Exception oups) {
            oups.printStackTrace();
        }
    }

    protected static final InputStream createInputStream(java.io.InputStream stream, String fileExtension) throws UserException, IOException, ServiceUnavailableX {
        IdlInputStream idlStream = null;
        ServiceLocator sl = ServiceLocator.getInstance((String)"/jacorbSendFax.properties", (String)"JavaXmlFaxSender");
        POA poa = sl.getCorbaInit().getRootPoa();
        idlStream = new IdlInputStream(fileExtension, stream);
        poa.activate_object((Servant)idlStream);
        return InputStreamHelper.narrow(poa.servant_to_reference((Servant)idlStream));
    }

    protected static final File createFile(FileInfo fileInfo) throws UserException, IOException, ServiceUnavailableX {
        File file = new File();
        file.Name = fileInfo.getFileName();
        int dot = file.Name.lastIndexOf(46);
        String extension = dot < 0 ? "" : file.Name.substring(dot + 1);
        file.Body = SendFax.createInputStream(fileInfo.getStream(), extension);
        return file;
    }

    protected static final FileInfo[] toFileInfoArray(IFaxModel model) throws FaxException {
        try {
            ArrayList<FileInfo> coverAndAttachments = new ArrayList<FileInfo>();
            if (model.getCoverSheetType() == CoverSheetType.LOCAL) {
                IAttachmentInfo coversheet = model.getCoverSheet();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(coversheet.getName());
                fileInfo.setStream(coversheet.getInputStream());
                coverAndAttachments.add(fileInfo);
            }
            for (IAttachmentInfo attachment : model.getAttachmentList()) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(attachment.getName());
                fileInfo.setStream(attachment.getInputStream());
                coverAndAttachments.add(fileInfo);
            }
            return coverAndAttachments.toArray(new FileInfo[0]);
        }
        catch (IOException e) {
            throw new FaxException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] registerIors(String[] references) {
        List<String> list = iors;
        synchronized (list) {
            for (String ior : references) {
                if (iors.indexOf(ior) != -1) continue;
                iors.add(0, ior);
            }
            ArrayList<String> newIors = new ArrayList<String>(iors);
            for (String ior : iors) {
                boolean remove = true;
                for (String reference : references) {
                    if (!ior.equals(reference)) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                newIors.remove(ior);
            }
            iors.clear();
            iors.addAll(newIors);
            return iors.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setErrorIor(String ior) {
        List<String> list = iors;
        synchronized (list) {
            iors.remove(ior);
            iors.add(ior);
        }
    }
}

