/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius.sendfax;

import Xm.Directories.NotFound;
import Xm.JavaUtils.EntityHelper.SiteHelper;
import Xm.JavaUtils.ServiceUnavailableX;
import Xm.JdInvalidValueX;
import Xm.JdUnreachableDataBaseX;
import com.interstarinc.xmedius.sendfax.CoverSheetIntegrityException;
import com.interstarinc.xmedius.sendfax.EmptyFaxException;
import com.interstarinc.xmedius.sendfax.FaxException;
import com.interstarinc.xmedius.sendfax.InvalidFaxNumberException;
import com.interstarinc.xmedius.sendfax.InvalidProcessingOptionsException;
import com.interstarinc.xmedius.sendfax.NoRecipientException;
import com.interstarinc.xmedius.sendfax.SendFax;
import com.interstarinc.xmedius.sendfax.SendResult;
import com.interstarinc.xmedius.sendfax.XMLBuilder;
import com.interstarinc.xmedius.sendfax.model.CoverSheetType;
import com.interstarinc.xmedius.sendfax.model.IFaxModel;
import com.interstarinc.xmedius.sendfax.model.IRecipientInfo;
import com.interstarinc.xmedius.sendfax.model.v1.FaxModelAdaptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.w3c.dom.Document;

public class Fax {
    public void toXML(IFaxModel model, OutputStream target) throws FaxException {
        this.toXML(new FaxModelAdaptor(model), target);
    }

    public void toXML(com.interstarinc.xmedius.sendfax.model.v1.IFaxModel model, OutputStream target) throws FaxException {
        this.validate(model);
        try {
            XMLBuilder builder = new XMLBuilder();
            InputStream is = this.getClass().getResourceAsStream("/GatewayMetaDoc.xml");
            Document doc = builder.createDocument(model, is);
            Properties props = new Properties();
            props.setProperty("method", "xml");
            props.setProperty("encoding", "utf-8");
            props.setProperty("indent", "yes");
            builder.saveDocument(doc, target, props);
        }
        catch (Exception e) {
            throw new FaxException(e);
        }
    }

    private void validate(com.interstarinc.xmedius.sendfax.model.v1.IFaxModel model) throws FaxException {
        if (model.getRecipientList() == null || model.getRecipientList().size() == 0) {
            throw new NoRecipientException();
        }
        Iterator<com.interstarinc.xmedius.sendfax.model.v1.IRecipientInfo> it = model.getRecipientList().iterator();
        IRecipientInfo ri = null;
        while (it.hasNext()) {
            ri = it.next();
            if (ri.getFaxNumber() != null && ri.getFaxNumber().trim().length() != 0) continue;
            InvalidFaxNumberException ex = new InvalidFaxNumberException();
            ex.setRecipientInfo(ri);
            throw ex;
        }
        if (model.getUserId() == null || model.getUserId().trim().length() == 0) {
            throw new InvalidProcessingOptionsException();
        }
        if (model.getCoverSheetType() == null) {
            throw new FaxException("Property cover sheet is mandatory");
        }
        if (model.getCoverSheetType() == CoverSheetType.DEFAULT || model.getCoverSheetType() == CoverSheetType.NONE) {
            if (model.getCoverSheet() != null) {
                CoverSheetIntegrityException ex = new CoverSheetIntegrityException();
                ex.setCoverSheetMustBeNull(true);
                throw ex;
            }
        } else if (model.getCoverSheet() == null) {
            CoverSheetIntegrityException ex = new CoverSheetIntegrityException();
            ex.setCoverSheetMustBeNull(false);
            throw ex;
        }
        if (!(model.getComment() != null && model.getComment().trim().length() != 0 || model.getAttachmentList() != null && !model.getAttachmentList().isEmpty() || model.getCoverSheetType() != CoverSheetType.NONE)) {
            throw new EmptyFaxException();
        }
    }

    public SendResult send(IFaxModel fax, File xmlFax) throws FaxException {
        try {
            return this.send(new FaxModelAdaptor(fax), new FileInputStream(xmlFax));
        }
        catch (IOException ioe) {
            throw new FaxException(ioe);
        }
    }

    public SendResult send(com.interstarinc.xmedius.sendfax.model.v1.IFaxModel fax, InputStream xmlFax) throws FaxException {
        try {
            String userId = fax.getUserId();
            SiteHelper siteHelper = SiteHelper.createFromSmtpAddress((String)userId);
            String[] xmlGateways = siteHelper.getXmlGatewayHosts("/jacorbSendFax.properties", "JavaXmlFaxSender");
            return SendFax.send(fax, xmlFax, xmlGateways);
        }
        catch (JdUnreachableDataBaseX e) {
            throw new FaxException(e);
        }
        catch (NotFound e) {
            throw new FaxException("Invalid User id/Password");
        }
        catch (ServiceUnavailableX e) {
            if (e.getCause() instanceof JdInvalidValueX) {
                throw new FaxException("Invalid User id/Password");
            }
            throw new FaxException(e);
        }
    }
}

