/**
 *   Esta función "bloquea" un div anteponiendo una capa por sobre sus elementos
 * y devolviendo un identificador que puede utilizarse para desbloquearlo o
 * colocar contenido por sobre el div.
 */
var max_z = 1000;
var blockers = new Array();
var enabled = false;

function InitBlockerSystem() {
    $(window).resize(blockerResizeEvent);
}

function Blocker(div) {
    var instance = $('#'+div);
    this.parent = div;
    this.blocker = div+"_blocker";
    this.box = div+"_blocker_box";
    this.unblock = unblock;
    this.content = content;
    this.enableClose = enableClose;
    this.enableClose = disableClose;
    instance.append('<div id="'+this.blocker+'" class="screenBlocker" style="z-index: '+(instance.css('z-index')+max_z)+';left:'+instance.offset().left+'px;top:'+instance.offset().top+'px;height:'+instance.height()+'px;width:'+instance.width()+'px;"><div id="'+
                  this.box+'" class="screenBlockerBox" style="z-index: '+(instance.css('z-index')+max_z+1)+'"></div></div>');
    blockers[div]=this;
    return this;
}

/**
 *  Bloquea una capa por su id.
 */
function block(div_id, html) {
    blocker = new Blocker(div_id);
    if (html !== null) {
        blocker.content(html);
    } else {
        blockerResize(blocker.parent);
    }
    return blocker;
}

/**
 *  Quita el handler de la capa y de las capas hijas de la lista de handlers
 * y elimina la capa y las capas hijas.
 */
function unblock() {
    $('#'+this.blocker)
        .find("screenBlocker")
        .each( function() {
                var parent_id = $(this).parent().attr('id');
                blockers[parent_id]=null;
               });
    $('#'+this.blocker).remove();
    blockers.splice(this.parent, 1);
}

/**
 *  Establece el contenido de la capa de bloqueo
 */
function content(html, width, height) {
    var blocker = $('#'+this.box);
    blocker.html(html);
    if (width !== null) {
        blocker.width(width);
    }
    if (height !== null) {
        blocker.height(height);
    }
    blockerResize(this.parent);
}

/**
 *  Recalcula el tamaño de todas las layers de bloqueo
 */
function blockerResizeEvent() {
    for(blocker in blockers) {
        blockerResize(blocker);
    }
}

/**
 *  Cambia el tamaño del bloqueador y centra el contenido del mensaje
 */
function blockerResize(blocker) {
    if (blockers[blocker] !== null) {
        var id_blocker='#'+blockers[blocker].blocker;
        var parent = $('#'+blockers[blocker].parent);
        if ($(id_blocker).css('display')=='block') {
            $(id_blocker).css({'left':parent.offset().left, 'top':parent.offset().top, 'width':parent.width(),'height':parent.height()});
            var box = $('#'+blockers[blocker].box);
            var centroH = parent.width()/2;
            var desvioH = box.width()/2;
            box.css('left', centroH-desvioH);
            var centroV = parent.height()/2;
            var desvioV = box.height()/2;
            box.css('top', centroV-desvioV);
        }
    }
}

function enableClose() {
    $(this.box).append('<a id="screenBlocker_unblock" href="javascript:blockers["'+this.parent+'"].unblock();return false;">Cerrar</a>')
}

function disableClose() {
    $(this.box).remove("#screenBlocker_unblock");
}

/*
function ConnectionManager(div, block) {
    this.blocker  = block;
    this.target   = div;
    this.success  = aj_success;
    this.fail     = aj_fail;
    this.progress = aj_progress;
    this.connect  = aj_connect;
    return this;
}

function aj_connect(url, params, options) {
    var final_options = {'async'      :false,
                         'cache'      :false,
                         'contentType':'application/x-www-form-urlencoded',
                         'context'    :document.div,
                         'dataType'   :'html',
                         'global'     :false,
                         'timeout'    :5000,
                         'type'       :'POST',
                         'url'        :url,
                         'success'    :this.success,
                         'error'      :this.fail,
                         'complete'   :

                     };
    for(option in options) {
        final_options[option] = options[option];
    }
    $.ajax(options)
}

function aj_success() {

}

function aj_success() {

}

function aj_success() {

}
*/
function uws_load(url, params, div, block_id) {
/*    var debug = "URL: "+url+"\nParametros:\n";
    for(param in params) {
        debug += param + "\t" + params[param] +"\n";
    }
    debug += +"\nTarget: "+div+"\nBloquear: "+block_id;
    alert(debug);*/
    var blocker;
    if (block_id == undefined) blocker = block(div);
    else blocker = block(block_id);
    blocker.content('<img src="../images/wait.gif" alt=""/> Cargando...');

    $("#"+div).load(url, params, function(responseText, textStatus, xhr) {
                                        if (status == "error") {
                                            blocker.content(xhr.status + " " + xhr.statusText);
                                            blocker.enableClose();
                                        } else {
                                            blocker.unblock();
                                        }
                                 });
    return false;
}

function uws_submit (_form) {
    var form = ($_form);
    var url = form.attr('action');
    var method = form.attr('method');
    var debug = "URL: "+url+"\nMethod: "+method+"\nParametros:\n";
    alert(debug);
    return false;
}

function validateEdit() {
    //TODO meter validaciones por patrones
    return true;
}