<?php
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/User.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/Action.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMObject.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMDefinition.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORM.php';


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una coleccin de permisos agrupados bajo un nombre.
 * 
 * @method UserGroup setDescription()
 * @method string getDescription()
 * @method UserGroup setCreated()
 * @method DateTime getCreated()
 * @method UserGroup setModified()
 * @method DateTime getModified()
 * @method UserGroup setDeleted()
 * @method DateTime getDeleted()
 * @method UserGroup setStatus()
 * @method int getStatus()
 * @method boolean addAction()
 * @method boolean delAction()
 * @method ORMCollection getActions()
 * @method ORMCollection getUsers()
 * 
 */
class UserGroup extends \iplan\orm\ORMObject {
  protected $description;

  /**
   * @var DateTime la fecha de creacin
   */
  protected $created;

  /**
   * @var DateTime la fecha de ltima modificacin
   */
  protected $modified;

  /**
   * @var DateTime la fecha de borrado
   */
  protected $deleted;

  /**
   * @var int el estado del perfil??
   */
  protected $status;

  /**
   * @var array la lista de usuarios que usan el perfil
   */
  protected $users;

  /**
   * @var array la lista de acciones que permite el perfil
   */
  protected $actions;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * 
   * @param ORM $orm el objeto que maneja las definiciones
   * @return ORMDefinition la definicin default
   */
  public static function define($orm = null)
  {
    // Bouml preserved body begin 00058B85
    //$definition = new ORMDefinition();
    return parent::define($orm)->setTable('PERFIL')
            ->addField('id', 'PERFIL_ID', ORM_TYPES::INTEGER)
            ->setKey('id')
            ->addField('description', 'DESCRIPCION', ORM_TYPES::STRING, 255)
            ->addField('created', 'FE_ALTA', ORM_TYPES::DATE, -1, -1, false)
            ->addField('modified', 'FE_MODIFICACION', ORM_TYPES::DATE)
            ->addField('deleted', 'FE_BAJA', ORM_TYPES::DATE)
            ->addField('status', 'ESTADO', ORM_TYPES::INTEGER,2,-1, false)
            ->addRelation1xN('users', 'PERFIL_ID', __NAMESPACE__.'\User')
            ->addRelationNxM('actions', 'PERMISOPERFIL', 'PERFIL_ID', __NAMESPACE__.'\Action', 'PERMISO_ID');
    // Bouml preserved body end 00058B85
  }

}
?>
