<?php
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
class User extends ORMObject {
  /**
   * @var string $name el nombre real del usuario
   */
  protected $name;

  /**
   * @var string $surname el apellido real del usuario
   */
  protected $surname;

  /**
   * @var string $username el nombre de usuario escogido por o para el usuario
   */
  protected $username;

  /**
   * @var string $password el hash de la clave del usuario
   */
  protected $password;

  /**
   * @var Provider el proveedor al que pertenece el usuario
   */
  protected $provider;

  /**
   * @var array $profiles la lista de perfiles que tiene habilitado el usuario
   */
  protected $profiles;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000A5F85
    return parent::define($orm)
               ->setTable('UWS_USER')
               ->addField('id', 'USER_ID', ORMDefinition::INTEGER, 10, 0, false)
               ->setKey('id')
               ->addField('name', 'USER_NAME', ORMDefinition::STRING, 25, 0, false)
               ->addField('surname', 'USER_SURNAME', ORMDefinition::STRING, 25, 0, false)
               ->addField('username', 'USER_USERNAME', ORMDefinition::STRING, 25, 0, false)
               ->addField('password', 'USER_PASSWORD', ORMDefinition::STRING, 40, 0, false)
               ->addRelationNxM('profiles', 'UWS_USER_PROFILE', 'USER_ID', 'Profile')
               ->addInstance('provider', 'PROVIDER_ID', 'Provider');
//               ->addRelationNxM('providers', 'UWS_PROVIDER_USER', 'USER_ID', 'Provider');
    // Bouml preserved body end 000A5F85
  }

}
?>