<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Renderable.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class SecurityManager extends AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 000AFE85
    return array(
        'defaultPage'=>'defaultPage',
        'login'      => 'login',
        'logout'     => 'logout',
        'mainPage'   => 'mainPage',
        'redirect'   => 'redirect',
        'showErrors' => 'showErrors');
    // Bouml preserved body end 000AFE85
  }

  /**
   * Muesta la home page que se ve sin iniciar sesi�n
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\renderable La p�gina en cuesti�n.
   */
  public function defaultPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF05
    $context->set('page_title', 'Bienvenidos clientes de '.$context->getProvider()->getName());
    return new Renderable('welcome.xhtml');
    // Bouml preserved body end 000AFF05
  }

  /**
   * Acci�n que intenta autenticar un usuario en el sistema o, en caso que se llame sin par�metros, devuelve el formulario de login.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n
   * @param boolean $ajax un flag que indica si el llamado requiere una respuesta por AJAX/AJAH
   * @return Renderable Si la autenticaci�n es concretada correctamente retorna un Renderable con la p�gina principal de la aplicaci�n, sino remite de nuevo al login (si hubo error con un mensaje, sino vac�o).
   */
  public function login(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF85
    $app = $this->application;
    //Si están los parámetros valido; sino muestro.
    $username = $app->getParam('username', '', 'P');
    $password = $app->getParam('password', '', 'P');
    $context->set('username', $username);
    $paramsDefined = ($username != '') && ($password != '');
    if ($paramsDefined) {
        $orm = $app->getORM();
        $user = $orm->query('User')
                ->filterBy('provider.id', '=', $context->getProvider()->getId())
                ->filterBy('username', '=', $username)->findOne();
        if ($user) {
            if ($user->getPassword()==sha1($password)) {
                $_SESSION['uws_user_id']=$user->getId();
                $context->setUser($user);
                return $this->mainPage($context, $ajax);
                //$context->set('url', $provider->getBaseURL()."index.php?action=mainpage");
                //return $this->redirect();
            }
        }
        $form_errors['title']='Error al intentar ingresar al sitio';
        $form_errors['messages'][0]['description']='Los datos ingresados al formulario no son válidos';
        $context->set('form_errors', $form_errors);
    } else {
        if ($username) {
            $form_errors['title']='Error al intentar ingresar al sitio';
            $form_errors['messages'][0]['description']='Debe ingresar una clave';
            $form_errors['messages'][0]['field']='password';
            $context->set('form_errors', $form_errors);
        }
        if ($password) {
            $form_errors['title']='Error al intentar ingresar al sitio';
            $form_errors['messages'][0]['description']='Debe ingresar un nombre de usuario';
            $form_errors['messages'][0]['field']='username';
            $context->set('form_errors', $form_errors);
        }
    }
    return new Renderable('login.xhtml');
    // Bouml preserved body end 000AFF85
  }

  /**
   * Termina la sesi�n y vuelve a la defaultPage.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable La home page que corresponde cuando no se inici� sesi�n.
   */
  public function logout(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000B0085
    $this->application->reset($context->getProvider()->getId());
    return $this->defaultPage($context, $ajax);
    // Bouml preserved body end 000B0085
  }

  /**
   * Retorna la p�gina principal.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function mainPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000B0005
    return new Renderable('main.xhtml');
    // Bouml preserved body end 000B0005
  }

  /**
   * Redirige a una p�gina pasada por GET como "url".
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function redirect(&$context, $ajax)
  {
    // Bouml preserved body begin 000BB605
//    header('HTTP/1.1 303 See Other');
    header('Location: '.$context->getParam('params', $context->getParam(0, null)));
//    flush();
//    header("Connection: close");
    exit;
    return false;
    // Bouml preserved body end 000BB605
  }

  /**
   * Lista los usuarios del sistema.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable el template a devolver
   */
  public function listUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C05

    $options['columns'] = array(
        array(
            'title'=>'Identificador',
            'maps'=>'id',
            'hide'=>true
        ),
        array(
            'title'=>'Nombre y Apellido',
            'maps'=>array('name', 'surname'),
            'template'=>'{{surname}}, {{name}}',
            'sortable'=>true
            ),
        array(
            'title'=>'Usuario',
            'maps'=>'username',
            'sortable'=>true
        ),
        array(
            'title'=>'Perfiles',
            'maps'=>'profiles.name',
            'action'=>'Security.viewProfile',
            'mode'  =>'inline-popup',
            'params'=>array('id'=>'profiles.id')
        ),
        array(
            'title'=>'Acciones',
            'actions'=>array(
                'Modificar Usuario'=>array(
                    'action' =>'Security.modifyUser',
                    'mode'   =>'inline-popup',
                    'params' =>array('id'),
                    'refresh'=>'row',
                    'icon'   =>'user_red_edit'
                ),
                'Borrar Usuario'=>array(
                    'action' =>'Security.deleteUser',
                    'mode'   =>'inline',
                    'params' =>array('id'),
                    'refresh'=>'list',
                    'icon'   =>'user_red_delete'
                )
            )
        )
    );
    $options['actions']=array(
        'Agregar Usuario'=>array(
            'action' =>'Security.saveUser',
            'mode'   =>'inline-popup',
            'refresh'=>'list',
            'size'   => 32,
            'icon'   =>'user_red_add'
        ),
        'Exportar a PDF'=>array(
            'action' =>'List2PDF',
            'params' =>array('url' => 'listUsers'),
            'mode'   =>'inline',
            'refresh'=>'none'
        )
    );


/*
    $filters = array(
        'Nombre'  => array(
            'position'   => array(1,1),
            'control'    => array(
                'type'   => 'textEdit',
                'name'   => 'fltName',
                'size'   => 15
            )
        ),
        'Perfil'  => array(
            'position'   => array(1,2),
            'control'    => array(
                'type'   => 'comboBox',
                'name'   => 'fltPerfil',
                'size'   => 10,
                'length' => 6
            )
        ),
        'Usuario' => array(
            'position'   => array(2,1),
            'control'    => array(
                'type'   => 'comboBox',
                'name'   => 'fltPerfil',
                'size'   => 12
            )
        ),
        'Estado'  => array(
            'position'   => array(2,2),
            'control'    => array(
                'type'   => 'comboBox',
                'name'   => 'fltPerfil',
                'size'   => 10,
                'length' => 6
            )
        )
    );
*/

    //Accesos rápidos
    $app = $this->application;
    $orm = $app->getORM();

    //Si el provider no tiene owner traigo los datos de todos
    if ($isMaster=is_null($context->getProvider()->getOwner())) {

    } else {//Sino recupero todos los ids dependientes del provider actual
        //TODO: hacer un while "mientras haya dependencias" y que sea recursivo!
        //por ahora lo dejo solo con el id del provider actual
        $providers = array($context->getProvider()->getId());
    }

    //Busco usuarios
    $query = $orm->query('User');
    //Si es master traigo la info de todo el mundo, sino tengo que filtrar por provider
    if (!$isMaster)
           $query->filterBy('provider.id','IN', $providers);

    //Establezco que campos voy a traer
    $query->attributes('id', 'name', 'surname', 'username');

    //Si hay criterios de ordenamiento
    $sorts = $app->getParam('sorts[]', false, 'PG');
    if ($sorts) {
        foreach($sorts as $sort) {
            list($column, $order)=explode(' ', $sort);
            $query->orderBy("$column ".(($order=='ASC')?'DESC':'ASC'));
        }
    } else {
        //Sort por default
        $query->orderBy('name ASC');
    }

    $mainResult = $query->find();

    for($i=0; $i<count($mainResult);$i++)
        $ids[]=$mainResult[$i]['id'];

    if (isset($ids)) {
        $query2 = $orm->query('Profile');
        $query2->filterBy('users.id','IN', $ids)
               ->attributes('users.id', 'id', 'name' )
               ->orderBy('users.id');
        $secondaryResult = $query2->find();
    }

    $this->merge($mainResult, array('id'=>'users.id'), $secondaryResult, array('name'=>'profiles.name', 'id'=>'profiles.id'));
    $context->set('list_options', $options);
    $context->set('list_items', $mainResult);
    return new Renderable("list.xhtml");
    // Bouml preserved body end 000C6C05
  }

  /**
   * Agrega un usuario al sistema, bajo el dominio del provider o presenta un formulario para dar de alta un usuario nuevo.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   */
  public function saveUser(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C85
    $app = $this->application;
    $orm = $app->getORM();
/*    $user_id = $app->getParam('id', null, 'P');*/
    return new Renderable('welcome.xhtml');
    
/*
    $orm = $this->application->getORM();
    
    $query = $orm->query('User');
    $query->filterBy('name', 'like', 'admin%')
          ->filterBy('provider.profiles.name', '=', 'iPlan')
          ->filterBy('profiles.id', '=', 1)
          ->filterBy('profiles.provider.id', '=', 5)
          ->filterBy('profiles.name', 'like', 'admin%');
    $query->attributes('name', 'username', 'profiles.name', 'profiles.provider.id', 'profiles.provider.name');
    $query->orderBy('name', 'profiles.name', 'provider.name', 'provider.profiles.id');
    $query->groupBy('id', 'name', 'profiles.id', 'profiles.name');
//    $query->attributes('name', 'username');
    krumo($query->conditions);

//    $query->build2();
    list($encrypted, $sorts, $groups) = $query->build();
    krumo($sorts);
    krumo($groups);
    krumo($query->decrypt($encrypted));

    return new Renderable("test.xhtml");*/
    // Bouml preserved body end 000C6C85
  }

  /**
   * Borra el usuario identificado por "user_id".
   */
  public function deleteUser(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6D05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6D05
  }

  /**
   * Cambia la contrase�a del usuario actual
   */
  public function changePassword(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6D85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6D85
  }

  /**
   * Lista los perfiles relacionados al provider
   */
  public function listProfiles(&$context)
  {
    // Bouml preserved body begin 000C6E05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6E05
  }

  /**
   * Guarda o modifica el perfil indicado
   */
  public function saveProfile(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6E85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6E85
  }

  /**
   * Borra el perfil especificado
   */
  public function deleteProfile(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6F05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6F05
  }

  /**
   * Lista las acciones relacionadas al provider
   */
  public function listActions(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6F85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6F85
  }

  /**
   * Crea o guarda la acci�n indicada
   */
  public function saveAction(&$context, $ajax)
  {
    // Bouml preserved body begin 000C7005
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C7005
  }

  /**
   * Borra la acci�n indicada
   */
  public function deleteAction(&$context, $ajax)
  {
    // Bouml preserved body begin 000C7085
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C7085
  }

  /**
   * Muestra un mensaje de error personalizado
   */
  public function showError(&$context, $ajax)
  {
    // Bouml preserved body begin 000D1105
    $app = $this->application;

    $title = $app->getParam('title', 'Error Desconocido', 'PG');
    $msg = $app->getParam('msg', 'No hay Descripción', 'PG');
    $mainicon = $app->getParam('mainicon', 'blank', 'PG');
    $icon = $app->getParam('icon', 'blank', 'PG');

    $errors['title']   = $title;
    $errors['subject'] = '';
    $errors['icon']= $mainicon;
    $errors['messages'][0]['icon'] = $icon;
    $errors['messages'][0]['description'] = $msg;

    $context->set('errors', $errors);
    return new Renderable('lib/show_errors.xhtml');
//errors[title]
//errors[subject]
//errors[messages][0][icon]
//errors[messages][0][description]
//errors[messages][0][field]
    // Bouml preserved body end 000D1105
  }

}
?>