<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
class Menu extends ORMObject {
  protected $name;

  /**
   * @var string par�metros adicionales para pasar por GET a la acci�n
   */
  protected $params;

  /**
   * @var string el nombre del estilo del �cono
   */
  protected $icon;

  /**
   * @var int El n�mero de orden de aparici�n del menu
   */
  protected $order;

  /**
   * Indica si este men� se carga preferentemente a trav�s de AJAH o si directamente redirige el sitio a otro lado.
   */
  protected $dynamic;

  /**
   * @var Action $action la acci�n que ejecuta el men�
   */
  protected $action;

  /**
   * @var array la lista de submenues del men� actual
   */
  protected $submenus;

  /**
   * @var iplan\security\Provider la lista de proveedores que tienen configurado este menu
   */
  protected $provider;

  /**
   * @var iplan\security\Menu el menu padre del actual.
   */
  protected $parent;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return iplan\orm\ORMDefinition la definici�n default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000BB585
    return parent::define($orm)
            ->setTable('UWS_MENU')
            ->addField('id', 'MENU_ID', ORMDefinition::INTEGER)
            ->setKey('id')
            ->addField('name', 'MENU_NAME', ORMDefinition::STRING, 25, 0, false)
            ->addField('params', 'MENU_PARAMS', ORMDefinition::STRING, 255)
            ->addField('icon', 'MENU_ICON', ORMDefinition::STRING, 40)
            ->addField('order', 'MENU_ORDER', ORMDefinition::INTEGER)
            ->addField('dynamic', 'MENU_DYNAMIC', ORMDefinition::BOOLEAN,1,0,false,  ORMDefinition::FORCE_LOAD,true)
            ->addInstance('action', 'ACTION_ID', 'Action')
            ->addInstance('parent', 'MENU_PARENT', 'Menu')
            ->addInstance('provider', 'PROVIDER_ID', 'Provider')
            ->addRelation1xN('submenus', 'MENU_PARENT', 'Menu');
    // Bouml preserved body end 000BB585
  }

}
?>