<?php
require_once 'iplan/security/AbstractManager.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GeneralManager extends AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 000ACA05
    return array('mailTo', 'toHTML', 'url', 'sessionData');
    // Bouml preserved body end 000ACA05
  }

  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listMethods()
  {
    // Bouml preserved body begin 000BD105
    // Bouml preserved body end 000BD105
  }

  /**
   * Recupera la un arreglos con los datos necesarios para crear el menu de la aplicaci�n.
   * @return array La lista de los menues de la aplicaci�n.
   */
  public function getMenus()
  {
    // Bouml preserved body begin 000BD005
    $context = $this->application->getContext();
    $orm = $this->application->getORM();
    $result = array();
    $query = $orm->query('Menu')
                 ->filterBy('provider.id', '=', $context->getProvider()->getId())
                 ->filterBy('action.profiles.users.id', '=', $context->getUser()->getId());
    $nodes = $query->find();
    $menus = array();
    $this->buildMenuTree($nodes, $menus);
    return $menus;
    // Bouml preserved body end 000BD005
  }

  private function buildMenuTree($nodes, &$menu, $parent = null)
  {
    // Bouml preserved body begin 000BEB85
    if (count($nodes)>0) {
        foreach($nodes as $key=>$node) {
            $cond1 = is_null($node->getParent()) && is_null($parent);
            $cond2 = (!is_null($node->getParent()) && ($node->getParent()->getId()==$parent));
            if ( $cond1 || $cond2) {
                $menu[$node->getOrder()]['menu']=$node;
                $menu[$node->getOrder()]['submenu']=array();
                $nodes=array_diff_key($nodes, array($key=>null));//<-por Compatibilidad versión anterior
//                $nodes = array_filter($nodes, function ($element) use ($node) { return ($element != $node); } ); //No soportado por PHP del Server
                $this->buildMenuTree($nodes, $menu[$node->getOrder()]['submenu'], $node->getId());
            }
        }
    }
    // Bouml preserved body end 000BEB85
  }

  /**
   * Env�a un email a trav�s del smtp del sistema.
   * 
   * @param string $from la direcci�n de correo remitente. Puede usarse el formato "Nombre" <mail@dominio> (el nombre incluye las comillas)
   * @param array $to una lista de direcciones a las cuales enviar el mensaje, cada direcci�n de correo destino se rigue bajo las mismas reglas de formato de $from
   * @param string $title el t�tulo del mensaje
   * @param string $body el cuerpo del mensaje, puede ser c�digo html
   * @param array $cc la lista de destinatarios con copia, puede usar formato "Nombre" <mail@dominio>
   * @param array $bcc la lista de destinatarios con copia oculta, puede usar el formato anterior
   */
  public function mailTo($from, $to, $title, $body, $cc = null, $bcc = null)
  {
    // Bouml preserved body begin 000A7A85
    // Bouml preserved body end 000A7A85
  }

  /**
   * Transforma acentos y caracteres especiales a un formato compatible HTML
   * @param string $text el texto a convertir
   * @result string Un texto equivalente en HTML al original.
   */
  public function toHTML($text)
  {
    // Bouml preserved body begin 000AC985
    $text = htmlentities($text, ENT_NOQUOTES, 'UTF-8'); // Convertir caracteres especiales a entidades
    $text = htmlspecialchars_decode($text, ENT_NOQUOTES); // Dejar <, & y > como estaban
    return $text;
    // Bouml preserved body end 000AC985
  }

  /**
   * Convierte una URL dada en otra que sirve para obtener el archivo deseado de acuerdo al contexto.
   * @param string $url la url del recurso
   * @return string una direcci�n
   */
  public function url($url)
  {
    // Bouml preserved body begin 000B1B85
    return "Test: $url";
    // Bouml preserved body end 000B1B85
  }

  /**
   * Devuelve la informaci�n de los datos de sesi�n mediante un vardump()
   */
  public function sessionData()
  {
    // Bouml preserved body begin 000C5185
    var_dump($_SESSION);
    var_dump($_POST);
    var_dump($_GET);
    return "= FIN DUMPS =";
    // Bouml preserved body end 000C5185
  }

}
?>