<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
class Facade extends ORMObject {
  /**
   * @var string $class el nombre de la clase "Facade"
   */
  protected $class;

  /**
   * @var string file el archivo donde se encuentra el facade
   */
  protected $file;

  /**
   * @var string $alias un ttulo descriptivo para el usuario
   */
  protected $alias;

  /**
   * @var array la lista de acciones actualmente autorizadas del facade
   */
  protected $actions;

  /**
   * @var array la coleccin de Proveedores que tienen habilitado el Facade
   */
  protected $providers;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return iplan\orm\ORMDefinition la definicin default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000A6105
    $definition = parent::define($orm)
            ->setTable('UWS_FACADE')
            ->addField('id', 'FACADE_ID', ORMDefinition::INTEGER)
            ->setKey('id')
            ->addField('class', 'FACADE_CLASS', ORMDefinition::STRING, 50, 0, FALSE)
            ->addField('file', 'FACADE_FILE', ORMDefinition::STRING, 255, 0, FALSE)
            ->addField('alias', 'FACADE_ALIAS', ORMDefinition::STRING, 25, 0, FALSE)
            ->addRelation1xN('actions', 'FACADE_ID', 'Action')
            ->addRelationNxM('providers', 'UWS_PROVIDER_FACADE','FACADE_ID', 'Provider', 'PROVIDER_ID');
    return $definition;
    // Bouml preserved body end 000A6105
  }

}
?>