<?php
require_once 'iplan/security/Application.php';
require_once 'iplan/security/User.php';
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Provider.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ApplicationContext {
  /**
   * @var \iplan\security\Application la aplicaci�n a la que pertenece el contexto
   */
  private $application;

  private $user;

  /**
   * @param array $globals un arreglo donde se almacenan las variables de sesi�n y otros que se quieran pasar globalmente a trav�s de la sesi�n
   */
  private $globals;

  /**
   * @var array la lista de descendientes de AbstractManagers que tiene habilitado el usuario.
   */
  private $managers;

  /**
   * @var \iplan\security\Provider el proveedor en el que est� logueado el usuario
   */
  private $provider;

  /**
   * Crea un contexto de la aplicaci�n, cargando las facilidades que el usuario tiene para el proveedor del servicio indicado.
   */
  public function __construct(&$application, &$user, $provider)
  {
    // Bouml preserved body begin 000AE405
    $this->application = $application;
    $this->user = $user;
    $this->managers = array();
    $this->provider = $provider;
    return $this;
    // Bouml preserved body end 000AE405
  }

  /**
   * Guarda un valor en la sesi�n activa.
   * 
   * @param string $name el nombre de la variable de sesi�n cuyo valor se quiere establecer
   * @param mixed $value el valor de dicha variable
   * 
   * @return boolean Un indicador del resultado de la operaci�n. Si es False quiere decir que no se efectu�.
   */
  public function set($name, $value)
  {
    // Bouml preserved body begin 000A4285
    if (is_null($value)) {
        if (isset ($this->globals[$name])) {
            unset($this->globals[$name]);
             $this->globals=array_values($this->globals);
        }
    } else {
        $this->globals[$name]=$value;
    }
    // Bouml preserved body end 000A4285
  }

  /**
   * Devuelve el valor de una variable de contexto.
   * @param string el nombre de la variable cuyo valor se quiere recuperar
   * @return mixed El valor de la variable solicitada si es que la misma existe.
   */
  public function get($name)
  {
    // Bouml preserved body begin 000C1E85
//    if (isset ($this->globals[$name])) {
        return $this->globals[$name];
//    } else {
//        return null;
//    }
    // Bouml preserved body end 000C1E85
  }

  /**
   * Quita un valor de la sesi�n
   * @param string $name el nombre de la variable a quitar
   * @return boolean Un indicador del resultado de la operaci�n, FALSE si hubo alg�n problema.
   */
  public function reset($name)
  {
    // Bouml preserved body begin 000A4305
    echo "Algo";
    // Bouml preserved body end 000A4305
  }

  /**
   * Agrega un Facade al contexto utilizable por el usuario.
   * @param string $alias el nombre con el cual se referir� al manager desde los templates
   * @param iplan\security\AbstractManager $manager El manejador a ser agregado al contexto
   * @return iplan\security\Context El contexto configurado
   */
  public function addManager($alias, &$manager)
  {
    // Bouml preserved body begin 000AE485
//    echo "Agregando Manager::$alias<br>";
    $this->managers[$alias] = $manager;
    // Bouml preserved body end 000AE485
  }

  /**
   * Recupera un manager del contexto de la aplicaci�n
   * 
   * @param string $alias el alias del manager
   * 
   * @return iplan\security\AbstractManager|FALSE retorna el manager solicitado o FALSE si el usuario actual no tiene permiso o si el manager no existe.
   */
  public function getManager($alias)
  {
    // Bouml preserved body begin 000B1A05
    if (isset($this->managers[$alias]))
        return $this->managers[$alias];
    else
        return false;
    // Bouml preserved body end 000B1A05
  }

  /**
   * Wrapper de la hom�nima de la aplicaci�n con el agregado de que busca en el contexto:
   * Recupera un par�metro pasado al script.
   * @param string $name el nombre del par�metro
   * @param mixed $default el valor a devolver en caso que el par�metro no se encuentre
   * @param string $where un string que indica en qu� contexto buscar: P=POST, G=GET, R=REQUEST y C=Context (variables globales)
   * 
   * @return mixed El valor recuperado
   */
  public function getParam($name, $default = null, $where = 'PGRC')
  {
    // Bouml preserved body begin 000B4E85
    $where = strtoupper($where);
    for($i=0; $i<strlen($where); $i++) {
        switch($where[$i]) {
            case 'P':
            case 'G':
            case 'R': if (!is_null($value= $this->application->getParam($name, null, $where[i]))) return $value; break;
            case 'C': if (isset ($this->globals[$name])) return $this->globals[$name]; break;
            default:
                throw new Exception("Error al recuperar parámetro $name en ".  strtoupper($where));
        }
    }
    return $default;
    // Bouml preserved body end 000B4E85
  }

  final public function getUser()
  {
    return $this->user;
  }

  /**
   * Asigna el usuario. Este m�todo s�lo debe ser empleado para cambiar el usuario activo en acciones tales como el "login".
   * @param User $user el nuevo usuario del contexto
   * @return ApplicationContext El contexto modificado
   */
  public function setUser($user)
  {
    // Bouml preserved body begin 000C3805
    $this->user = $user;
    return $this;
    // Bouml preserved body end 000C3805
  }

  final public function getProvider()
  {
    return $this->provider;
  }

  /**
   * Convierte los datos de la sesi�n en variables de Twig.
   * 
   * @return array Un arreglo con los objetos al estilo Twig.
   */
  public function toTwigArguments()
  {
    // Bouml preserved body begin 000B1A85
    $array = array();
    if (is_array($this->globals)) {
        foreach($this->globals as $key => $value) {
            $array[$key] = $value;
        }
    }
    foreach($this->managers as $alias => $manager) {
        $array[$alias] = $manager;
        foreach($manager->__listActions() as $action) {
            $array[$alias]->$action = "$alias.$action";
        }
    }
    $array['User']=$this->user;
    $array['Provider']=$this->provider;
    return $array;
    // Bouml preserved body end 000B1A85
  }

}
class Nada {
}
?>