<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/AbstractManager.php';

require_once "iplan/orm/ORM.php";
require_once 'iplan/orm/OracleDatabase.php';

require_once 'lib/Twig/Autoloader.php';
require_once 'iplan/twig/IPlanExtension.php';

/**
* Author: Jorge Alexis Viqueira
* 
*/
class Application {
  /**
   * @var Application variable que alberga la instancia de la aplicaci�n
   */
  private static $instance;

  /**
   * @var ORM la instancia del manejador de objetos de la aplicaci�n
   */
  private $orm;

  /**
   * @var Twig_Environment la instancia del motor de templates
   */
  private $twig;

  /**
   * @var Enviroment una instancia con los valores globales registrados por los usuarios
   */
  private $context;

  /**
   * @var array la lista de menus de la aplicaci�n
   */
  private $menus;

  private function __construct()
  {
    // Bouml preserved body begin 000A9405

    //TODO parametrizar esto
    $this->orm = ORM::getInstance();
    $this->orm->setDatabase(new OracleDatabase());
    if ($this->getParam('destroy_session', false)) {
        session_destroy();
        session_start();
    }
    //Cargo el proveedor, por default el 1 = IPlan
    if ($setClientDirectory = !isset($_SESSION['uws_provider_id']))
        $_SESSION['uws_provider_id']=$this->getParam ('uws_provider_id', 1);
    $provider = $this->orm->load ('Provider', $_SESSION['uws_provider_id']);

    //Cargo el alias del directorio
    if ($setClientDirectory) $_SESSION['uws_client'] = $provider->getAlias();

    //Cargo el usuario de la sesión o el anónimo si el mismo no está especificado
    if ($setUser = !isset($_SESSION['uws_user_id'])) {
        $user = $provider->getAnonymous();
    } else {
        $query = $this->orm->query('User')
                ->filterBy('id', '=', $_SESSION['uws_user_id'])
                ->filterBy('provider.id', '=', $provider->getId());
        $user = $query->findOne();
    }
    if ($user == false) throw new Exception('El usuario no existe');
    else if ($setUser) $_SESSION['uws_user_id']=$user->getId();

    //Cargo el entorno de Twig
    $loader = new Twig_Loader_Filesystem(array('templates/'.$provider->getAlias(), 'templates/default', 'templates'));
    $twig = new Twig_Environment($loader, array('cache'=>'cache', 'auto_reload'=>true, 'debug'=>true));//TODO quitar DEBUG
    $twig->addExtension(new IPlanExtension($this));
//    $twig->clearTemplateCache();

    //Carga los "módulos" o Facades...
    $facades = $provider->getFacades();
    foreach($facades as $facade) {
        require_once $facade->getFile();
    }

    //Genera el contexto
    $context = new ApplicationContext($this, $user, $provider);

/* Esto debería hacerse en el CONTEXTO cuando se configure el SANDBOX, acá no es posible limitar las acciones
   del template.
    //Cargo los managers habilitados para el usuario al contexto
    $queryFacades = $this->orm->query('Facade')
                              ->filterBy('actions.profiles.users.id', '=', $user->getId())
                              ->filterBy('actions.profiles.provider.id', '=', $provider->getId());
    krumo($queryFacades->decrypt($queryFacades->build()));
    $enabledFacades = $queryFacades->find();
    krumo($enabledFacades);


    foreach($enabledFacades as $facade) {
  */
    foreach($facades as $facade) {
        $class   = $facade->getClass();
        $manager = new $class($this);
        $context->addManager($facade->getAlias(), $manager);
    }
    $context->set('application_name', $provider->getName());

    $this->twig = $twig;
    $this->context = $context;
    return $this;
    // Bouml preserved body end 000A9405
  }

  /**
   * Resetea los datos de sesi�n y vuelve a cargar la informaci�n de la aplicaci�n (permisos, etc).
   * TODO: Este m�todo nunca deber�a ser tocado desde los templates.
   */
  public function reset($provider_id = null, $user_id = null)
  {
    // Bouml preserved body begin 000C5205
//    session_destroy();
//    session_start();
    //Cargo el proveedor, por default el 1 = IPlan
    if (is_null($provider_id))
         $_SESSION['uws_provider_id']=$this->getParam ('uws_provider_id', 1);
    else $_SESSION['uws_provider_id']=$provider_id;

    $provider = $this->orm->load ('Provider', $_SESSION['uws_provider_id']);

    //Cargo el alias del directorio
    if ($setClientDirectory) $_SESSION['uws_client'] = $provider->getAlias();

    //Cargo el usuario de la sesión o el anónimo si el mismo no está especificado
    if (!is_null($user_id)) {
        $query = $this->orm->query('User')
                ->filterBy('id', '=', $user_id)
                ->filterBy('provider.id', '=', $provider->getId());
        $user = $query->findOne();
    } else {
        $user = $provider->getAnonymous();
    }
    if ($user == false) throw new Exception('El usuario no existe');
    else $_SESSION['uws_user_id']=$user->getId();

    //Cargo el entorno de Twig
    $loader = new Twig_Loader_Filesystem(array('templates/'.$provider->getAlias(), 'templates/default', 'templates'));
    $twig = new Twig_Environment($loader, array('cache'=>'cache', 'auto_reload'=>true, 'debug'=>true));//TODO quitar DEBUG
    $twig->addExtension(new IPlanExtension($this));
    $twig->clearTemplateCache();

    //Carga los "módulos" o Facades...
    $facades = $provider->getFacades();
    foreach($facades as $facade) {
        require_once $facade->getFile();
    }

    //Genera el contexto
    $context = new ApplicationContext($this, $user, $provider);

    foreach($facades as $facade) {
        $class   = $facade->getClass();
        $manager = new $class($this);
        $context->addManager($facade->getAlias(), $manager);
    }
    $context->set('application_name', $provider->getName());

    $this->twig = $twig;
    $this->context = $context;
    return $this;
    // Bouml preserved body end 000C5205
  }

  /**
   * Devuelve la aplicaci�n actual o, en caso de no existir, genera una nueva.
   * 
   * @return Application La instancia de la aplicaci�n
   */
  public static function getInstance()
  {
    // Bouml preserved body begin 000A9485
    if (is_null(self::$instance)) {
        self::$instance = new Application();
    }
    return self::$instance;
    // Bouml preserved body end 000A9485
  }

  /**
   * Recupera el contexto de la aplicaci�n.
   * 
   * @return \iplan\security\Context El contexto de la aplicaci�n en curso
   */
  public function getContext()
  {
    // Bouml preserved body begin 000B6885
    return $this->context;
    // Bouml preserved body end 000B6885
  }

  /**
   * Recupera un par�metro pasado al script.
   * 
   * @param string $name el nombre del par�metro
   * @param mixed $default el valor a devolver en caso que el par�metro no se encuentre
   * @param string $where un string que indica en qu� contexto buscar: P=POST, G=GET, R=REQUEST
   * 
   * @return mixed El valor recuperado
   */
  public function getParam($name, $default = null, $where = 'PGR')
  {
    // Bouml preserved body begin 000A5D85
    $where = strtoupper($where);
    for($i=0; $i<strlen($where); $i++) {
        switch($where[$i]) {
            case 'P': if (isset($_POST[$name])) return $_POST[$name]; break;
            case 'G': if (isset($_GET[$name])) return $_GET[$name]; break;
            case 'R': if (isset($_REQUEST[$name])) return $_REQUEST[$name]; break;
            default:
                throw new Exception("Error al recuperar parámetro $name en ".  strtoupper($where));
        }
    }
    return $default;
    // Bouml preserved body end 000A5D85
  }

  /**
   * Recupera el ORM de la aplicaci�n.
   * 
   * @return ORM El ORM de la aplicaci�n.
   */
  public function getORM()
  {
    // Bouml preserved body begin 000B6805
    return $this->orm;
    // Bouml preserved body end 000B6805
  }

  /**
   * Verifica qu� se debe hacer seg�n los par�metros de la URL.
   * @param Boolean $isAjax indica si el c�digo debe ser devuelto como c�digo Ajax o como HTML
   * @return boolean True si todo anda bien, False sino.
   */
  public function parseParams($isAjax)
  {
    // Bouml preserved body begin 000A5C85
    $urlCode = $this->getParam('action', 'default','PG');
    $actionQuery = $this->orm->query('Action')
                   ->filterBy('urlCode', '=', $urlCode)
                   ->filterBy('profiles.provider.id', '=', $this->context->getProvider()->getId())
                   ->filterBy('profiles.users.id', '=', $this->context->getUser()->getId())
                   ->orderBy('id ASC');
    $action = $actionQuery->findOne();
    if ($action == FALSE) {
//        throw new Exception("No tiene permiso para ejecutar esa acción [$urlCode]");
        $renderable = new Renderable("lib/form_errors.xhtml");
        $form_errors['title']="Error de acceso";
        $form_errors['messages'][0]['description']='El usuario "'.$this->context->getUser()->getUsername()."\" no tiene permisos para ejecutar: $urlCode";
        $this->context->set('form_errors', $form_errors);
    } else {
        $managerInstance = $this->context->getManager($action->getFacade()->getAlias());
        $method = $action->getMethod();
        $renderable = $managerInstance->$method($this->context, $isAjax);
    }

    if ($renderable) {
        $template_file=$renderable->getTemplate();
        if ($isAjax) {
            $template = $this->twig->loadTemplate($template_file);
        } else {
            $template = $this->twig->loadTemplate("index.xhtml");
            $this->context->set('MainContent', $template_file);
        }
        $this->context->set('AJAX', $isAjax);
        $template->display($this->context->toTwigArguments());
    }
    // Bouml preserved body end 000A5C85
  }

  /**
   * Destruye las variables de sesi�n.
   * Nota: La sesi�n se destruye pero SE CREA de nuevo inmediatamente y se guarda el id del Provider.
   * 
   * @return boolean un boleano indicando con TRUE que la operaci�n fue realizada con �xito
   */
  public function destroy_session()
  {
    // Bouml preserved body begin 000BB685
    if (session_destroy()) {
        session_start();
        $_SESSION['provider_id']=$this->context->getProvider()->getId();
        return true;
    } else return false;
    // Bouml preserved body end 000BB685
  }

  /**
   * ATENCI�N: DROPEA TODAS LAS TABLAS, RELACIONES, CONTRAINTS Y GENERADORES.
   * 
   * M�todo para generar los valores iniciales en las tablas:
   * - Usuarios: Admin, Client
   * - Profiles: Administrator, Client
   * - Actions: Login, Logout
   * - Facades: GeneralManager, UserManager
   * 
   * @return boolean retorna true para el caso que todo salga bien
   */
  public static function install()
  {
    // Bouml preserved body begin 000A9505

    /********************             DROPS              ********************/
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_ACTION CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_ACTION');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_FACADE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_FACADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROFILE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROFILE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROFILE_ACTION CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROFILE_ACTION');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_USER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_USER');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_MENU CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_MENU CASCADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER_USER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER_USER');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_USER_PROFILE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_USER_PROFILE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER_FACADE CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER_FACADE');
    $sql[]=array("begin execute immediate 'DROP TABLE UWS_PROVIDER CASCADE CONSTRAINTS '; exception when others then null;end;", 'Borrando UWS_PROVIDER');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_ACTION'; exception when others then null;end;", 'Borrando secuencia UWS_USER_PROFILE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_FACADE'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_FACADE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_PROFILE'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_PROFILE');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_USER'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_USER');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_PROVIDER'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_PROVIDER');
    $sql[]=array("begin execute immediate 'DROP SEQUENCE SEQ_UWS_MENU'; exception when others then null;end;", 'Borrando secuencia SEQ_UWS_MENU');

    /********************             TABLAS Y PK              ********************/
    $sql[]=array('CREATE TABLE UWS_ACTION
               ( 
                ACTION_ID NUMBER  NOT NULL , 
                ACTION_NAME VARCHAR2 (25)  NOT NULL , 
                ACTION_DESCRIPTION VARCHAR2 (2048) , 
                ACTION_METHOD VARCHAR2 (25)  , 
                ACTION_URL_CODE VARCHAR2 (10)  NOT NULL ,
                ACTION_HINT VARCHAR2 (40) , 
                FACADE_ID NUMBER  NOT NULL 
               ) LOGGING ', 'Creando UWS_ACTION');
    $sql[]=array('ALTER TABLE UWS_ACTION
               ADD CONSTRAINT UWS_ACTION_PK PRIMARY KEY ( ACTION_ID ) ', '--->Estableciendo clave primaria ACTION_ID');
    $sql[]=array('CREATE TABLE UWS_FACADE
                ( 
                FACADE_ID NUMBER  NOT NULL ,
                FACADE_CLASS VARCHAR2 (50)  NOT NULL ,
                FACADE_FILE VARCHAR2 (255)  NOT NULL ,
                FACADE_ALIAS VARCHAR2 (25)  NOT NULL
               ) LOGGING', 'Creando UWS_FACADE');
    $sql[]=array('ALTER TABLE UWS_FACADE
                ADD CONSTRAINT UWS_FACADE_PK PRIMARY KEY ( FACADE_ID )', '--->Estableciendo clave primaria FACADE_ID');
    $sql[]=array('CREATE TABLE UWS_PROFILE
            (
             PROFILE_ID NUMBER  NOT NULL ,
             PROFILE_NAME VARCHAR2 (50)  NOT NULL ,
             PROFILE_DESCRIPTION VARCHAR2 (2048),
             PROVIDER_ID NUMBER  NOT NULL 
            ) LOGGING', 'Creando UWS_PROFILE');
    $sql[]=array('ALTER TABLE UWS_PROFILE
            ADD CONSTRAINT UWS_PROFILE_PK PRIMARY KEY ( PROFILE_ID ) ', '--->Estableciendo clave primaria PROFILE_ID');
    $sql[]=array('CREATE TABLE UWS_PROFILE_ACTION
            (
             PROFILE_ID NUMBER  NOT NULL ,
             ACTION_ID NUMBER  NOT NULL
            ) LOGGING', 'Creando UWS_PROFILE_ACTION');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_PK PRIMARY KEY ( PROFILE_ID, ACTION_ID ) ', '--->Estableciendo clave primaria  ( PROFILE_ID, ACTION_ID )');
    $sql[]=array('CREATE TABLE UWS_PROVIDER
            (
             PROVIDER_ID NUMBER  NOT NULL ,
             PROVIDER_NAME VARCHAR2 (25)  NOT NULL ,
             PROVIDER_ALIAS VARCHAR2 (25)  NOT NULL ,
             PROVIDER_URL VARCHAR2 (255)  NOT NULL,
             ANONYMOUS_ID NUMBER ,
             PROVIDER_OWNER NUMBER 
            )', 'Creando UWS_PROVIDER');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_PK PRIMARY KEY ( PROVIDER_ID )', '--->Estableciendo clave primaria PROVIDER_ID');
    $sql[]=array('CREATE TABLE UWS_PROVIDER_FACADE
            (
             PROVIDER_ID NUMBER  NOT NULL ,
             FACADE_ID NUMBER  NOT NULL
            ) ', 'Creando UWS_PROVIDER_FACADE');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_PK PRIMARY KEY ( PROVIDER_ID, FACADE_ID )', '--->Estableciendo clave primaria (PROVIDER_ID, FACADE_ID)');
    $sql[]=array('CREATE TABLE UWS_USER
            (
             USER_ID NUMBER  NOT NULL ,
             USER_USERNAME VARCHAR2 (25) ,
             USER_PASSWORD VARCHAR2 (40 CHAR) ,
             USER_NAME VARCHAR2 (25) ,
             USER_SURNAME VARCHAR2 (25),
             PROVIDER_ID NUMBER  NOT NULL 
            ) LOGGING', 'Creando UWS_USER');
    $sql[]=array('ALTER TABLE UWS_USER
            ADD CONSTRAINT UWS_USER_PK PRIMARY KEY ( USER_ID )', '--->Estableciendo clave primaria USER_ID');
    $sql[]=array('CREATE TABLE UWS_USER_PROFILE
            (
             USER_ID NUMBER  NOT NULL ,
             PROFILE_ID NUMBER  NOT NULL
            ) LOGGING', 'Creando UWS_USER_PROFILE');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_PK PRIMARY KEY ( USER_ID, PROFILE_ID )', '--->Estableciendo clave primaria ( USER_ID, PROFILE_ID )');
    $sql[]=array('CREATE TABLE UWS_MENU
            (
             MENU_ID NUMBER  NOT NULL ,
             MENU_NAME VARCHAR2 (25)  NOT NULL ,
             MENU_PARAMS VARCHAR2 (255) ,
             MENU_ICON VARCHAR2 (40) ,
             ACTION_ID NUMBER,
             MENU_PARENT NUMBER,
             MENU_ORDER NUMBER (2),
             MENU_DYNAMIC SMALLINT  NOT NULL ,
             PROVIDER_ID NUMBER  NOT NULL
            )', 'Creando UWS_MENU');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PK PRIMARY KEY ( MENU_ID )', '--->Estableciendo clave primaria MENU_ID');
//    $sql[]=array('CREATE TABLE UWS_PROVIDER_USER
//            (
//             PROVIDER_ID NUMBER  NOT NULL ,
//             USER_ID NUMBER  NOT NULL
//            )', 'Creando UWS_PROVIDER_USER');
//    $sql[]=array('ALTER TABLE UWS_PROVIDER_USER
//    ADD CONSTRAINT UWS_PROVIDER_USER_PK PRIMARY KEY ( PROVIDER_ID, USER_ID )', '--->Estableciendo clave primaria (PROVIDER_ID, USER_ID)');
    $sql[]=array('ALTER TABLE UWS_ACTION
            ADD CONSTRAINT UWS_ACTION_UWS_FACADE_FK FOREIGN KEY
            (
             FACADE_ID
            )
            REFERENCES UWS_FACADE
            (
             FACADE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_ACTION.FACADE_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_ACTION FOREIGN KEY
            (
             ACTION_ID
            )
            REFERENCES UWS_ACTION
            (
             ACTION_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_PROFILE_ACTION.ACTION_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE_ACTION
            ADD CONSTRAINT UWS_PROFILE_ACTION_PROFILE FOREIGN KEY
            (
             PROFILE_ID
            )
            REFERENCES UWS_PROFILE
            (
             PROFILE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_PROFILE_ACTION.PROFILE_ID');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_PROFILE FOREIGN KEY
            (
             PROFILE_ID
            )
            REFERENCES UWS_PROFILE
            (
             PROFILE_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_USER_PROFILE.PROFILE_ID');
    $sql[]=array('ALTER TABLE UWS_USER_PROFILE
            ADD CONSTRAINT UWS_USER_PROFILE_USER FOREIGN KEY
            (
             USER_ID
            )
            REFERENCES UWS_USER
            (
             USER_ID
            )
            NOT DEFERRABLE', 'Creando clave for&aacute;nea UWS_USER_PROFILE.USER_ID');
    $sql[]=array('ALTER TABLE UWS_USER
            ADD CONSTRAINT UWS_USER_PROVIDER_ID_FK FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            )', 'Creando clave for&aacute;nea UWS_USER.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_UWS_USER_FK FOREIGN KEY
            (
             ANONYMOUS_ID
            )
            REFERENCES UWS_USER
            (
             USER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER.ANONYMOUS_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER
            ADD CONSTRAINT UWS_PROVIDER_PROVIDER_FK FOREIGN KEY
            (
             PROVIDER_OWNER
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER.PROVIDER_OWNER');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_FK FOREIGN KEY
            (
             FACADE_ID
            )
            REFERENCES UWS_FACADE
            ( 
             FACADE_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER_FACADE.FACADE_ID');
    $sql[]=array('ALTER TABLE UWS_PROVIDER_FACADE
            ADD CONSTRAINT UWS_PROVIDER_FACADE_FK2 FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROVIDER_FACADE.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_PROFILE
            ADD CONSTRAINT PROVIDER_ID FOREIGN KEY
            ( 
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_PROFILE.PROVIDER_ID');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_ACTION FOREIGN KEY
            (
             ACTION_ID
            )
            REFERENCES UWS_ACTION
            (
             ACTION_ID
            )  ', 'Creando clave for&aacute;nea UWS_MENU.ACTION_ID');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PARENT_FK FOREIGN KEY
            (
             MENU_PARENT
            )
            REFERENCES UWS_MENU
            (
             MENU_ID
            ) ', 'Creando clave for&aacute;nea UWS_MENU.MENU_PARENT');
    $sql[]=array('ALTER TABLE UWS_MENU
            ADD CONSTRAINT UWS_MENU_PROVIDER_FK FOREIGN KEY
            (
             PROVIDER_ID
            )
            REFERENCES UWS_PROVIDER
            (
             PROVIDER_ID
            ) ', 'Creando clave for&aacute;nea UWS_MENU.PROVIDER_ID');
    /********************             SECUENCIAS              ********************/
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_ACTION
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_ACTION');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_FACADE
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_FACADE');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_PROFILE
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_PROFILE');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_USER
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_USER');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_PROVIDER
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_PROVIDER');
    $sql[]=array('CREATE SEQUENCE SEQ_UWS_MENU
            START WITH 1
            INCREMENT BY 1
            MINVALUE 1', 'Creando secuencia SEQ_UWS_MENU');
    require_once('iplan/database/OracleConnection.php');
    $conn = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010");
    $conn->connect();
    echo "<html><head><title>Instalaci&oacute;n autom&aacute;tica</title></head><body><h1>Instalaci&oacute;n</h1><h2>Creaci&oacute;n de Estructura</h2><pre>";
    foreach($sql as $queryDesc) {
        echo str_pad($queryDesc[1], 80, '.',STR_PAD_RIGHT);
        if ($conn->execute($queryDesc[0])) {
            echo str_pad('OK', 5, ' ',STR_PAD_LEFT)."<br>";
        } else {
            echo str_pad('ERROR', 5, ' ',STR_PAD_LEFT);
            return false;
        }
    }
    echo "</pre><h2>Inicializando Datos del Sistema</h2><pre>";
    $orm = ORM::getInstance();
    $orm->setDatabase(new OracleDatabase());

    /***********************             DATOS              ***********************/
    //Se general la instancia del Manager para imprimir texto con escapeo automático
    require_once "iplan/security/GeneralManager.php";
    $generalManager = new GeneralManager($this);

    //Crear Proveedores
    echo "<br><b>Proveedores de Servicios</b><br>";
    $iplanProvider = new Provider($orm);
    $iplanProvider->setName('IPlan S.A.')
                  ->setAlias('iplan')
//                  ->setBaseURL('http://localhost/wholesale/');
                  ->setBaseURL('http://iuniwholesale.iplantech.com.ar/');
    $clientProvider = new Provider($orm);
    $clientProvider->setName('Cliente de Prueba')
                  ->setAlias('client1')
//                  ->setBaseURL('http://localhost/wholesale/');
                  ->setOwner($iplanProvider)
                  ->setBaseURL('http://iuniwholesale.iplantech.com.ar/');
    $iplanProvider->save(); echo "Creado el proveedor ".$iplanProvider->getName()."<br/>";
    $clientProvider->save(); echo "Creado el proveedor ".$clientProvider->getName()."<br/>";

    //Facades
    echo "<b>Facades</b><br>";
    $securityFacade = new Facade($orm);
    $securityFacade->setClass('SecurityManager')
                   ->setFile('iplan/security/SecurityManager.php')
                   ->setAlias('Security')
                   ->addProvider($iplanProvider)
                   ->addProvider($clientProvider);
    $generalFacade = new Facade($orm);
    $generalFacade->setClass('GeneralManager')
                  ->setFile('iplan/security/GeneralManager.php')
                  ->setAlias('Application')
                  ->addProvider($iplanProvider)
                  ->addProvider($clientProvider);
    $orm->save($securityFacade); echo $generalManager->toHTML("Creado registro de Facade SecurityManager (con su relación con IPlan y Client Providers)")."<br>";
    $orm->save($generalFacade);  echo $generalManager->toHTML("Creado registro de Facade GeneralManager  (con su relación con IPlan y Client Providers)")."<br>";

    //Profiles
    echo "<br><b>Perfiles</b><br>";
    $adminProfile = new Profile($orm);
    $adminProfile->setName('Administrador de Sitio - iPlan')
                 ->setDescription('Perfil del administrador del sitio')
                 ->setProvider($iplanProvider);
    $registeredProfile = new Profile($orm);
    $registeredProfile->setName('Usuarios Registrados - iPlan')
                 ->setDescription('Perfil de los usuarios registrados del sitio')
                 ->setProvider($iplanProvider);
    $anonymuosProfile = new Profile($orm);
    $anonymuosProfile->setName('Usuarios Anónimos - iPlan')
                 ->setDescription('Perfil de los usuarios anónimos o no registrados')
                 ->setProvider($iplanProvider);
    $orm->save($adminProfile);      echo "Creando perfil de Administrador (para iPlan)<br>";
    $orm->save($registeredProfile); echo "Creando perfil de Usuarios Registrados (para iPlan)<br>";
    $orm->save($anonymuosProfile);  echo "Creando perfil An&oacute;nimo (para iPlan)<br>";
    
    $adminProfile2 = new Profile($orm);
    $adminProfile2->setName('Administrador de Sitio - Client')
                 ->setDescription('Perfil del administrador del sitio')
                 ->setProvider($clientProvider);
    $registeredProfile2 = new Profile($orm);
    $registeredProfile2->setName('Usuarios Registrados - Client')
                 ->setDescription('Perfil de los usuarios registrados del sitio')
                 ->setProvider($clientProvider);
    $anonymuosProfile2 = new Profile($orm);
    $anonymuosProfile2->setName('Usuarios Anónimos - Client')
                 ->setDescription('Perfil de los usuarios anónimos o no registrados')
                 ->setProvider($clientProvider);
    $orm->save($adminProfile2);      echo "Creando perfil de Administrador (para Client)<br>";
    $orm->save($registeredProfile2); echo "Creando perfil de Usuarios Registrados (para Client)<br>";
    $orm->save($anonymuosProfile2);  echo "Creando perfil An&oacute;nimo (para Client)<br>";

    //Acciones
    echo "<br><b>Acciones</b><br>";
    $defaultAction = new Action($orm);
    $defaultAction->setName('Default Action')
                  ->setDescription('La acción predeterminada')
                  ->setMethod('defaultPage')
                  ->setUrlCode('default')
                  ->setHint('Página predeterminada')
                  ->setFacade($securityFacade);
    $loginAction = new Action($orm);
    $loginAction->setName('Login')
                  ->setDescription('Iniciar sesión o mostrar el formulario de inicio')
                  ->setMethod('login')
                  ->setUrlCode('login')
                  ->setHint('Iniciar sesión')
                  ->setFacade($securityFacade);
    $logoutAction = new Action($orm);
    $logoutAction->setName('Logout')
                  ->setDescription('Terminar la sesión')
                  ->setMethod('logout')
                  ->setUrlCode('logout')
                  ->setHint('Finalizar la sesión')
                  ->setFacade($securityFacade);
    $mainAction = new Action($orm);
    $mainAction->setName('Main Page')
                  ->setDescription('Template de la página principal del sistema')
                  ->setMethod('mainPage')
                  ->setUrlCode('main')
                  ->setHint('Página principal')
                  ->setFacade($securityFacade);
    $redirectAction = new Action($orm);
    $redirectAction->setName('Redirect')
                  ->setDescription('Redirige hacia otro sitio')
                  ->setMethod('redirect')
                  ->setUrlCode('goto')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $NothingAction = new Action($orm);
    $NothingAction->setName('Nothing Action')
                  ->setDescription('La acción de no hacer nada')
                  ->setMethod('')
                  ->setUrlCode('nothing')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $AnnNothingAction = new Action($orm);
    $AnnNothingAction->setName('Nothing Action')
                  ->setDescription('La acción de no hacer nada')
                  ->setMethod('')
                  ->setUrlCode('void')
                  ->setHint('')
                  ->setFacade($securityFacade);
    $listUsersAction = new Action($orm);
    $listUsersAction->setName('List Users')
                  ->setDescription('Lista los usuarios que están en la órbita del proveedor')
                  ->setMethod('listUsers')
                  ->setUrlCode('listUsers')
                  ->setHint('Listado de usuarios')
                  ->setFacade($securityFacade);
    $addUserAction = new Action($orm);
    $addUserAction->setName('Add User')
                  ->setDescription('Agrega un usuario a la órbita del proveedor')
                  ->setMethod('saveUser')
                  ->setUrlCode('addUser')
                  ->setHint('Agregar usuario')
                  ->setFacade($securityFacade);
    $listProfilesAction = new Action($orm);
    $listProfilesAction->setName('List Profiles')
                  ->setDescription('Lista los prefiles de usuario que están en la órbita del proveedor')
                  ->setMethod('listProfiles')
                  ->setUrlCode('listProfs')
                  ->setHint('Listado de perfiles')
                  ->setFacade($securityFacade);
    $addProfilesAction = new Action($orm);
    $addProfilesAction->setName('Add Profile')
                  ->setDescription('Agrega un perfil de usuario a la órbita del proveedor')
                  ->setMethod('saveProfile')
                  ->setUrlCode('addProfile')
                  ->setHint('Agregar perfil')
                  ->setFacade($securityFacade);
    $listActionsAction = new Action($orm);
    $listActionsAction->setName('List Actions')
                  ->setDescription('Lista las acciones que están en la órbita del proveedor')
                  ->setMethod('listActions')
                  ->setUrlCode('listActs')
                  ->setHint('Listado de usuarios')
                  ->setFacade($securityFacade);
    $addActionAction = new Action($orm);
    $addActionAction->setName('Add Action')
                  ->setDescription('Agrega una acción a la órbita del proveedor')
                  ->setMethod('saveAction')
                  ->setUrlCode('addAction')
                  ->setHint('Agregar acción')
                  ->setFacade($securityFacade);
    $showErrorAction = new Action($orm);
    $showErrorAction->setName('Show Error')
                  ->setDescription('Muestra un mensaje de error')
                  ->setMethod('showError')
                  ->setUrlCode('showError')
                  ->setHint('Mostrar Error')
                  ->setFacade($securityFacade);
    $orm->save($defaultAction);     echo "Creada la acci&oacute;n predeterminada del sistema (Default Action)<br>";
    $orm->save($loginAction);       echo "Creada la acci&oacute;n de inicio de sesi&oacute;n (Login)<br>";
    $orm->save($logoutAction);      echo "Creada la acci&oacute;n de fin de sesi&oacute;n (Logout)<br>";
    $orm->save($mainAction);        echo "Creada la acci&oacute;n de la p&aacute;gina principal (Main Page)<br>";
    $orm->save($redirectAction);    echo "Creada la acci&oacute;n de redirecci&oacute;n (Redirect)<br>";
    $orm->save($NothingAction);     echo "Creada la acci&oacute;n de no hacer nada (Nothing)<br>";
    $orm->save($AnnNothingAction);  echo "Creada la acci&oacute;n de no hacer nada para anónimos (Nothing)<br>";
    $orm->save($listUsersAction);   echo "Creada la acci&oacute;n de listar usuarios (listUsers)<br>";
    $orm->save($addUserAction);     echo "Creada la acci&oacute;n de agregar usuarios (addUsers)<br>";
    $orm->save($listProfilesAction);echo "Creada la acci&oacute;n de listar perfiles (listProfs)<br>";
    $orm->save($addProfilesAction); echo "Creada la acci&oacute;n de agregar perfiles (addProfile)<br>";
    $orm->save($listActionsAction); echo "Creada la acci&oacute;n de listar acciones (listActions)<br>";
    $orm->save($addActionAction);   echo "Creada la acci&oacute;n de agregar acciones (addAction)<br>";
    $orm->save($showErrorAction);   echo "Creada la acci&oacute;n de mostrar errores (addAction)<br>";

    //Configurar Perfiles
    echo "<br><b>Configurando Perfiles</b><br>";
    foreach(array($anonymuosProfile, $anonymuosProfile2) as $anonymous) {
        $anonymous->addAction($loginAction);     echo $anonymous->getName(). "-&gt;Login<br/>";
        $anonymous->addAction($defaultAction);   echo $anonymous->getName(). "-&gt;Default Action<br/>";
        $anonymous->addAction($redirectAction);  echo $anonymous->getName(). "-&gt;Redirect<br/>";
        $anonymous->addAction($AnnNothingAction);echo $anonymous->getName(). "-&gt;Nothing Annonymous<br/>";
        $anonymous->addAction($showErrorAction); echo $anonymous->getName(). "-&gt;Mostrar Errores<br/>";
        //Le agrego logout hasta que arregle el redirect()
        //TODO: quitar logout
//        $anonymous->addAction($logoutAction);    echo $anonymous->getName()."-&gt;Logout<br/>";
        $anonymous->save();                      echo $anonymous->getName(). " Guardado<br/><br/>";
    }
    foreach(array($registeredProfile, $registeredProfile2) as $registered) {
        $registered->addAction($logoutAction);    echo $registered->getName()."-&gt;Logout<br/>";
        $registered->addAction($mainAction);      echo $registered->getName()."-&gt;Main Action<br/>";
        $registered->addAction($defaultAction);   echo $registered->getName()."-&gt;Default Action<br/>";
        $registered->addAction($redirectAction);  echo $registered->getName()."-&gt;Redirect<br/>";
        $registered->addAction($NothingAction);   echo $registered->getName()."-&gt;Nothing<br/>";
        $registered->addAction($AnnNothingAction);echo $registered->getName(). "-&gt;Nothing Annonymous<br/>";
        $registered->addAction($showErrorAction); echo $registered->getName(). "-&gt;Mostrar Errores<br/>";
        $registered->save();                      echo $registered->getName()." Guardado<br/><br/>";
    }
    foreach(array($adminProfile, $adminProfile2) as $admin) {
        $admin->addAction($logoutAction);        echo $admin->getName()."-&gt;Logout<br/>";
        $admin->addAction($mainAction);          echo $admin->getName()."-&gt;Main Action<br/>";
        $admin->addAction($defaultAction);       echo $admin->getName()."-&gt;Default Action<br/>";
        $admin->addAction($redirectAction);      echo $admin->getName()."-&gt;Redirect<br/>";
        $admin->addAction($NothingAction);       echo $admin->getName()."-&gt;Nothing<br/>";
        $admin->addAction($AnnNothingAction);    echo $admin->getName(). "-&gt;Nothing Annonymous<br/>";
        $admin->addAction($listUsersAction);     echo $admin->getName()."-&gt;List Users<br/>";
        $admin->addAction($addUserAction);       echo $admin->getName()."-&gt;Add User<br/>";
        $admin->addAction($listProfilesAction);  echo $admin->getName()."-&gt;List Profiles<br/>";
        $admin->addAction($addProfilesAction);   echo $admin->getName()."-&gt;Add Profile<br/>";
        $admin->addAction($listActionsAction);   echo $admin->getName()."-&gt;List Actions<br/>";
        $admin->addAction($addActionAction);     echo $admin->getName()."-&gt;Add Action<br/>";
        $admin->addAction($showErrorAction);     echo $admin->getName()."-&gt;Mostrar Errores<br/>";
        $admin->save();                          echo $admin->getName()." Guardado<br/><br/>";
    }

    //Crear Usuarios y configurar Perfiles
    echo "<br><b>Creando Usuarios</b><br>";
    $adminUser = new User($orm);
    $adminUser->setName('iPlan - Admin')
              ->setUsername('admin')
              ->setpassword(sha1('admin'))
              ->addProfile($adminProfile)
              ->setProvider($iplanProvider);
    $adminUser->save(); echo "Usuario 'admin' (iPlan) asignado a ".$adminProfile->getName()."<br/>";
    $adminUser2 = new User($orm);
    $adminUser2->setName('Client - Admin')
              ->setUsername('admin')
              ->setpassword(sha1('admin'))
              ->addProfile($adminProfile2)
              ->setProvider($clientProvider);
    $adminUser2->save(); echo "Usuario 'admin' (Client) asignado a ".$adminProfile2->getName()."<br/>";
    $registeredUser = new User($orm);
    $registeredUser->setName('iPlan - Registered')
              ->setUsername('registered')
              ->setpassword(sha1('registered'))
              ->addProfile($registeredProfile)
              ->setProvider($iplanProvider);
    $registeredUser->save(); echo "Usuario 'registered' (iPlan) asignado a ".$registeredProfile->getName()."<br/>";
    $registeredUser2 = new User($orm);
    $registeredUser2->setName('Client - Registered')
              ->setUsername('registered')
              ->setpassword(sha1('registered'))
              ->addProfile($registeredProfile2)
              ->setProvider($clientProvider);
    $registeredUser2->save(); echo "Usuario 'registered' (Client) asignado a ".$registeredProfile2->getName()."<br/>";
    $anonymuosUser = new User($orm);
    $anonymuosUser->setName('Anonymous')
              ->setUsername('anonymous')
              ->setpassword(sha1('anonymous'))
              ->addProfile($anonymuosProfile)
              ->setProvider($iplanProvider);
    $anonymuosUser->save(); echo "Usuario 'anonymous' asignado a ".$generalManager->toHTML($anonymuosProfile->getName()).
                                 " y ".$generalManager->toHTML($anonymuosProfile2->getName())." para (iPlan)<br/>";
    $anonymuosUser2 = new User($orm);
    $anonymuosUser2->setName('Anonymous')
              ->setUsername('anonymous')
              ->setpassword(sha1('anonymous'))
              ->addProfile($anonymuosProfile2)
              ->setProvider($clientProvider);
    $anonymuosUser2->save(); echo "Usuario 'anonymous' asignado a ".$generalManager->toHTML($anonymuosProfile->getName()).
                                 " y ".$generalManager->toHTML($anonymuosProfile2->getName())." para (Client)<br/>";

    $iplanProvider->setAnonymous($anonymuosUser);
    $iplanProvider->save(); echo "Registrando el user ".$anonymuosUser->getName()." con ". $iplanProvider->getName()."<br/>";
    $clientProvider->setAnonymous($anonymuosUser2);
    $clientProvider->save(); echo "Registrando el user ".$anonymuosUser2->getName()." con ". $clientProvider->getName()."<br/>";

    //Crear Menues
    echo "<br/><b>Creando Menues</b><br>";

    foreach(array($iplanProvider, $clientProvider) as $provider) {
//Menu Inicio
        $menuInicio = new Menu($orm);
        $menuInicio->setName('Inicio')
                   ->setOrder(1)
                   ->setAction($defaultAction)
                   ->setProvider($provider);
        $menuInicio->save(); echo "Creado el menu Inicio para (".$provider->getName().")<br/>";
//Menu Sistema
        $menuMain = new Menu($orm);
        $menuMain->setName('Sistema')
                   ->setOrder(2)
                   ->setAction($mainAction)
                   ->setProvider($provider);
        $menuMain->save(); echo "Creado el menu Sistema para (".$provider->getName().")<br/>";
        $usersMenu = new Menu($orm);
        $usersMenu->setName('Usuarios')
                   ->setOrder(1)
                   ->setParent($menuMain)
                   ->setAction($NothingAction)
                   ->setIcon('users')
                   ->setProvider($provider);
        $usersMenu->save(); echo "Creado el menu Sistema->Usuarios para (".$provider->getName().")<br/>";
        $usersListMenu = new Menu($orm);
        $usersListMenu->setName('Listado')
                   ->setOrder(1)
                   ->setParent($usersMenu)
                   ->setAction($listUsersAction)
                   ->setIcon('users_edit')
                   ->setProvider($provider);
        $usersListMenu->save(); echo "Creado el menu Sistema->Usuarios->Listado para (".$provider->getName().")<br/>";
        $usersAddMenu = new Menu($orm);
        $usersAddMenu->setName('Agregar')
                   ->setOrder(2)
                   ->setParent($usersMenu)
                   ->setAction($addUserAction)
                   ->setIcon('users_add2')
                   ->setProvider($provider);
        $usersAddMenu->save(); echo "Creado el menu Sistema->Usuarios->Agregar para (".$provider->getName().")<br/>";
        $profilesMenu = new Menu($orm);
        $profilesMenu->setName('Perfiles')
                   ->setOrder(2)
                   ->setParent($menuMain)
                   ->setAction($NothingAction)
                   ->setIcon('message')
                   ->setProvider($provider);
        $profilesMenu->save(); echo "Creado el menu Sistema->Perfiles para (".$provider->getName().")<br/>";
        $profilesListMenu = new Menu($orm);
        $profilesListMenu->setName('Listado')
                   ->setOrder(1)
                   ->setParent($profilesMenu)
                   ->setAction($listProfilesAction)
                   ->setIcon('message_information')
                   ->setProvider($provider);
        $profilesListMenu->save(); echo "Creado el menu Sistema->Perfiles->Listado para (".$provider->getName().")<br/>";
        $profilesAddMenu = new Menu($orm);
        $profilesAddMenu->setName('Agregar')
                   ->setOrder(2)
                   ->setParent($profilesMenu)
                   ->setAction($addProfilesAction)
                   ->setIcon('message_add2')
                   ->setProvider($provider);
        $profilesAddMenu->save(); echo "Creado el menu Sistema->Perfiles->Agregar para (".$provider->getName().")<br/>";
        $actionsMenu = new Menu($orm);
        $actionsMenu->setName('Acciones')
                   ->setOrder(3)
                   ->setParent($menuMain)
                   ->setAction($NothingAction)
                   ->setIcon('star')
                   ->setProvider($provider);
        $actionsMenu ->save(); echo "Creado el menu Sistema->Acciones para (".$provider->getName().")<br/>";
        $actionsListMenu = new Menu($orm);
        $actionsListMenu->setName('Listado')
                   ->setOrder(1)
                   ->setParent($actionsMenu)
                   ->setAction($listActionsAction)
                   ->setIcon('star')
                   ->setProvider($provider);
        $actionsListMenu->save(); echo "Creado el menu Sistema->Acciones->Listado para (".$provider->getName().")<br/>";
        $actionsAddMenu = new Menu($orm);
        $actionsAddMenu->setName('Agregar')
                   ->setOrder(2)
                   ->setParent($actionsMenu)
                   ->setAction($addActionAction)
                   ->setIcon('star_add2')
                   ->setProvider($provider);
        $actionsAddMenu->save(); echo "Creado el menu Sistema->Acciones->Agregar para (".$provider->getName().")<br/>";
//Menu Cuenta
        $menuAccount = new Menu($orm);
        $menuAccount->setName('Cuenta')
                    ->setOrder(4)
                    ->setAction($AnnNothingAction)
                    ->setProvider($provider);
        $menuAccount->save(); echo "Creado el menu Cuenta para (".$provider->getName().")<br/>";
        $menuLogin = new Menu($orm);
        $menuLogin->setName('Login')
                   ->setOrder(1)
                   ->setAction($loginAction)
                   ->setParent($menuAccount)
                   ->setProvider($provider);
        $menuLogin->save(); echo "Creado el menu Login para (".$provider->getName().")<br/>";
        $menuLogout = new Menu($orm);
        $menuLogout->setName('Logout')
                   ->setAction($logoutAction)
                   ->setParent($menuAccount)
                   ->setOrder(2)
                   ->setDynamic(false)
                   ->setProvider($provider);
        $menuLogout->save(); echo "Creado el menu Logout para (".$provider->getName().")<br/>";
    }

    echo "</pre></body></html>";
    return true;
    // Bouml preserved body end 000A9505
  }

}
?>