<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class PrivateAccesor {
  /**
   * Retorna una referencia al atributo indicado.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @return mixed el valor del atributo solicitado
   */
  protected function &getAttribute($object, $name)
  {
    // Bouml preserved body begin 00068205
    return $object->$name;
    // Bouml preserved body end 00068205
  }

  /**
   * Invoca un mtodo pblico o protegido del objeto que se pasa por parmetro.
   * 
   * @param Object $object un objeto de la jerarqua de PrivateAccesor
   * @param string $method el nombre del mtodo a invocar
   * @param array $params un arreglo con los parmetros necesarios para invocar la funcin en el orden y nmero correcto
   * @return mixed retorna lo que devuelva la funcin invocada
   */
  protected function invokeMethod(&$object, $method, $params)
  {
    // Bouml preserved body begin 00068285
    return call_user_func_array(array($object, $method), $params);
    // Bouml preserved body end 00068285
  }

  /**
   * Actualiza un atributo protegido o pblico de un objeto.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @param mixed $value el nuevo valor de la propiedad
   * @return void
   */
  protected function setAttribute($object, $name, $value)
  {
    // Bouml preserved body begin 00072505
    $object->$name = $value;
    // Bouml preserved body end 00072505
  }

  /**
   * Invoca un mtodo pblico o protegido de la clase que se pasa por parmetro.
   * 
   * @param string $class la clase de la jerarqua de PrivateAccesor
   * @param string $method el nombre del mtodo a invocar
   * @param array $params un arreglo con los parmetros necesarios para invocar la funcin en el orden y nmero correcto
   * @return mixed retorna lo que devuelva la funcin invocada
   */
  protected function invokeStaticMethod($class, $method, &$params)
  {
    // Bouml preserved body begin 0007C485
    return call_user_func_array("$class::$method", $params);
//    return forward_static_call_array(array($class, $method), $params); CAMBIADO PARA ADAPTARLO AL PHP DEL SERVER
    // Bouml preserved body end 0007C485
  }

  /**
   * @static
   * Versin esttica de invokeMethod(); invoca un mtodo pblico o protegido del objeto que se pasa por parmetro.
   * @see PrivateAccessor::invokeMethod()
   * @param Object $object un objeto de la jerarqua de PrivateAccesor
   * @param string $method el nombre del mtodo a invocar
   * @param array $params un arreglo con los parmetros necesarios para invocar la funcin en el orden y nmero correcto
   * @return mixed retorna lo que devuelva la funcin invocada
   */
  public function stInvokeMethod(&$object, $method, $params)
  {
    // Bouml preserved body begin 0007DF05
    return call_user_func_array(array($object, $method), $params);
    // Bouml preserved body end 0007DF05
  }

}
?>