<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Almacena constantes de estado para que no entorpezcan la visualizacin de los objetos.
 * 
 * Estados relativos al ORM:
 *  * NEW = Cuando un objeto recin se crea. Este estado existe (aunque de movida hay una iteraccin con DatabaseObject y por consiguiente con el ORM) para que los objetos creados se guarden slo a travs de un llamado explicito a SAVE(). Sin embargo existe un flag en el ORM que usa DatabaseObject para bindear automticamente en el create.
 *  * ATTACHED = El objeto est siendo mantenido por ORM.
 *  * DETACHED = El objeto no est siendo mantenido por el ORM. Puede o no ser consistente con los datos de la base.
 * Estados del objeto:
 *  * DELETED = 
 * 
 * Pensamiento:
 * Doctrine maneja los estados tiene 4 que copi un poquitos ms claros: MANAGED, DETACHED, REMOVED y NEW. Pero al fin de cuentas un objeto est asociado o no con el ORM y lo dems es superfluo. No debera de interesar en particular si un objeto es nuevo o modificado, porque de esas inferencias se encarga el ORM.
 * El NEW en Doctrine significa que el objeto esta DETACHED y que no tiene contraparte en la base de datos. Cuando se hace un SAVE() pasa a MANAGED. Yo pienso que NEW no tiene sentido: en todo caso es DETACHED y cuando se guarda si tiene id es porque existia una contraparte y si no lo tiene es que es nuevo. Antes que digan nada, el id es un atributo privado de la clase DatabaseObject, con lo cual las clases hijas no lo pueden acceder, por lo cual es de total dominio del ORM.
 * El REMOVED es razonable, indica que el objeto no es recomendable para su uso, aunque sus valores an estn ahi en la memoria.
 */
interface ORM_STATUS {
  /**
   * @staticvar int ATTACHED indica que el objeto est siendo monitoreado por el ORM, lo cual quiere decir que los cambios sobre el mismo sern salvados sobre el COMMIT y que las acciones que se hagan al mismo tomarn estado de permanente.
   * @final
   */
  const ATTACHED = 1;

  /**
   * @staticvar int DETACHED indica que el objeto no est siendo mantenido por el ORM, los cambios y operaciones sobre el mismo no tendrn efecto.
   * @final
   */
  const DETACHED = 2;

  /**
   * @staticvar int REMOVED significa que el objeto est marcado para hacer un DELETE; es decir que est ATTACHED pero hasta el prximo COMMIT y que no tiene sentido modificar un objeto de ese tipo dado que pronto ser historia.
   * @final
   */
  const REMOVED = 3;

  /**
   * @staticvar int FRESH Valor que indica que el objeto es nuevo, es redundante con DETACHED + id==null, pero sirve para no tener que andar haciendo esas comparaciones
   * @final
   */
  const FRESH = 4;

  /**
   * @staticvar LOADING es un estado interno, solo empleado por el ORM que pone al objeto en un modo "suspendido" mientras puebla los atributos internos. Al salir de este estado el objeto "resetea" los flags de modificaciones.
   * @final
   */
  const LOADING = 5;

  const SAVING = 6;

}
?>