<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/PrivateAccesor.php';
require_once 'iplan/orm/ORMCollection.php';
require_once 'iplan/orm/LazyLoader.php';
require_once 'iplan/orm/ORM_STATUS.php';
require_once 'iplan/orm/exceptions/InternalError.php';
require_once 'iplan/orm/exceptions/DMLOperationFailed.php';
require_once 'iplan/orm/exceptions/ValueNotDefined.php';
require_once 'iplan/orm/exceptions/UnknowORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Se trata de una interfaz que implementa los mtodos necesarios para brindar servicios de almacenamiento y recuperacin del objeto en la base de datos
 * 
 * En conjunto con ORM y las clases auxiliares, dan una solucin integral para la gestin del mapeo relacional.
 * 
 */
abstract class ORMObject extends PrivateAccesor implements ORM_STATUS {
  static $definition;

  /**
   * @var int El identificador del objeto
   */
  public $id;

  /**
   * Un estado que puede ser:
   * NEW := NUEVO, es un objeto an no persistido en la base de datos, pero que de seguir la secuencia de eventos culminar insertandose en la base.
   * REMOVED := Es un objeto que se solicit para remocin de la base de datos. Es posible que alguna referencia quede apuntando a l y accediendo sus valores, pero los mismos deberan ser descartados. Posiblemente algn programa de LOG quiera ver como estaba al momento del DELETE o algo as.
   * REGISTERED := Significa que el objeto est persistido en la base de datos y que actualmente est bajo la vista del sistema ORM para preservar cualquier cambio.
   * UNREGISTERED := Significa que el objeto no est bajo seguimiento del Manager de ORM.
   */
  private $ORMState;

  /**
   * @var ORM $orm la instancia de ORM que est gerenciando el objeto o null
   */
  private $orm;

  /**
   * @var array un arreglo en el cual se almacenarn los campos modificados
   */
  private $ORMModifieds;

  public function __destroy()
  {
    // Bouml preserved body begin 00027D05
    /*@todo HACER ESTO BIEN
      if (($this->ORMState == ORM_STATUS::ATTACHED) && $this->isModified() && $this->orm->getAuto...) {
        $this->save();
    }*/
    // Bouml preserved body end 00027D05
  }

  /**
   * Constructor predeterminado de los objetos derivados del ORM. Recibe opcionalmente una instancia del ORM al cual se desea que se registre la instancia. Esto afecta el estado y si la instancia desde su nacimiento va a ser monitoreada por el ORM.
   * @param ORM $orm una instancia del ORM que va a monitorear el objeto.
   * @return ORMObject la instancia del objeto
   */
  public function __construct(&$orm = null)
  {
    // Bouml preserved body begin 0002B385
    $definition = "";
    if (!is_null($orm)) {
        if ($orm->getBindObjectsOnCreate()) {
            $orm->attach($this);
        }
        $this->orm=$orm;
        $definition = $orm->getDefinition(get_class($this));
    } else {
        $this->ORMState = ORM_STATUS::FRESH;
        $definition = self::define();
    }
    $fields = $definition->getFieldDefinition();
    if (is_array($fields)) {
        foreach($fields as $attribute=>$map) {
            $this->$attribute = $map['default'];
        }
    }

    if ($relations = $definition->getRelationDefinition()) {
        foreach($relations as $attribute=>$map) {
            $this->$attribute = null;//new ORMCollection();
        }
    }

    $this->id = null;
    $this->ORMModifieds=null;
    // Bouml preserved body end 0002B385
  }

  /**
   * ANULADO POR AHORA. Devuelve TRUE si la variable existe.
   * 
   * @param string $variablename el nombre de la variable.
   * 
   * @return boolean Retorna TRUE si la variable se encuentra definida o FALSE sino.
   */
  public function isset__($variablename)
  {
    // Bouml preserved body begin 000B9C05
    return property_exists(get_class($this), $variablename);
    // Bouml preserved body end 000B9C05
  }

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param ORM $orm el manejador de ORM para el cual se registra la clase
   * @return \orm\ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00046585
    return new ORMDefinition($orm);
    // Bouml preserved body end 00046585
  }

  /**
   * Borra fsicamente un objeto de la base. Al borrarse el objeto adems se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relacin M:N
   * 
   * @return boolean un booleando TRUE si la operacin fue concretada con xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 00029985
    if (!is_null($this->orm)) {
        if (!is_null($this->id)) {
            $db = $this->orm->getDatabase();
            //Inicio el ciclo de borrado eliminando primero las referencias directas de las relacions 1:1, 1:N y M:N
            $definition = $this->orm->getDefinition(get_class($this));
            $relationsDefs = $definition->getRelationDefinition();
            foreach($relationsDefs as /*$attribute => */$relationMap) {
                //Recupero la definición de la clase del otro extremo de la relación
                $targetClassDefinition = $this->orm->getDefinition($relationMap['class']);
                switch($relationMap['type']) {
                    case ORM_RELATION_TYPE::OneToOne:
                    case ORM_RELATION_TYPE::OneToMany:
                        //Guardo la definición de la clave primaria de la clase objetivo
                        $targetIdDefinition = $targetClassDefinition->getFieldDefinition('id');
                        //Busco en la tabla de la clase objetivo todos los IDs que apunten al objeto a borrar
                        $relatedIds = $db->filter($targetIdDefinition['table'], array($targetIdDefinition['fieldName']),
                                                  array($db->makeCondition('=', $relationMap['fieldName'], $this->getId())));
                        //Si hay IDs entonces...
                        if ($relatedIds != false) {
                            $listOfIds = array();
                            //Para cada uno me fijo si está cargado, si lo está disocio el objeto (en memoria)
                            foreach($relatedIds as $key=>$relId) {
                                if ($relatedObject = $this->orm->retrieve($relationMap['class'], $relId[$targetIdDefinition['fieldName']])) {
                                    //Esto no provoca que el estado del objeto se altere (es decir, no queda "Modified")
                                    $this->setAttribute($relatedObject, $relationMap['fieldName'], null);
                                    //Nota: no busco el LazyLoad, porque dejar que el LazyLoad traiga NULL es innecesario,
                                    //también evito que algún llamado reinicialize el valor antes de que yo elimine.
                                }
                                $listOfIds[]=$relId;
                            }
                            //Actualizo todos los registros relacionados poniendo en null el valor que referenciaba el objeto
                            $db->update($targetIdDefinition['table'],
                                        array($relationMap['fieldName']=>null),
                                        array($db->makeCondition("IN", $targetIdDefinition['fieldName'], $listOfIds)));
                        }
                        break;
                    case ORM_RELATION_TYPE::ManyToMany:
                        //Recuperar ids de objetos relacionados a través de la tabla intermedia
                        $relatedIds = $db->filter($relationMap['table'], array($relationMap['associatedFieldName']),
                                              array($db->makeCondition('=', $relationMap['fieldName'], $this->getId())));
                        //Si hay Ids entonces...
                        if ($relatedIds != false) {
                            $listOfIds = array();
                            $relationDef = $targetClassDefinition->getRelationDefinition($relationMap['table'], true);
                            foreach($relatedIds as $key=>$relId) {
                                $listOfIds[]=$relId;//...lo guardo y...
                                // Lo muevo arriba $relationDef = $targetClassDefinition->getRelationDefinition($relationMap['table'], true);
                                //...chequeo si el objeto relacionado ya está en memoria...
                                if ($relatedObject = $this->orm->retrieve($relationMap['class'], $relId[$relationMap['associatedFieldName']])) {
                                    if ($this->orm->getDebug()) echo "Se ha encontrado que el objeto ".$relationMap['class'].":".$relatedObject->getId()."\n";
                                    //...si está, entonces busco cuál es la relación que tiene con el objeto a borrar...
                                    $collection = $this->getAttribute($relatedObject, $relationDef['attribute']);
                                    if ($this->orm->getDebug()) echo "Se ha encontrado que el objeto ".$relationMap['class'].":".$relatedObject->getId()."\n";
                                    //... si la relación es una Collection quiere decir que hay que actualizarla preservando su estado...
                                    if (is_a($collection, 'ORMCollection')) {
                                        $reset = $collection->isModified();
                                        if ($this->orm->getDebug()) echo $this->getDescription().": Buscando ".$this->getId().":\n";
                                        foreach($collection as $key=>$value) {
                                            if ($this->orm->getDebug()) echo "    ".$relationMap['class'].".".$relationDef['attribute']."[$key]=".$value->getId()."\n";
                                            if ($value->getId() == $this->getId()) {//Antes $value->getId() == $relId
                                                if ($this->orm->getDebug()) echo "    Eliminando offset[$key]\n";
                                                $collection->offsetUnset($key);
                                                break;
                                            }
                                        }
                                        if ($reset) $collection->reset();
                                    }
                                }
                            }
                            $delResult = $db->delRelation($relationMap['table'], array($relationMap['fieldName']=> $this->id) );
                            if ($delResult === false) {
                                throw new DMLOperationFailed('Error al eliminar registros de '.$relationMap['table'].' [atributo: '.get_class($this).'::'.$relationDef['attribute'].']');
                                return false;
                            }
                        }
                        break;
                    default:
                        throw new ORMDefinitionError('La definición de la clase "'.get_class($this).'" usa un tipo incorrecto para la relación "$attribute"');
                        return false;
                }

            }

            //Luego recorro las definiciones de tablas pero a la inversa y borrando los registros
            $attByTableDef = array_reverse(array_keys($definition->getFieldsByTable()), true);
            foreach($attByTableDef as $table) {
                $db->delete($table, $this->id);
            }

            //Finalmente disocio el objeto del ORM
            $this->orm->dettach($this);
            $this->id=null;
            return true;
        } else {
            throw new InternalError("No se puede borrar una instancia nunca persistida (guardada)");
            return false;
        }
    } else {
        throw new UnknowORM("No hay un ORM configurado para esta instancia");
        return false;
    }
    // Bouml preserved body end 00029985
  }

  /**
   * Recupera una instancia de la clase desde la base de datos. Este mtodo adems calcula el hash en base a los atributos. En combinacin con el mtodo save() permite abstraer a las clases subyacentes de la necesidad de determinar si el objeto fue alterado o no y si corresponde guardarlo.
   * Finalmente este mtodo registra el objeto en el ORM para su mantenimiento automtico.
   * @param $id int el identificador del objeto a recuperar
   * @param $orm ORM el gestor que solicita el objeto
   * @param string $class la clase que se quiere cargar. Si se omite se toma la clase invocada en forma predeterminada
   * @return ORMObject una instancia con los valores precargados
   * 
   * @todo prestar atencin en el LOAD que si se hace una carga de objetos masiva, es necesario verificar que los mismos no esten PRE registrados en el ORM o si lo estn y los hash no son los mismos enviar alguna excepcin al usuario.
   */
  public static function &load($id, &$orm, $class = "")
  {
    // Bouml preserved body begin 00027C85

    if ($class=="") $class=get_called_class ();

    //Primero intento recuperarlo de la caché:
    if (is_object($cacheObj = $orm->retrieve($class, $id))) {
        if (!$cacheObj->isModified()) {
            return $cacheObj;
        } else {
            throw new InstanceNotSaved("No se puede cargar desde base un objeto existente y modificado");
        }
    }
    //Si no estaba en caché, creo la instancia a inicializar
    $object = new $class($orm);
    $object->setORMState(ORM_STATUS::LOADING);

    //Obtengo la base de datos y las definiciones
    $conn = $orm->getDatabase();
    $definition = $orm->getDefinition($class);

    //Primero recupero los atributos directos, recorriendo los mismos por tabla
    $defByTables = $definition->getFieldsByTable();
    foreach($defByTables as $table=>$tableMaps) {
        unset($fields);
        unset($entities);
        //Elijo qué campos voy a traer de la base de datos, cuáles serán
        //cargados en forma dinámica (LAZY) y cuáles son entidades enteras.
        foreach($tableMaps as $attribute=>$attDefinition) {
            //Si el atributo es un elemento básico lo cargo,
            switch (true) {
                //Si es Lazy creo el objeto y listo
                case $attDefinition['loadStyle']==ORM_LOAD_STYLE::LAZY_LOAD:
                    $method = self::setter($attribute);
                    $object->$method(new LazyLoader($object, $attribute, $orm));
                    break;
                //Si es una entidad, marco que se tiene que cargar la misma
                //después de recuperar el id, por ello dejo que pase y que
                //agregue el fieldName a la lista de fields
                case $attDefinition['type']==ORMDefinition::ORM_ENTITY:
                    $entities[$attribute]=$attDefinition;
                //Si no es ningún caso anterior es un atributo valor común
                default:
                    $fields[$attribute]=$attDefinition['fieldName'];
            }
        }
        //Recupero los datos de la base
        if ($data = $conn->getData($table, $id, $fields)) {
            //Para cada valor recuperado, lo configuro en el atributo correspondiente
            foreach($fields as $attribute => $fieldName) {
                //Verifico que el atributo no sea de una entidad, dado que setearlo es de gusto
                if (!isset($entities[$attribute])) {
                    $method = self::setter($attribute);
                    //Para cada atributo realizo la conversión de datos pertinente
                    $object->$method($conn->db2php($data[$fieldName], $tableMaps[$attribute]['type']));
                }
            }
            //Si hay entidades a cargar...
            if (isset($entities)) {
                //...las cargo y las asigno, de a una por vez
                foreach($entities as $attribute => $attDefinition) {
                    if (!is_null($data[$attDefinition['fieldName']])) {
                        $method = self::setter($attribute);
                        $object->$method($orm->load($attDefinition['class'], $data[$attDefinition['fieldName']]));
                    }
                }
            }
        } else {
            $error = "Error al invocar a ".get_class($conn)."->getData($table, $id, array(";
            foreach($fields as $field) $error .= $field . ", ";
            $error .= ") en $class ->load($id)\n";
            throw new InternalError($error);
        }

    }

    //Luego recupero las relaciones
    if ($relations = $definition->getRelationDefinition()) {
        foreach($relations as $attribute => $relationMap) {
            $method = self::setter($attribute);
            if ($relationMap['loadStyle']==ORM_LOAD_STYLE::LAZY_LOAD) {
                $object->$method(new LazyLoader($object, $attribute, $orm));
            } else {
                //@todo cargar la relación ya ya ya
                //Si bien podría hacer todo de una, la verdad que mejor concentrar el código en un solo lado
                $tmp = new LazyLoader($object, $attribute, $orm);
                $object->$method($tmp->load());
            }
        }
    }
    //Indico que el objeto a partir de ahora es monitoreado por el ORM
    //self::stInvokeMethod($object, "setORMState", array(ORM_STATUS::ATTACHED));
    $orm->attach($object);
    
    return $object;
    // Bouml preserved body end 00027C85
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este mtodo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto slo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar una excepcin.
   * 
   * Se pens en que se podra hacer el cambio de un ORM a otro, pero el ID debera limpiarse, con lo cual slo un INSERT se podra hacer sobre el destino y los objetos relacionados estaran an con otro ORM lo cual es complicado (manejo de objetos distribudos) por lo cual se deja a consideracin de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 00026285

    //Chequeo que haya un ORM:
    if (is_null($orm)) {
        if (is_null($this->orm)) {
            throw new UnknowORM("No se ha pasado el ORM al método save()");
        } else {
            if ($this->ORMState==ORM_STATUS::SAVING) {
                if ($this->orm->getDebug()) echo "Detectado ".get_class($this).":".$this->id." Estado: ".$this->ORMState." (SAVING) => Omitiendo\n";
                return true;//Quiere decir que ya se está guardando...
            } else {
                $orm = $this->orm;
                if (is_null($this->id))  $this->ORMState = ORM_STATUS::FRESH;
                if ($this->orm->getDebug()) echo "Detectado ".get_class($this).":".$this->id." Estado: ".$this->ORMState."\n";
            }
        }
    } else {//Si cambio o configuro por primera vez el ORM, se asume que no hay nada consolidado
            //Si el ORM es el mismo está todo bien :)
            //Que sea nuevo significa que, entre otras cosas, no tiene ID.
            //Obvio que se puede poner el ID del objeto, pero el hecho que sea FRESH significa
            //que cualquiera sea el ID, el mismo será pisado y el objeto totalmente insertado.
        if ($this->ORMState==ORM_STATUS::SAVING) {
            if ($this->orm != $orm) throw new InternalError("Se disparó una cadena de 'guardados' con ORM diferentes");
            else return true;
        }

        if (($this->orm != $orm) || (is_null($this->id))) {
            $this->orm = $orm;
            $this->ORMState = ORM_STATUS::FRESH;
            $this->id = null;
        }
    }

    $db = $orm->getDatabase();
    $definition = $orm->getDefinition(get_class($this));

    //Hago el chequeo de que todos los atributos definidos como requeridos (no nulleables) tengan valor
    foreach($definition->getFieldDefinition() as $attribute => $attDefinition) {
        if (($attribute != 'id') && (!$attDefinition['isNulleable']) && (is_null($this->$attribute)))
                throw new ValueNotDefined("El atributo \"$attribute\" (".$attDefinition['table'].".".$attDefinition['fieldName'].") no puede ser null");
    }

    if ($this->orm->getDebug()) echo "...pasa por aquí y comparo: ".$this->ORMState."=".ORM_STATUS::FRESH."\n";

    //Si es nuevo hay que guardar todo, sino hay que seleccionar
    if (($this->ORMState == ORM_STATUS::FRESH)) {
        if ($this->orm->getDebug()) echo "...pasa por NUEVO\n";

        //Marco como guardando el objeto:
        $this->ORMState = ORM_STATUS::SAVING;

        //Primero los atributos directos
        $byTableDefinition = $definition->getFieldsByTable();
        //Para cada tabla
        $first=true;
        foreach($byTableDefinition as $table => $definitionsMap) {
            //Para cada atributo de la tabla
            foreach($definitionsMap as $attribute => $attDefinition) {
                //Determino el getter porque el valor se trae sí o sí (es nuevo)
                $getMethod = $this->getter($attribute);
                //Si es un objeto
                if ($attDefinition['type']==ORM_TYPES::ORM_ENTITY) {
                    $obj = $this->$getMethod();
                    //Me fijo si está seteado y en ese caso traigo su ID, pero antes chequeo que lo tenga
                    if (!is_null($obj)) {
                        if (is_null($obj->getId())) $obj->save($orm);//...o sino lo guardo antes
                        $fields[$attDefinition['fieldName']]=$obj->getId();
                    } else $fields[$attDefinition['fieldName']]=$db->php2db(null, $attDefinition['type']);
                //Si no es un objeto traigo el valor directo a través del get() para asegurarme el valor
                //y lo convierto si hace falta a un formato que la base de datos entienda
                } else {
                    $fields[$attDefinition['fieldName']]=$db->php2db($this->$getMethod(), $attDefinition['type']);
                }
            }
            //Si es la primer tabla inserto y recupero el id
            if ($first) {
                unset($fields[$definitionsMap['id']['fieldName']]);//Quito el ID porque no corresponde
                $this->id=$db->insert($table, $fields);
                $first=false;
            //Si es una tabla secundaria pongo el id principal e inserto sin usar generadores
            } else {
                $fields[$definitionsMap['id']['fieldName']]=$this->id;
                $this->id=$db->insert($table, $fields, false);
            }
        }
        //...y luego relaciones
        $relationsMap = $definition->getRelationDefinition();
        //A diferencia del UPDATE, acá se recuperan sí o sí las relaciones porque es nuevo y por cada relación...
        if ($relationsMap) {
            foreach($relationsMap as $attribute => $relDefinition) {
                //Determino el getter porque el valor se trae sí o sí (es nuevo)
                $getMethod = $this->getter($attribute);
                $collection = $this->$getMethod();
                if (is_a($collection, 'ORMCollection')) {
                    $targetDefinition = $orm->getDefinition($relDefinition['class']);
                    //Recorro y guardo todos los objetos
                    //Luego reseteo el flag de modificado de la colección
                    if ($relDefinition['type'] == ORM_RELATION_TYPE::ManyToMany) {
                        //La lógica es:
                        //1) Guardo el objeto con el nuevo ORM
                        //   -- Esto produce que se guarde incluso llama al save
                        $targetRelDefinition = $targetDefinition->getRelationDefinition($relDefinition['table'], true);
                        foreach($collection as $keyObj => $obj) {
                            $collection[$keyObj]->save($orm);
                            $db->addRelation($relDefinition['table'], array($relDefinition['fieldName']=>$this->id,
                                                                            $relDefinition['associatedFieldName']=>$collection[$keyObj]->getId()));
                            //Agregar el objeto actual a la colección del target y resetearla (así evitamos la alteración)
                            $targetCollection = $this->getAttribute($collection[$keyObj], $targetRelDefinition['attribute']);
                            //Si es null, le cargo una nueva colección
                            //En el caso del LazyLoader lo dejo porque estando los registros en la base, al cargarse
                            //la propiedad se va a recuperar correctamente.
                            //Si es collection agrego los elementos actuales.
                            if (is_null($targetCollection)) {
                                $this->setAttribute($collection[$keyObj], $targetRelDefinition['attribute'], new LazyLoader($collection[$keyObj], $targetRelDefinition['attribute'], $orm));
                            } else {
                                if (is_a($targetCollection, 'ORMCollection')) {
                                        $targetCollection[]=$this;
                                        $targetCollection->reset();
                                }
                            }
                        }
                    } else {
                        $targetAttDefinition = $targetDefinition->getFieldDefinition($relDefinition['fieldName'], true);
                        $targetMethod = $this->setter($targetAttDefinition['attribute']);
                        foreach($collection as $keyObj=>$obj)
                            $collection[$keyObj]->$targetMethod($this)->save($orm);
                    }
                    $collection->reset();
                }
            }
        }
    } else if ($this->isModified()) {
        if ($this->orm->getDebug()) echo "...pasa por GUARDADO\n";

        //Marco como guardando el objeto:
        $this->ORMState = ORM_STATUS::SAVING;
        //Primero verifico y guardo los atributos:
        if (!is_null($this->ORMModifieds)) {
            //Para cada atributo
            foreach(array_keys($this->ORMModifieds) as $attribute) {
                $attMap = $definition->getFieldDefinition($attribute);
                //Verifico que no sea un atributo "objeto", en cuyo caso traigo el ID en vez del valor...
                //...pero para asegurar eso verifico que el objeto tenga un ID, sino lo guardo antes.
                if ($attMap['type']==ORM_TYPES::ORM_ENTITY) {
                    if (!is_null($this->$attribute)) {//Si no es nulo entonces DEBE ser un ORMObject
                        if (is_null($this->$attribute->getId())) $this->$attribute->save($orm);
                        $fieldsToSave[$attMap['table']][$attMap['fieldName']]=$this->$attribute->getId();
                    } else {
                        $fieldsToSave[$attMap['table']][$attMap['fieldName']]=null;
                    }
                } else
                    $fieldsToSave[$attMap['table']][$attMap['fieldName']]=$db->php2db($this->$attribute, $attMap['type']);
                    //Nota: el atributo se pone directamente porque si está modificado no puede ser un LazyLoader.
            }

            //Finalmente se guardan los cambios
            foreach($fieldsToSave as $table => $fields) {
                $fields['id'] = $this->id;
                $db->update($table, $fields);
            }
        }
        //...y luego relaciones

        $relationsMap = $definition->getRelationDefinition();

        //Para guardar las relaciones se asume que aquellas que están como LazyObjects no son
        //objeto de modificación.
        foreach($relationsMap as $attribute => $relDefinition) {
            $collection = &$this->$attribute;
            if (is_a($collection, 'ORMCollection')) {
                $targetDefinition = $orm->getDefinition($relDefinition['class']);
                if ($collection->isModified()) {
                    if ($relDefinition['type'] == ORM_RELATION_TYPE::ManyToMany) {
                        //Pedir la definición de la relación en el target, buscando por tabla
                        $targetRelDefinition = $targetDefinition->getRelationDefinition($relDefinition['table'], true);

                        //Para los objetos agregados, tiene sentido guardarlos si es necesario
                        $added = $collection->getAdded();
                        if (is_array($added))
                            foreach($added as $keyObj=>$obj) {
                                if ($this->orm->getDebug()) echo "Hay agregado el elemento ".get_class($obj).":".$obj->getId()."\n";
                                //Tomar el ID del objeto target (guardarlo si no tiene ID o está modificado)
                                if (is_null($obj->getId()) || $obj->isModified()) $added[$keyObj]->save($orm);
                                //Con el id local y el del target se agrega la relación a la tabla
                                $db->addRelation($relDefinition['table'], array($relDefinition['fieldName']=>$this->id,
                                                                                $relDefinition['associatedFieldName']=>$added[$keyObj]->getId()));
                                //Agregar el objeto actual a la colección del target y resetearla (así evitamos la alteración)
                                $targetCollection = $this->getAttribute($added[$keyObj], $targetRelDefinition['attribute']);
                                if (is_a($targetCollection, 'ORMCollection')) {
                                    //Si la colección no ha sido modificada antes, puedo resetear el estado
                                    if ($targetCollection->isModified()) {
                                        $targetCollection[]=$this;
                                    } else {
                                        $targetCollection[]=$this;
                                        $targetCollection->reset();
                                    }
                                }
                            }
                        //Para los objetos "desvinculados" sólo se actualiza el estado de la colección
                        //y el objeto queda en el estado en que está
                        $removed = $collection->getRemoved();
                        if (is_array($removed))
                            foreach($removed as $keyObj => $obj) {
                                if ($this->orm->getDebug()) echo "Se removi&oacute; el elemento ".get_class($obj).":".$obj->getId()."\n";
                                //Si es null, no hay nada que hacer porque nunca llego a una tabla
                                if (!is_null($obj->getId())) {
                                    //Remuevo la relación de la tabla
                                    $db->delRelation($relDefinition['table'], array($relDefinition['fieldName']=> $this->id, $relDefinition['associatedFieldName']=> $obj->getId()));
                                    $targetCollection = $this->getAttribute($removed[$keyObj], $targetRelDefinition['attribute']);
                                    if (is_a($targetCollection, 'ORMCollection')) {
                                        $myKey = null;
                                        foreach($targetCollection as $key => $value)
                                            if ($value->getId()==$this->id) { $myKey = $key;break;}
                                        //Chequeo si puedo o no hacer un reset
                                        if ($targetCollection->isModified()) {
                                            $targetCollection->offsetUnset($myKey);
                                        } else {
                                            $targetCollection->offsetUnset($myKey);
                                            $targetCollection->reset();
                                        }
                                    }
                                }
                            }
                    } else {
                        //Buscar el atributo en la contraparte y lo cambio con el setter adecuado,
                        $targetAttDefinition = $targetDefinition->getFieldDefinition($relDefinition['fieldName'], true);
                        $targetMethod = $this->setter($targetAttDefinition['attribute']);

                        //Asignarle $this como valor y guardarlo.
                        //-- Al guardar el objeto solito toma mi ID y se actualiza
                        $added=$collection->getAdded();
                        foreach($added as $keyObj => $obj)
                            $added[$keyObj]->$targetMethod($this)->save($orm);

                        //Asignarle NULL como valor y guardarlo.
                        $removed = $collection->getRemoved();
                        foreach($removed as $keyObj => $obj)
                            $removed[$keyObj]->$targetMethod(null)->save($orm);
                    }
                    
                    //Finalmente reseteo la colección
                    $collection->reset();
                }
            }
        }
    } else {
        //Evito que se haga el attach() y el reset del array dado que no hay nada que tocar
        return true;
    }

    //Indico que el objeto a partir de ahora es monitoreado por el ORM
    //-- Esto también quita el estado SAVING
    $orm->attach($this);
    $this->ORMModifieds=null;

    return true;
    // Bouml preserved body end 00026285
  }

  /**
   * @todo ELIMINAR ESTA FUNCIN
   * 
   * Retorna un arreglo de todos los atributos pblicos y protegidos del objeto (adems de algunos privados). Es para debug, no debe quedar en el objeto.
   * 
   * @return array La lista de los atributos
   */
  public function getAttributes()
  {
    // Bouml preserved body begin 0007DE85
    return get_object_vars($this);
    // Bouml preserved body end 0007DE85
  }

  final public function getId()
  {
    return $this->id;
  }

  protected function setId($value)
  {
    $this->id = $value;
  }

  final public function getORMState()
  {
    return $this->ORMState;
  }

  protected function setORMState($value)
  {
    $this->ORMState = $value;
  }

  /**
   * Indica si el objeto ha sufrido modificacin en sus atributos. Debe destacarse que los atributos directos del objeto son los que participan de esta comprobacin, por lo que las modificaciones en objetos asociados no son tenidas en cuenta.
   * 
   * @return boolean true si el objeto ha sido mofificado y falso sino.
   */
  public function isModified()
  {
    // Bouml preserved body begin 00078E05
    //El chequeo de modificaciones se hace en dos pasos:
    //   1) Campos comunes
    //   2) Relaciones
    //Si ya sabemos que hay campos modificados, devuelvo true directamente.
    //Si no hay campos comunes, entonces verifico las relaciones y devuelvo el resultado
    $isModified = (!is_null($this->ORMModifieds));//Esto no debería aplicar: || (count($this->ORMModifieds)==0);
    if (!$isModified) {
        if (isset($this->orm))
            $relations = $this->orm->getDefinition(get_class($this))->getRelationDefinition();
        else
            $relations = self::define()->getRelationDefinition();
        if ($relations) {
            $relations = array_keys($relations);
            foreach($relations as $attribute) {
                //Si la relación aún no fue cargada entonces no pudo haber sido modificada
                if (is_a($this->$attribute, 'ORMCollection')) {
                    $isModified = $isModified || $this->$attribute->isModified();
                }
            }
        }
    }
    return $isModified;
    // Bouml preserved body end 00078E05
  }

  /**
   * En el caso de los objetos que ya estn en base, vuelve a recargar la instancia con los valores de la base.
   * @return boolean true si la recarga fue realizada con xito o false sino
   */
  public function reload()
  {
    // Bouml preserved body begin 00078E85
    // Bouml preserved body end 00078E85
  }

  /**
   * Resetea todos los indicadores de cambios del objetos, asumiendo que el estado actual es el de la base de datos si es que est monitoreado.
   */
  private function reset()
  {
    // Bouml preserved body begin 0007AA05
    $this->ORMModifieds=null;
    // Bouml preserved body end 0007AA05
  }

  /**
   * Magic Method sobreescrito para monitorear los pedidos a getXXX() y setXXX().
   * @param string $method el mtodo invocado
   * @prama array $args la lista de argumentos pasados como parmetro
   * @return mixed|exception si se ejecuta un getXXX se verifica que los argumentos sean vacios y si se ejecuta cun setXXX se chequea que slo un argumento sea pasado. Todo lo dems arroja una excepcin en runtime.
   */
  public function __call($method, $args)
  {
    // Bouml preserved body begin 0007AA85
    $methodStart = substr($method, 0, 3);
    //Parche para Twig: si se llama a una propiedad como método, se asume "get" + propiedad.
    if (!in_array($methodStart, array('get', 'set', 'add', 'del'))) {
        $methodStart = 'get';
        $propertyName = $method;
    } else {
        $propertyName = substr($method, 3);
    }

    if(strlen($propertyName) > 0) $propertyName[0]=strtolower($propertyName[0]);
    switch ($methodStart) {
        case "get":
                    if (property_exists(get_class($this), $propertyName)) {
                        if (is_a($this->$propertyName, 'LazyLoader')){
                            $this->$propertyName = $this->$propertyName->load();
                        }
                        return $this->$propertyName;
                    }
                    //En caso que no sea una propiedad nativa, puede ser que se intente acceder a un elemento de un array
                    $propertyName2 = $this->pluralize($propertyName);
                    if (property_exists(get_class($this), $propertyName2)) {
                        if (is_a($this->$propertyName2, 'LazyLoader')){
                            $this->$propertyName2 = $this->$propertyName2->load();
                        }
                        foreach($this->$propertyName2 as $key => $value) {
                            if ($value->getId() == $args[0]) {
                                return $value;
                            }
                        }
                    } else {
                        throw new UnknowAttribute("No se conoce el atributo ".get_class($this)."::$propertyName - fallo en llamado a $method");
                    }
                    break;
        case "set":
                    if (property_exists(get_class($this), $propertyName)) {
                        $this->$propertyName = $args[0];
                        if ($this->ORMState == ORM_STATUS::ATTACHED)
                            $this->ORMModifieds[$propertyName]=true;
                        return $this;
                    } else {
                        throw new UnknowAttribute("No se conoce el atributo ".get_class($this)."::$propertyName - fallo en llamado a $method");
                    }
                    break;
        case "add":
                    $propertyName2 = $this->pluralize($propertyName);
                    if (property_exists(get_class($this), $propertyName2)) {
                        if (is_a($this->$propertyName2, 'LazyLoader'))
                            $this->$propertyName2 = $this->$propertyName2->load();
                        if (is_null($this->$propertyName2))
                            $this->$propertyName2 = new ORMCollection();
                        $array = &$this->$propertyName2;
                        $array[]=$args[0];
                        return $this;
                    }
                    break;
         case "del":
                    $propertyName2 = $this->pluralize($propertyName);
                    if (property_exists(get_class($this), $propertyName2)) {
                        if (is_a($this->$propertyName2, 'LazyLoader'))
                            $this->$propertyName2 = $this->$propertyName2->load();
                        if (!is_null($this->$propertyName2)) {
                            foreach($this->$propertyName2 as $key => $value) {
                                if ($value === $args[0]) {
                                    $this->$propertyName2->offsetUnset($key);
                                    return $value;
                                }
                            }
                        }
                        return false;
                    }
                    break;
        default:

    }
    // Bouml preserved body end 0007AA85
  }

  /**
   * Genera el string correspondiente al setter del atributo. Por ejemplo: setter('miNombre') = 'setMiNombre'.
   * 
   * @param string $attribute el nombre del atributo.
   * 
   * @return string el nombre del mtodo setter que le corresponde
   */
  private static function setter($attribute)
  {
    // Bouml preserved body begin 00084785
    return "set".strtoupper($attribute[0]).substr($attribute, 1);
    // Bouml preserved body end 00084785
  }

  /**
   * Genera el string correspondiente al getter del atributo. Por ejemplo: getter('miNombre') = 'getMiNombre'.
   * 
   * @param string $attribute el nombre del atributo.
   */
  private static function getter($attribute)
  {
    // Bouml preserved body begin 00084805
    return "get".strtoupper($attribute[0]).substr($attribute, 1);
    // Bouml preserved body end 00084805
  }

  /**
   * Retorna el plural de un nombre de atributo.
   * 
   * @param string $attribute el nombre de atributo que queremos poner el plural
   * 
   * @return string el nombre el plural.
   */
  protected static function pluralize($attribute)
  {
    // Bouml preserved body begin 00086305

    //Veo si es irregular: http://oyoko.org/English_plural_exceptions
    $irregulars = array('man'=>'men', 'woman'=>'women', 'child'=>'children', 'mouse'=>'mice', 'goose'=>'geese',
                        'ox'=>'oxen', 'tooth'=>'teeth', 'foot'=>'feet', 'deer'=>'deer', 'sheep'=>'sheep');
    if (isset($irregulars[$attribute])) return $irregulars[$attribute];


    //Ver reglas en http://www.aprende-gratis.com/ingles/curso.php?lec=plural
    $lastTwo = substr($attribute, strlen($attribute)-2);
    $last = $lastTwo[1];
    
    //Si termina en s, x, ch o sh se agrega "es"
    //Lo mismo si termina en "o"
    if (in_array($lastTwo, array("sh", "ch")) || in_array($last, array('s', 'z', 'x')) || ($last == 'o')) {
        return $attribute . "es";
    }

    //Si termina en f o fe se reemplaza por v y se agrega es
    if ($last=='f') return substr($attribute, 0, strlen($attribute)-1) . "ves";
    if ($lastTwo=='fe') return substr($attribute, 0, strlen($attribute)-2) . "ves";


    //Si termina en vocal o y se agrega "s", salvo que antes de la y haya una consonante
    //en cuyo caso se reemplaza la y por ies
    $vowels = array('a', 'e', 'i', 'o', 'u');
    if (in_array($last, $vowels)) {
        return $attribute . "s";
    }
    if (($last == 'y') && (!in_array($lastTwo[0], $vowels))) {
        return substr($attribute, 0, strlen($attribute)-1) . "ies";
    }

    //En forma predeterminada agrego una "s" al final
    return $attribute . "s";
    // Bouml preserved body end 00086305
  }

}
?>