<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Sirve para almacenar una colecci�n de objetos relacionados. Es decir para materializar las relaciones entre objetos.
 * 
 * En alg�n punto la colecci�n involucra dos partes:
 *  * La relaci�n en s�
 *  * El objeto del extremo de la relaci�n
 * 
 * El objeto del extremo es una clase que tiene adem�s sus capacidades de ORM.
 * 
 * La relaci�n es el otro tema, la misma se puede dar de dos maneras:
 *  * Caso N:M => se relaciona a trav�s de una tabla.
 *  * Caso 1:N => se relaciona a trav�s de un atributo en la tabla relacionada.
 *  * Caso 1:1 => se relaciona a trav�s de un atributo en la tabla relacionada.
 */
class ORMCollection implements ArrayAccess, IteratorAggregate, Countable {
  /**
   * @var array lista de los elementos (instancias) de la relaci�n
   * 
   * @todo PONERLO PRIVADO!! Ahora P�blico a fines de DEBUG!
   */
  public $elements;

  /**
   * @var array aqu� se mantienen temporalmente una lista de los identificadores de los objetos nuevos
   */
  public $added;

  /**
   * @var array en este arreglo se guarda la lista de ids de objetos quitados de la relaci�n, para que al guardar se puedan saber qu� registros de la relaci�n quitar
   */
  public $removed;

  /**
   * Devuelve un booleano indicando si la colecci�n ha sido o no modificada
   * 
   * @return bool un valor TRUE si la colecci�n fue modificada o FALSE sino
   */
  public function isModified()
  {
    // Bouml preserved body begin 00082B85
    return ((count($this->added) > 0) || (count($this->removed) > 0));
    // Bouml preserved body end 00082B85
  }

  /**
   * Retorna la direcci�n de una posici�n del array de atributos.
   * 
   * @param string|int $offset la clave del arreglo de elementos del cual se quiere saber la direcci�n
   */
  public function &address($offset)
  {
    // Bouml preserved body begin 00064E05
    return $this->elements[$offset];
    // Bouml preserved body end 00064E05
  }

  /**
   * Restaura los indicadores de cambio de forma que el objeto queda como no alterado.
   * @return ORMCollection la propia instancia
   */
  public function reset()
  {
    // Bouml preserved body begin 00064D05
    $this->added = null;
    $this->removed = null;
    return $this;
    // Bouml preserved body end 00064D05
  }

  public function count()
  {
    // Bouml preserved body begin 00086405
    return count($this->elements);
    // Bouml preserved body end 00086405
  }

  final public function getAdded()
  {
    return $this->added;
  }

  final public function getRemoved()
  {
    return $this->removed;
  }

  public function offsetExists($offset)
  {
    // Bouml preserved body begin 0005E085
    //echo "Exist Offset: $offset?<br>";
    return isset($this->elements[$offset]);
    // Bouml preserved body end 0005E085
  }

  public function offsetGet($offset)
  {
    // Bouml preserved body begin 0005E105
    //echo "Get Offset: $offset<br>";
    if (isset($this->elements[$offset])) {
        return $this->elements[$offset];
    } else {
        return (false);
    }
    // Bouml preserved body end 0005E105
  }

  public function offsetSet($offset, $value)
  {
    // Bouml preserved body begin 0005E185
    //echo "Set Offset: $offset=$value<br>";
    if (isset($this->elements[$offset])) {
        $newValue = &$this->elements[$offset];
    } else {
        if (is_null($offset)) {
            foreach($this->elements as $elementKey=>$elementValue) {
                //Si el objeto ya se encuentra en la lista salgo. NO se admiten duplicados.
                if ($value == $elementValue)
                    return;
            }

            if (count($this->elements)==0) {
                $offset=0;
            } else {
                $offset = max(array_keys($this->elements))+1;
            }
        }
        $this->elements[$offset]=null;
        $newValue = &$this->elements[$offset];
        $this->added[]=&$this->elements[$offset];
    }
    if (is_array($value)) {
        $newValue = new ORMAttributes();
        foreach($value as $key => $data) {
            $newValue[$key]=$data;
        }
    } else {
        $newValue = $value;
    }
    // Bouml preserved body end 0005E185
  }

  public function offsetUnset($offset)
  {
    // Bouml preserved body begin 0005E205
    //echo "UnSet Offset: $offset<br>";
    if (isset($this->elements[$offset])) {
        $this->removed[]=$this->elements[$offset];
        unset($this->elements[$offset]);
        $this->elements=array_values($this->elements);
        //$this->elements=\array_slice($this->elements, $offset, 1, false);
    }
    // Bouml preserved body end 0005E205
  }

  public function getIterator()
  {
    // Bouml preserved body begin 0005E285
    return new ArrayIterator($this->elements);
    // Bouml preserved body end 0005E285
  }

  /**
   * Inicializa los arreglos internos
   * 
   * @return ORMCollection la colecci�n inicializada
   */
  public function __construct()
  {
    // Bouml preserved body begin 00086485
    $this->elements=array();
    $this->added=array();
    $this->removed=array();
    return $this;
    // Bouml preserved body end 00086485
  }

}
?>