<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/AbstractDataBase.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/PrivateAccesor.php';
require_once 'iplan/orm/ORMQuery.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * La clase ORM lleva referencias a todos los objetos recuperados o creados en la sesin y puede utilizarse para saber qu cosas estn cargadas y qu no.
 */
class ORM extends PrivateAccesor {
  /**
   * @staticvar ORM La variable de clase que almacena la instancia del SINGLETON.
   */
  private static $orm = null;

  /**
   * @var boolean flag que indica si las transacciones se guardan automticamente al terminarse la sesin o si los cambios se van a guardar explscitamente.
   */
  private $autosave = true;

  /**
   * @var boolean una variable que indica si los objetos al instanciarse se deben registrar o no con el ORM.
   */
  private $bindObjectsOnCreate = false;

  /**
   * @var boolean indica si se est ejecutando en modo debug
   */
  private $debug;

  /**
   * @var array una coleccin de objetos que constituyen la cach del ORM
   */
  private $objects = array();

  /**
   * @var AbstractDataBase la instancia de la abstraccin de la base de datos que el ORM debe utilizar
   */
  private $database;

  /**
   * Retorna la instancia de la clase. Implementacin del SINGLETON.
   * @return ORM La instancia de la base de datos.
   */
  public static function getInstance()
  {
    // Bouml preserved body begin 00049B05
    if (self::$orm==null) {
        self::$orm = new ORM();
    }
    return self::$orm;
    // Bouml preserved body end 00049B05
  }

  /**
   * Registra un objeto en la coleccin mantenida por ORM. Todos los objetos registrados son susceptibles de ser mantenidos automticamente; es decir: guardados, recuperados onFly, listados y estn disponibles para cualquier posible uso.
   */
  public function attach(&$object)
  {
    // Bouml preserved body begin 00029885
    $this->objects[get_class($object)][$object->getId()] = $object;
    $this->invokeMethod($object, "setORMState", array(ORM_STATUS::ATTACHED));
    // Bouml preserved body end 00029885
  }

  /**
   * Le indica al ORM que no se preocupe del estado de este objeto.
   */
  public function dettach(&$object)
  {
    // Bouml preserved body begin 00029905
    $class = get_class($object);
    if (isset($this->objects[$class]) && isset($this->objects[$class][$object->getId()])) {
        unset($this->objects[$class][$object->getId()]);
        $this->invokeMethod($object, "setORMState", array(ORM_STATUS::DETACHED));
    }
    // Bouml preserved body end 00029905
  }

  /**
   * Hace un guardado de todos los objetos modificados en la memoria.
   */
  public function commit()
  {
    // Bouml preserved body begin 00073E85
    // Bouml preserved body end 00073E85
  }

  /**
   * Devuelve la definicin de una clase u objeto.
   * @param String|Object $object el nombre de la clase o una instancia del objeto cuya definicin queremos obtener.
   * @return ORMDefinition la definicin del objeto
   */
  public function &getDefinition($object)
  {
    // Bouml preserved body begin 00044C05
    if (is_a($object, 'ORMObject')) {
        $class = get_class($object);
    } else { $class = $object; }
    
    if (!isset ($this->classDefinitions[$class])) {
        //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
        $params = array(&$this);
        $definition = $this->invokeStaticMethod($class, "define", $params);
        //$definition = $class::define($this); No es compatible con PHP 5.2.16
        $this->classDefinitions[$class]=$definition;
    }
    return $this->classDefinitions[$class];
    // Bouml preserved body end 00044C05
  }

  /**
   * Recupera un objeto de la cach del ORM
   * 
   * @param $class string|Object el nombre de la clase o una instancia del tipo de la clase que se quiere recuperar
   * @param $id int el identificador de la clase
   * @return DatabaseObject|false retorna la instancia de la cach o false si no se encuentra
   */
  public function &retrieve($class, $id)
  {
    // Bouml preserved body begin 00077485
    if (!is_numeric($id)) { krumo(debug_backtrace ()); }
    if (isset($this->objects[$class]) && isset($this->objects[$class][$id])) {
        return $this->objects[$class][$id];
    } else {
        $false = false;
        return $false;
    }
    // Bouml preserved body end 00077485
  }

  /**
   * Recupera objetos de la base de datos en base a su clase e ids. Puede recuperar uno o varios objetos a la vez.
   * 
   * @param string $class la clase a la que pertenece el objeto a levantar
   * @param int|array $id el id a recuperar o un array de ids
   * 
   * @return ORMObject|array de acuerdo a si se paso un id o un array de ids
   */
  public function &load($class, $id)
  {
    // Bouml preserved body begin 0004D405
    if (is_array($id)) {
        foreach($id as $identifier) {
            //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
            $params = array($identifier, &$this, $class);
            $definition = $this->invokeStaticMethod($class, "load", $params);
            //$result[] = $class::load($identifier, $this); No es compatible con PHP del server
        }
        return $result;
    } else {
        //Este moco es para "compatibilizar que el PHP no soporte el "$class::" para invocar métodos estáticos
        $params = array($id, &$this, $class);
        $obj = $this->invokeStaticMethod($class, "load", $params);
        return $obj;//No se retorna directo por problemas de "compatibilidad" con el PHP del server
        //return $class::load($id, $this); No es compatible con PHP del server
    }
    // Bouml preserved body end 0004D405
  }

  public function save(&$instance)
  {
    // Bouml preserved body begin 0004A085
    return $instance->save($this);
    // Bouml preserved body end 0004A085
  }

  /**
   * Borra fsicamente un objeto de la base. Al borrarse el objeto adems se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relacin M:N
   * 
   * @param ORMObject $object el objeto a eliminar.
   * 
   * @return boolean un booleando TRUE si la operacin fue concretada con xito o FALSE sino.
   */
  public function delete($object)
  {
    // Bouml preserved body begin 00089885
    return $object->delete();
    // Bouml preserved body end 00089885
  }

  private $classDefinitions;

  /**
   * @return AbstractDataBase una instancia de la base de datos que tiene configurada el ORM.
   */
  final public function getDatabase()
  {
    return $this->database;
  }

  /**
   * @param $value AbstractDataBase una instacia de la abstraccin de base de datos del ORM.
   */
  public function setDatabase($value)
  {
    $this->database = $value;
  }

  final public function getBindObjectsOnCreate()
  {
    return $this->bindObjectsOnCreate;
  }

  public function setBindObjectsOnCreate($value)
  {
    $this->bindObjectsOnCreate = $value;
  }

  final public function getAutosave()
  {
    return $this->autosave;
  }

  public function setAutosave($value)
  {
    $this->autosave = $value;
  }

  /**
   * SOLO PARA DEBUG, retorna la lista interna de atributos
   */
  public function getAttributes()
  {
    // Bouml preserved body begin 0008CC05
    return get_object_vars($this);
    // Bouml preserved body end 0008CC05
  }

  /**
   * Limpia la cach del ORM. OJO: esto no disocia los objetos del ORM. Eso se har despus.
   */
  public function clear()
  {
    // Bouml preserved body begin 0008CC85
    $this->classDefinitions = array();
    $this->objects = array();
    // Bouml preserved body end 0008CC85
  }

  final public function getObjects()
  {
    return $this->objects;
  }

  /**
   * Crea una query sobre la base de la clase pasada por parmetro.
   * 
   * @param string $class la clase a la que pertenecen las instancias a retornar.
   * 
   * @return ORMQuery Una instancia de una query que sirve para formalizar los criterios de bsqueda
   */
  public function query($class)
  {
    // Bouml preserved body begin 0009A305
    
    return new ORMQuery($class, $this);
    // Bouml preserved body end 0009A305
  }

  final public function getDebug()
  {
    return $this->debug;
  }

  public function setDebug($value)
  {
    $this->debug = $value;
  }

}
?>